/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.utilities.CanonicalPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorResourceFetcher
implements IValidatorResourceFetcher {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidatorResourceFetcher.class);
    private final FhirContext myFhirContext;
    private final DaoRegistry myDaoRegistry;
    private final VersionSpecificWorkerContextWrapper myVersionSpecificContextWrapper;

    public ValidatorResourceFetcher(FhirContext theFhirContext, IValidationSupport theValidationSupport, DaoRegistry theDaoRegistry) {
        this.myFhirContext = theFhirContext;
        this.myDaoRegistry = theDaoRegistry;
        this.myVersionSpecificContextWrapper = VersionSpecificWorkerContextWrapper.newVersionSpecificWorkerContextWrapper((IValidationSupport)theValidationSupport);
    }

    public Element fetch(IResourceValidator iResourceValidator, Object appContext, String theUrl) throws FHIRException {
        Object target;
        IdType id = new IdType(theUrl);
        String resourceType = id.getResourceType();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        try {
            target = dao.read((IIdType)id, (RequestDetails)appContext);
        }
        catch (ResourceNotFoundException e) {
            ourLog.info("Failed to resolve local reference: {}", (Object)theUrl);
            try {
                target = this.fetchByUrl(theUrl, dao, (RequestDetails)appContext);
            }
            catch (ResourceNotFoundException e2) {
                ourLog.info("Failed to find resource by URL: {}", (Object)theUrl);
                return null;
            }
        }
        try {
            return new JsonParser((IWorkerContext)this.myVersionSpecificContextWrapper).parse(this.myFhirContext.newJsonParser().encodeResourceToString(target), resourceType);
        }
        catch (Exception e) {
            throw new FHIRException(Msg.code((int)576) + e);
        }
    }

    private IBaseResource fetchByUrl(String url, IFhirResourceDao<?> dao, RequestDetails requestDetails) throws ResourceNotFoundException {
        CanonicalPair pair = new CanonicalPair(url);
        SearchParameterMap searchParameterMap = new SearchParameterMap();
        searchParameterMap.add("url", (IQueryParameterType)new UriParam(pair.getUrl()));
        String version = pair.getVersion();
        if (version != null && !version.isEmpty()) {
            searchParameterMap.add("version", (IQueryParameterType)new TokenParam(version));
        }
        List results = null;
        try {
            results = dao.search(searchParameterMap, requestDetails).getAllResources();
        }
        catch (InvalidRequestException e) {
            ourLog.info("Resource does not support 'url' or 'version' Search Parameters");
        }
        if (results != null && results.size() > 0) {
            if (results.size() > 1) {
                ourLog.warn(String.format("Multiple results found for URL '%s', only the first will be considered.", url));
            }
            return (IBaseResource)results.get(0);
        }
        throw new ResourceNotFoundException(Msg.code((int)2444) + "Failed to find resource by URL: " + url);
    }

    public boolean resolveURL(IResourceValidator iResourceValidator, Object o, String s, String s1, String s2, boolean isCanonical) {
        return true;
    }

    public byte[] fetchRaw(IResourceValidator iResourceValidator, String s) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Msg.code((int)577));
    }

    public IValidatorResourceFetcher setLocale(Locale locale) {
        return this;
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator validator, Object appContext, String url) throws URISyntaxException {
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator iResourceValidator, String s) {
        return false;
    }

    public Set<String> fetchCanonicalResourceVersions(IResourceValidator validator, Object appContext, String url) {
        return Collections.emptySet();
    }
}

