/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class PreviousVersionReader<T extends IBaseResource> {
    private final IFhirResourceDao<T> myDao;

    public PreviousVersionReader(IFhirResourceDao<T> theDao) {
        this.myDao = theDao;
    }

    public Optional<T> readPreviousVersion(T theResource) {
        return this.readPreviousVersion(theResource, false);
    }

    public Optional<T> readPreviousVersion(T theResource, boolean theDeletedOk) {
        Long currentVersion = theResource.getIdElement().getVersionIdPartAsLong();
        if (currentVersion == null || currentVersion == 1L) {
            return Optional.empty();
        }
        long previousVersion = currentVersion - 1L;
        IIdType previousId = theResource.getIdElement().withVersion(Long.toString(previousVersion));
        try {
            return Optional.ofNullable(this.myDao.read(previousId, (RequestDetails)new SystemRequestDetails(), theDeletedOk));
        }
        catch (ResourceGoneException e) {
            return Optional.empty();
        }
    }
}

