/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.api;

import ca.uhn.fhir.broker.api.BrokerConsumerClosedException;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.messaging.IMessage;

public interface IChannelConsumer<T>
extends AutoCloseable {
    public String getChannelName();

    public void start();

    @Override
    public void close();

    public boolean isClosed();

    public Class<? extends IMessage<T>> getMessageType();

    public IMessageListener<T> getMessageListener();

    default public void pause() {
        throw new UnsupportedOperationException(Msg.code((int)2655));
    }

    default public void resume() {
        throw new UnsupportedOperationException(Msg.code((int)2656));
    }

    default public void checkState() {
        if (this.isClosed()) {
            throw new BrokerConsumerClosedException(Msg.code((int)2657) + "Attempted to use a closed " + this.getClass().getSimpleName() + ": " + String.valueOf(this));
        }
    }
}

