/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.api;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.rest.server.messaging.IMessageDeliveryContext;
import jakarta.annotation.Nonnull;

public interface IRetryAwareMessageListener<T>
extends IMessageListener<T> {
    @Override
    default public void handleMessage(@Nonnull IMessage<T> theMessage) {
        IMessageDeliveryContext messageDeliveryContext = theMessage instanceof IMessageDeliveryContext ? (IMessageDeliveryContext)theMessage : () -> 0;
        IRetryAwareMessageListener.handleMessage(this, messageDeliveryContext, theMessage);
    }

    public void handleMessage(@Nonnull IMessageDeliveryContext var1, @Nonnull IMessage<T> var2);

    public static <P> void handleMessage(IMessageListener<P> theMessageListener, @Nonnull IMessageDeliveryContext theMessageDeliveryContext, IMessage<P> theMessage) {
        if (theMessageListener instanceof IRetryAwareMessageListener) {
            IRetryAwareMessageListener listener = (IRetryAwareMessageListener)theMessageListener;
            listener.handleMessage(theMessageDeliveryContext, theMessage);
        } else {
            theMessageListener.handleMessage(theMessage);
        }
    }
}

