/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.impl;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IBrokerClient;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IChannelNamer;
import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.jms.SpringMessagingMessageHandlerAdapter;
import ca.uhn.fhir.broker.jms.SpringMessagingProducerAdapter;
import ca.uhn.fhir.broker.jms.SpringMessagingReceiverAdapter;
import ca.uhn.fhir.jpa.subscription.channel.impl.LinkedBlockingChannel;
import ca.uhn.fhir.jpa.subscription.channel.impl.LinkedBlockingChannelFactory;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkedBlockingBrokerClient
implements IBrokerClient {
    private LinkedBlockingChannelFactory myLinkedBlockingChannelFactory;
    private final IChannelNamer myChannelNamer;

    public LinkedBlockingBrokerClient(IChannelNamer theChannelNamer) {
        this.myChannelNamer = theChannelNamer;
    }

    @Override
    public <T> IChannelConsumer<T> getOrCreateConsumer(String theChannelName, Class<? extends IMessage<T>> theMessageType, IMessageListener<T> theMessageListener, ChannelConsumerSettings theChannelConsumerSettings) {
        LinkedBlockingChannel springMessagingChannelReceiver = this.myLinkedBlockingChannelFactory.getOrCreateReceiver(theChannelName, theChannelConsumerSettings);
        SpringMessagingReceiverAdapter<T> retval = new SpringMessagingReceiverAdapter<T>(theMessageType, springMessagingChannelReceiver, theMessageListener);
        SpringMessagingMessageHandlerAdapter<T> handler = new SpringMessagingMessageHandlerAdapter<T>(theMessageType, theMessageListener);
        retval.subscribe(handler);
        return retval;
    }

    @Override
    public <T> IChannelProducer<T> getOrCreateProducer(String theChannelName, Class<? extends IMessage<T>> theMessageType, ChannelProducerSettings theChannelProducerSettings) {
        return new SpringMessagingProducerAdapter(theMessageType, this.myLinkedBlockingChannelFactory.getOrCreateProducer(theChannelName, theChannelProducerSettings));
    }

    @Override
    public IChannelNamer getChannelNamer() {
        return this.myChannelNamer;
    }

    @Autowired
    public void setLinkedBlockingChannelFactory(LinkedBlockingChannelFactory theLinkedBlockingChannelFactory) {
        this.myLinkedBlockingChannelFactory = theLinkedBlockingChannelFactory;
    }
}

