/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.impl;

import ca.uhn.fhir.broker.api.BrokerListenerClosedException;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.api.IRetryAwareMessageListener;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.rest.server.messaging.IMessageDeliveryContext;
import ca.uhn.fhir.util.IoUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingListener<T>
implements IRetryAwareMessageListener<T>,
AutoCloseable {
    private static final Logger ourLog = LoggerFactory.getLogger(MultiplexingListener.class);
    private final List<IMessageListener<T>> mySubListeners = new LinkedList<IMessageListener<T>>();
    private final Class<T> myPayloadType;
    private boolean myClosed;

    public MultiplexingListener(Class<T> thePayloadType) {
        this.myPayloadType = thePayloadType;
    }

    @Override
    public void handleMessage(@Nullable IMessageDeliveryContext theMessageDeliveryContext, @Nonnull IMessage<T> theMessage) {
        this.checkState();
        Class<?> messageClass = theMessage.getPayload().getClass();
        if (!this.getPayloadType().isAssignableFrom(messageClass)) {
            ourLog.warn("Received unexpected payload type. Expecting payload of type {}, but received payload of type {}. Skipping message.", this.getPayloadType(), messageClass);
            return;
        }
        this.mySubListeners.forEach(listener -> IRetryAwareMessageListener.handleMessage(listener, theMessageDeliveryContext, theMessage));
    }

    @Override
    public Class<T> getPayloadType() {
        return this.myPayloadType;
    }

    public boolean addListener(IMessageListener<T> theListener) {
        this.checkState();
        if (!this.getPayloadType().isAssignableFrom(theListener.getPayloadType())) {
            throw new ConfigurationException(Msg.code((int)2658) + "Expecting listener of type " + String.valueOf(this.getPayloadType()) + ". But listener was for type: " + String.valueOf(theListener.getPayloadType()));
        }
        return this.mySubListeners.add(theListener);
    }

    public boolean removeListener(IMessageListener<T> theListener) {
        return this.mySubListeners.remove(theListener);
    }

    @Override
    public void close() {
        this.mySubListeners.forEach(this::closeQuietly);
        this.mySubListeners.clear();
        this.myClosed = true;
    }

    private void closeQuietly(IMessageListener<T> theMessageListener) {
        if (theMessageListener instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)((Object)theMessageListener)), (Logger)ourLog);
        }
    }

    private void checkState() {
        if (this.myClosed) {
            throw new BrokerListenerClosedException(Msg.code((int)2659) + "Attempted to use a closed " + MultiplexingListener.class.getSimpleName());
        }
    }

    @VisibleForTesting
    public <L extends IMessageListener<T>> L getListenerOfTypeOrNull(Class<L> theMessageListenerClass) {
        for (IMessageListener<T> next : this.mySubListeners) {
            if (!theMessageListenerClass.isAssignableFrom(next.getClass())) continue;
            return (L)next;
        }
        return null;
    }
}

