/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.jms;

import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.api.RawStringMessage;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.GenericMessage;

public class SpringMessagingMessageHandlerAdapter<T>
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(SpringMessagingMessageHandlerAdapter.class);
    private final IMessageListener<T> myMessageListener;
    private final Class<? extends IMessage<T>> myMessageType;

    public SpringMessagingMessageHandlerAdapter(Class<? extends IMessage<T>> theMessageType, IMessageListener<T> theMessageListener) {
        this.myMessageListener = theMessageListener;
        this.myMessageType = theMessageType;
    }

    public void handleMessage(Message<?> theMessage) throws MessagingException {
        IMessage message;
        if (theMessage instanceof GenericMessage) {
            GenericMessage genericMessage = (GenericMessage)theMessage;
            Object payload = genericMessage.getPayload();
            if (payload instanceof byte[]) {
                byte[] bytes = (byte[])payload;
                message = new RawStringMessage(new String(bytes), (Map<String, ?>)genericMessage.getHeaders());
            } else {
                message = new RawStringMessage(payload.toString(), (Map<String, ?>)genericMessage.getHeaders());
            }
        } else if (IMessage.class.isAssignableFrom(theMessage.getClass())) {
            message = (IMessage)theMessage;
        } else {
            ourLog.warn("Received unexpected message type. Expecting message of type {}, but received message of type {}. Skipping message.", IMessage.class, theMessage.getClass());
            return;
        }
        if (!this.getMessageType().isAssignableFrom(message.getClass())) {
            ourLog.warn("Received unexpected message type. Expecting message of type {}, but received message of type {}. Skipping message.", this.getMessageType(), theMessage.getClass());
            return;
        }
        this.myMessageListener.handleMessage(message);
    }

    private Class<? extends IMessage<T>> getMessageType() {
        return this.myMessageType;
    }
}

