/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.jms;

import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.ISendResult;
import ca.uhn.fhir.broker.impl.SpringMessagingSendResult;
import ca.uhn.fhir.broker.jms.ISpringMessagingChannelProducer;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ChannelInterceptor;

public class SpringMessagingProducerAdapter<T>
implements IChannelProducer<T> {
    private final Class<? extends IMessage<T>> myMessageType;
    private final ISpringMessagingChannelProducer mySpringMessagingChannelProducer;

    public SpringMessagingProducerAdapter(Class<? extends IMessage<T>> theMessageType, ISpringMessagingChannelProducer theSpringMessagingChannelProducer) {
        this.myMessageType = theMessageType;
        this.mySpringMessagingChannelProducer = theSpringMessagingChannelProducer;
    }

    @Override
    public String getChannelName() {
        return "unknown legacy channel name";
    }

    @Override
    public ISendResult send(IMessage<T> theMessage) {
        if (!this.myMessageType.isAssignableFrom(theMessage.getClass())) {
            throw new ConfigurationException(Msg.code((int)2665) + "Expecting message of type " + String.valueOf(this.myMessageType) + ". But received message of type: " + String.valueOf(theMessage.getClass()));
        }
        if (!Message.class.isAssignableFrom(theMessage.getClass())) {
            throw new ConfigurationException(Msg.code((int)2664) + "Expecting message of type " + String.valueOf(Message.class) + ". But received message of type: " + String.valueOf(theMessage.getClass()));
        }
        Message message = (Message)theMessage;
        return new SpringMessagingSendResult(this.mySpringMessagingChannelProducer.send(message));
    }

    public void addInterceptor(ChannelInterceptor theInterceptor) {
        this.mySpringMessagingChannelProducer.addInterceptor(theInterceptor);
    }

    public ISpringMessagingChannelProducer getSpringMessagingProducer() {
        return this.mySpringMessagingChannelProducer;
    }

    public Class<? extends IMessage<T>> getMessageType() {
        return this.myMessageType;
    }
}

