/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.broker.jms;

import ca.uhn.fhir.broker.api.ChannelConsumerStartFailureException;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.jms.ISpringMessagingChannelReceiver;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.messaging.IMessage;
import ca.uhn.fhir.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.messaging.MessageHandler;

public class SpringMessagingReceiverAdapter<T>
implements IChannelConsumer<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(SpringMessagingReceiverAdapter.class);
    private final Class<? extends IMessage<T>> myMessageType;
    private final ISpringMessagingChannelReceiver mySpringMessagingChannelReceiver;
    private final IMessageListener<T> myMessageListener;
    private MessageHandler myMessageHandler;
    private boolean myClosed;

    public SpringMessagingReceiverAdapter(Class<? extends IMessage<T>> theMessageType, ISpringMessagingChannelReceiver theSpringMessagingChannelReceiver, IMessageListener<T> theMessageListener) {
        this.myMessageType = theMessageType;
        this.mySpringMessagingChannelReceiver = theSpringMessagingChannelReceiver;
        this.myMessageListener = theMessageListener;
    }

    public void subscribe(MessageHandler theMessageHandler) {
        this.checkState();
        if (this.myMessageHandler != null) {
            throw new IllegalArgumentException(Msg.code((int)2666) + "Only one subscriber allowed");
        }
        this.myMessageHandler = theMessageHandler;
        this.mySpringMessagingChannelReceiver.subscribe(theMessageHandler);
    }

    @Override
    public void close() {
        this.myClosed = true;
        if (this.myMessageHandler != null) {
            this.mySpringMessagingChannelReceiver.unsubscribe(this.myMessageHandler);
            this.closeAndDestroyQuietly(this.myMessageHandler);
        }
        this.destroyQuietly(this.mySpringMessagingChannelReceiver);
        this.closeQuietly(this.myMessageListener);
    }

    private void closeAndDestroyQuietly(MessageHandler theMessageHandler) {
        if (theMessageHandler instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)theMessageHandler), (Logger)ourLog);
        }
        if (theMessageHandler instanceof DisposableBean) {
            try {
                ((DisposableBean)theMessageHandler).destroy();
            }
            catch (Exception e) {
                throw new InternalErrorException(Msg.code((int)2647) + "Failed to destroy MessageHandler", (Throwable)e);
            }
        }
    }

    private void destroyQuietly(ISpringMessagingChannelReceiver theSpringMessagingChannelReceiver) {
        try {
            theSpringMessagingChannelReceiver.destroy();
        }
        catch (Exception e) {
            ourLog.error("Error destroying Spring Messaging ChannelReceiver", (Throwable)e);
        }
    }

    private void closeQuietly(IMessageListener<T> theMessageListener) {
        if (theMessageListener instanceof AutoCloseable) {
            IoUtils.closeQuietly((AutoCloseable)((AutoCloseable)((Object)theMessageListener)), (Logger)ourLog);
        }
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public String getChannelName() {
        return this.mySpringMessagingChannelReceiver.getChannelName();
    }

    @Override
    public void start() throws ChannelConsumerStartFailureException {
        this.checkState();
        this.mySpringMessagingChannelReceiver.start();
    }

    public ISpringMessagingChannelReceiver getSpringMessagingChannelReceiver() {
        return this.mySpringMessagingChannelReceiver;
    }

    @Override
    public Class<? extends IMessage<T>> getMessageType() {
        return this.myMessageType;
    }

    @Override
    public IMessageListener<T> getMessageListener() {
        return this.myMessageListener;
    }

    @Override
    public void pause() {
        this.mySpringMessagingChannelReceiver.pause();
    }

    @Override
    public void resume() {
        this.checkState();
        this.mySpringMessagingChannelReceiver.resume();
    }
}

