/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cache;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.retry.Retrier;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.util.IResourceRepositoryCache;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

public abstract class BaseResourceCacheSynchronizer
implements IResourceChangeListener,
IResourceRepositoryCache {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseResourceCacheSynchronizer.class);
    public static final int MAX_RETRIES = 60;
    public static final long REFRESH_INTERVAL = 60000L;
    private static final long FORCE_REFRESH_TIMEOUT_SECONDS = 300L;
    private final String myResourceName;
    @Autowired
    private IResourceChangeListenerRegistry myResourceChangeListenerRegistry;
    @Autowired
    private DaoRegistry myDaoRegistry;
    private SearchParameterMap mySearchParameterMap;
    private final SystemRequestDetails mySystemRequestDetails = SystemRequestDetails.forAllPartitions();
    private boolean myStopping;
    private final Semaphore mySyncResourcesSemaphore = new Semaphore(1);
    private final Object mySyncResourcesLock = new Object();
    private Integer myMaxRetryCount = null;
    private boolean myInitialized = false;

    protected BaseResourceCacheSynchronizer(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    protected BaseResourceCacheSynchronizer(String theResourceName, IResourceChangeListenerRegistry theResourceChangeListenerRegistry, DaoRegistry theDaoRegistry) {
        this.myResourceName = theResourceName;
        this.myDaoRegistry = theDaoRegistry;
        this.myResourceChangeListenerRegistry = theResourceChangeListenerRegistry;
    }

    @EventListener(classes={ContextRefreshedEvent.class})
    @Order(value=310)
    public void registerListener() {
        if (this.myInitialized) {
            return;
        }
        if (this.myDaoRegistry.getResourceDaoOrNull(this.myResourceName) == null) {
            ourLog.info("No resource DAO found for resource type {}, not registering listener", (Object)this.myResourceName);
            return;
        }
        IResourceChangeListenerCache resourceCache = this.myResourceChangeListenerRegistry.registerResourceResourceChangeListener(this.myResourceName, this.provideSearchParameterMap(), (IResourceChangeListener)this, 60000L);
        resourceCache.forceRefresh();
        this.myInitialized = true;
    }

    private SearchParameterMap provideSearchParameterMap() {
        SearchParameterMap searchParameterMap = this.mySearchParameterMap;
        if (searchParameterMap == null) {
            this.mySearchParameterMap = searchParameterMap = this.getSearchParameterMap();
        }
        return searchParameterMap;
    }

    @PreDestroy
    public void unregisterListener() {
        this.myResourceChangeListenerRegistry.unregisterResourceResourceChangeListener((IResourceChangeListener)this);
    }

    private boolean daoNotAvailable() {
        return this.myDaoRegistry == null || !this.myDaoRegistry.isResourceTypeSupported(this.myResourceName);
    }

    public void requestRefresh() {
        if (this.daoNotAvailable()) {
            return;
        }
        if (!this.mySyncResourcesSemaphore.tryAcquire()) {
            return;
        }
        try {
            this.doSyncResourcesWithRetry();
        }
        finally {
            this.mySyncResourcesSemaphore.release();
        }
    }

    @VisibleForTesting
    public void forceRefresh() {
        block7: {
            if (this.daoNotAvailable()) {
                throw new ConfigurationException(Msg.code((int)2652) + "Attempt to force refresh without a dao");
            }
            try {
                if (this.mySyncResourcesSemaphore.tryAcquire(300L, TimeUnit.SECONDS)) {
                    this.doSyncResourcesWithRetry();
                    break block7;
                }
                String errorMessage = String.format(Msg.code((int)2653) + "Timed out waiting %s %s to refresh %s cache", 300L, "seconds", this.myResourceName);
                ourLog.error(errorMessage);
                throw new ConfigurationException(Msg.code((int)2663) + errorMessage);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InternalErrorException(Msg.code((int)2654) + String.valueOf(e));
            }
            finally {
                this.mySyncResourcesSemaphore.release();
            }
        }
    }

    @VisibleForTesting
    public void acquireSemaphoreForUnitTest() throws InterruptedException {
        this.mySyncResourcesSemaphore.acquire();
    }

    @VisibleForTesting
    public int doSyncResourcesForUnitTest() {
        int first = this.doSyncResourcesWithRetry();
        int second = this.doSyncResourcesWithRetry();
        return first + second;
    }

    synchronized int doSyncResourcesWithRetry() {
        Retrier syncResourceRetrier = new Retrier(this::doSyncResources, this.getMaxRetries());
        return (Integer)syncResourceRetrier.runWithRetry();
    }

    private int getMaxRetries() {
        if (this.myMaxRetryCount != null) {
            return this.myMaxRetryCount;
        }
        return 60;
    }

    @VisibleForTesting
    public void setMaxRetries(Integer theMaxRetries) {
        this.myMaxRetryCount = theMaxRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doSyncResources() {
        if (this.isStopping()) {
            return 0;
        }
        Object object = this.mySyncResourcesLock;
        synchronized (object) {
            ourLog.debug("Starting sync {}s", (Object)this.myResourceName);
            List<IBaseResource> resourceList = this.getResourceDao().searchForResources(this.provideSearchParameterMap(), (RequestDetails)this.mySystemRequestDetails);
            return this.syncResourcesIntoCache(resourceList);
        }
    }

    protected abstract int syncResourcesIntoCache(@Nonnull List<IBaseResource> var1);

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        this.myStopping = false;
    }

    @EventListener(value={ContextClosedEvent.class})
    public void shutdown() {
        this.myStopping = true;
    }

    private boolean isStopping() {
        return this.myStopping;
    }

    private IFhirResourceDao<?> getResourceDao() {
        return this.myDaoRegistry.getResourceDao(this.myResourceName);
    }

    public void handleInit(@Nonnull Collection<IIdType> theResourceIds) {
        if (this.daoNotAvailable()) {
            ourLog.warn("The resource type {} is enabled on this server, but there is no {} DAO configured.", (Object)this.myResourceName, (Object)this.myResourceName);
            return;
        }
        IFhirResourceDao<?> resourceDao = this.getResourceDao();
        SystemRequestDetails systemRequestDetails = SystemRequestDetails.forAllPartitions();
        ArrayList<IBaseResource> resourceList = new ArrayList<IBaseResource>();
        for (IIdType id : theResourceIds) {
            Object read;
            try {
                read = resourceDao.read(id, (RequestDetails)systemRequestDetails);
            }
            catch (BaseServerResponseException e) {
                ourLog.warn("Unable to fetch resource {}", (Object)id, (Object)e);
                continue;
            }
            resourceList.add((IBaseResource)read);
        }
        this.handleInit((List<IBaseResource>)resourceList);
    }

    protected abstract void handleInit(@Nonnull List<IBaseResource> var1);

    public void handleChange(@Nonnull IResourceChangeEvent theResourceChangeEvent) {
        this.requestRefresh();
    }

    @Nonnull
    protected abstract SearchParameterMap getSearchParameterMap();
}

