/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.config;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.model.HistoryCountModeEnum;
import ca.uhn.fhir.jpa.api.model.WarmCacheEntry;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.system.HapiSystemProperties;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaStorageSettings
extends StorageSettings {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaStorageSettings.class);
    public static final long DEFAULT_BULK_EXPORT_MAXIMUM_WORK_CHUNK_SIZE = 0x6400000L;
    public static final Long DEFAULT_REUSE_CACHED_SEARCH_RESULTS_FOR_MILLIS = 60000L;
    public static final Long DEFAULT_TRANSLATION_CACHES_EXPIRE_AFTER_WRITE_IN_MINUTES = 60L;
    public static final Set<String> DEFAULT_BUNDLE_TYPES_ALLOWED_FOR_STORAGE = Collections.unmodifiableSet(new TreeSet(Sets.newHashSet((Object[])new String[]{Bundle.BundleType.COLLECTION.toCode(), Bundle.BundleType.DOCUMENT.toCode(), Bundle.BundleType.MESSAGE.toCode()})));
    public static final int DEFAULT_MAX_EXPANSION_SIZE = 1000;
    public static final HistoryCountModeEnum DEFAULT_HISTORY_COUNT_MODE = HistoryCountModeEnum.CACHED_ONLY_WITHOUT_OFFSET;
    public static final boolean DEFAULT_ENABLE_TASKS = true;
    public static final int DEFAULT_MAXIMUM_INCLUDES_TO_LOAD_PER_PAGE = 1000;
    public static final int DEFAULT_EXPUNGE_BATCH_SIZE = 800;
    public static final int DEFAULT_BUNDLE_BATCH_QUEUE_CAPACITY = 200;
    public static final int DEFAULT_BULK_EXPORT_FILE_MAXIMUM_CAPACITY = 1000;
    private static final Integer DEFAULT_MAXIMUM_SEARCH_RESULT_COUNT_IN_TRANSACTION = null;
    private static final int DEFAULT_REINDEX_BATCH_SIZE = 800;
    private static final int DEFAULT_MAXIMUM_DELETE_CONFLICT_COUNT = 60;
    private static final Integer DEFAULT_INTERNAL_SYNCHRONOUS_SEARCH_SIZE = 10000;
    private static final boolean DEFAULT_PREVENT_INVALIDATING_CONDITIONAL_MATCH_CRITERIA = false;
    private static final long DEFAULT_REST_DELETE_BY_URL_RESOURCE_ID_THRESHOLD = 10000L;
    public static final String DEFAULT_MAX_TRANSACTION_ENTRIES_FOR_WRITE_STRING = "10000";
    public static final int DEFAULT_MAX_TRANSACTION_ENTRIES_FOR_WRITE = Integer.parseInt("10000");
    public static final String DEFAULT_TRANSACTION_ENTRIES_FOR_WRITE_STRING = "1024";
    public static final int DEFAULT_TRANSACTION_ENTRIES_FOR_WRITE = Integer.parseInt("1024");
    public static final List<Integer> DEFAULT_SEARCH_PRE_FETCH_THRESHOLDS = Arrays.asList(13, 503, 2003, 1000003, -1);
    private final int myPreExpandValueSetsDefaultOffset = 0;
    @Nonnull
    private final Long myTranslationCachesExpireAfterWriteInMinutes = DEFAULT_TRANSLATION_CACHES_EXPIRE_AFTER_WRITE_IN_MINUTES;
    @Nullable
    private Integer myMaximumIncludesToLoadPerPage = 1000;
    private boolean myAllowInlineMatchUrlReferences = true;
    private boolean myAllowMultipleDelete;
    private int myDeferIndexingForCodesystemsOfSize = 100;
    private boolean myDeleteStaleSearches = true;
    private boolean myEnforceReferentialIntegrityOnDelete = true;
    private Set<String> myEnforceReferentialIntegrityOnDeleteDisableForPaths = Collections.emptySet();
    private boolean myUniqueIndexesEnabled = true;
    private boolean myUniqueIndexesCheckedBeforeSave = true;
    private boolean myEnforceReferentialIntegrityOnWrite = true;
    private SearchTotalModeEnum myDefaultTotalMode = null;
    private int myEverythingIncludesFetchPageSize = 50;
    private long myExpireSearchResultsAfterMillis = 3600000L;
    private Integer myFetchSizeDefaultMaximum = null;
    private int myMaximumExpansionSize = 1000;
    private Integer myMaximumSearchResultCountInTransaction = DEFAULT_MAXIMUM_SEARCH_RESULT_COUNT_IN_TRANSACTION;
    private ResourceEncodingEnum myResourceEncoding = ResourceEncodingEnum.JSONC;
    private Integer myResourceMetaCountHardLimit = 1000;
    private Long myReuseCachedSearchResultsForMillis = DEFAULT_REUSE_CACHED_SEARCH_RESULTS_FOR_MILLIS;
    private boolean mySchedulingDisabled;
    private boolean mySuppressUpdatesWithNoChange = true;
    private Integer myCacheControlNoStoreMaxResultsUpperLimit = 1000;
    private Integer myCountSearchResultsUpTo = null;
    private boolean myStatusBasedReindexingDisabled;
    private IdStrategyEnum myResourceServerIdStrategy = IdStrategyEnum.SEQUENTIAL_NUMERIC;
    private boolean myMarkResourcesForReindexingUponSearchParameterChange;
    private boolean myExpungeEnabled;
    private boolean myDeleteExpungeEnabled;
    private int myExpungeBatchSize = 800;
    private int myReindexThreadCount;
    private int myExpungeThreadCount;
    private Set<String> myBundleTypesAllowedForStorage;
    private boolean myValidateSearchParameterExpressionsOnSave = true;
    private List<Integer> mySearchPreFetchThresholds = DEFAULT_SEARCH_PRE_FETCH_THRESHOLDS;
    private List<WarmCacheEntry> myWarmCacheEntries = new ArrayList<WarmCacheEntry>();
    private boolean myEnforceReferenceTargetTypes = true;
    private ClientIdStrategyEnum myResourceClientIdStrategy = ClientIdStrategyEnum.ALPHANUMERIC;
    private boolean myFilterParameterEnabled = false;
    private StoreMetaSourceInformationEnum myStoreMetaSourceInformation = StoreMetaSourceInformationEnum.SOURCE_URI_AND_REQUEST_ID;
    private HistoryCountModeEnum myHistoryCountMode = DEFAULT_HISTORY_COUNT_MODE;
    private int myInternalSynchronousSearchSize = DEFAULT_INTERNAL_SYNCHRONOUS_SEARCH_SIZE;
    private Integer myMaximumDeleteConflictQueryCount = 60;
    private boolean myPreExpandValueSets = true;
    private int myPreExpandValueSetsDefaultCount = 1000;
    private int myPreExpandValueSetsMaxCount = 1000;
    private boolean myPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets = true;
    private boolean myDeleteEnabled = true;
    private boolean myLastNEnabled = false;
    private boolean myMatchUrlCacheEnabled;
    private boolean myEnableTaskBulkImportJobExecution;
    private boolean myEnableTaskStaleSearchCleanup;
    private boolean myEnableTaskPreExpandValueSets;
    private boolean myEnableTaskResourceReindexing;
    private boolean myEnableTaskBulkExportJobExecution;
    private boolean myAccountForDateIndexNulls;
    private String myHSearchIndexPrefix;
    private boolean myHibernateSearchIndexSearchParams = false;
    private boolean myStoreResourceInHSearchIndex;
    private boolean myConcurrentBundleValidation;
    private boolean myAllowAutoInflateBinaries = true;
    private long myAutoInflateBinariesMaximumBytes = 0xA00000L;
    private int myBulkExportFileRetentionPeriodHours = 2;
    private boolean myEnableBulkExportJobReuse = true;
    private boolean myUpdateWithHistoryRewriteEnabled = false;
    private boolean myPreserveRequestIdInResourceBody = false;
    private int myBulkExportFileMaximumCapacity = 1000;
    private long myBulkExportFileMaximumSize = 0x6400000L;
    private boolean myJobFastTrackingEnabled = false;
    private boolean myNonResourceDbHistoryEnabled = true;
    private boolean myResourceHistoryDbEnabled = true;
    @Nonnull
    private IValidationSupport.IssueSeverity myIssueSeverityForCodeDisplayMismatch = IValidationSupport.IssueSeverity.WARNING;
    private boolean myPreventInvalidatingConditionalMatchCriteria = false;
    private long myRestDeleteByUrlResourceIdThreshold = 10000L;
    private boolean myWriteToLegacyLobColumns = false;
    private boolean myAccessMetaSourceInformationFromProvenanceTable = false;
    @Beta
    private boolean myIncludeHashIdentityForTokenSearches = false;
    private int myMaxTransactionEntriesForWrite = DEFAULT_MAX_TRANSACTION_ENTRIES_FOR_WRITE;
    private int myDefaultTransactionEntriesForWrite = DEFAULT_TRANSACTION_ENTRIES_FOR_WRITE;
    private boolean myWriteToSearchParamIdentityTable = true;

    public JpaStorageSettings() {
        this.setMarkResourcesForReindexingUponSearchParameterChange(true);
        this.setReindexThreadCount(Runtime.getRuntime().availableProcessors());
        this.setExpungeThreadCount(Runtime.getRuntime().availableProcessors());
        this.setBundleTypesAllowedForStorage(DEFAULT_BUNDLE_TYPES_ALLOWED_FOR_STORAGE);
        this.setEnableTaskBulkImportJobExecution(true);
        this.setEnableTaskBulkExportJobExecution(true);
        this.setEnableTaskStaleSearchCleanup(true);
        this.setEnableTaskPreExpandValueSets(true);
        this.setEnableTaskResourceReindexing(true);
        if (HapiSystemProperties.isDisableStatusBasedReindex()) {
            ourLog.info("Status based reindexing is DISABLED");
            this.setStatusBasedReindexingDisabled(true);
        }
        if (HapiSystemProperties.isUnitTestModeEnabled()) {
            this.setJobFastTrackingEnabled(true);
        }
        if (HapiSystemProperties.isPreventInvalidatingConditionalMatchCriteria()) {
            this.setPreventInvalidatingConditionalMatchCriteria(true);
        }
    }

    public boolean isIncludeHashIdentityForTokenSearches() {
        return this.myIncludeHashIdentityForTokenSearches;
    }

    public void setIncludeHashIdentityForTokenSearches(boolean theIncludeHashIdentityForTokenSearches) {
        this.myIncludeHashIdentityForTokenSearches = theIncludeHashIdentityForTokenSearches;
    }

    @Deprecated
    public int getInlineResourceTextBelowSize() {
        return 0;
    }

    @Deprecated
    public void setInlineResourceTextBelowSize(int theInlineResourceTextBelowSize) {
    }

    @Nullable
    public Integer getMaximumIncludesToLoadPerPage() {
        return this.myMaximumIncludesToLoadPerPage;
    }

    public void setMaximumIncludesToLoadPerPage(@Nullable Integer theMaximumIncludesToLoadPerPage) {
        this.myMaximumIncludesToLoadPerPage = theMaximumIncludesToLoadPerPage;
    }

    public HistoryCountModeEnum getHistoryCountMode() {
        return this.myHistoryCountMode;
    }

    public void setHistoryCountMode(@Nonnull HistoryCountModeEnum theHistoryCountMode) {
        Validate.notNull((Object)((Object)theHistoryCountMode), (String)"theHistoryCountMode must not be null", (Object[])new Object[0]);
        this.myHistoryCountMode = theHistoryCountMode;
    }

    public boolean isLastNEnabled() {
        return this.myLastNEnabled;
    }

    public void setLastNEnabled(boolean theLastNEnabled) {
        this.myLastNEnabled = theLastNEnabled;
    }

    @Nonnull
    public Long getTranslationCachesExpireAfterWriteInMinutes() {
        return this.myTranslationCachesExpireAfterWriteInMinutes;
    }

    @Deprecated
    public boolean getMatchUrlCache() {
        return this.myMatchUrlCacheEnabled;
    }

    @Deprecated
    public void setMatchUrlCache(boolean theMatchUrlCache) {
        this.myMatchUrlCacheEnabled = theMatchUrlCache;
    }

    public boolean isMatchUrlCacheEnabled() {
        return this.getMatchUrlCache();
    }

    public void setMatchUrlCacheEnabled(boolean theMatchUrlCache) {
        this.setMatchUrlCache(theMatchUrlCache);
    }

    public boolean isEnforceReferenceTargetTypes() {
        return this.myEnforceReferenceTargetTypes;
    }

    public void setEnforceReferenceTargetTypes(boolean theEnforceReferenceTargetTypes) {
        this.myEnforceReferenceTargetTypes = theEnforceReferenceTargetTypes;
    }

    public SearchTotalModeEnum getDefaultTotalMode() {
        return this.myDefaultTotalMode;
    }

    public void setDefaultTotalMode(SearchTotalModeEnum theDefaultTotalMode) {
        this.myDefaultTotalMode = theDefaultTotalMode;
    }

    public List<WarmCacheEntry> getWarmCacheEntries() {
        if (this.myWarmCacheEntries == null) {
            this.myWarmCacheEntries = new ArrayList<WarmCacheEntry>();
        }
        return this.myWarmCacheEntries;
    }

    public void setWarmCacheEntries(List<WarmCacheEntry> theWarmCacheEntries) {
        this.myWarmCacheEntries = theWarmCacheEntries;
    }

    public boolean isStatusBasedReindexingDisabled() {
        return this.myStatusBasedReindexingDisabled;
    }

    public void setStatusBasedReindexingDisabled(boolean theStatusBasedReindexingDisabled) {
        this.myStatusBasedReindexingDisabled = theStatusBasedReindexingDisabled;
    }

    public Set<String> getBundleTypesAllowedForStorage() {
        return this.myBundleTypesAllowedForStorage;
    }

    public void setBundleTypesAllowedForStorage(Set<String> theBundleTypesAllowedForStorage) {
        Validate.notNull(theBundleTypesAllowedForStorage, (String)"theBundleTypesAllowedForStorage must not be null", (Object[])new Object[0]);
        this.myBundleTypesAllowedForStorage = theBundleTypesAllowedForStorage;
    }

    public Integer getCacheControlNoStoreMaxResultsUpperLimit() {
        return this.myCacheControlNoStoreMaxResultsUpperLimit;
    }

    public void setCacheControlNoStoreMaxResultsUpperLimit(Integer theCacheControlNoStoreMaxResults) {
        this.myCacheControlNoStoreMaxResultsUpperLimit = theCacheControlNoStoreMaxResults;
    }

    public Integer getCountSearchResultsUpTo() {
        return this.myCountSearchResultsUpTo;
    }

    public void setCountSearchResultsUpTo(Integer theCountSearchResultsUpTo) {
        this.myCountSearchResultsUpTo = theCountSearchResultsUpTo;
    }

    public int getDeferIndexingForCodesystemsOfSize() {
        return this.myDeferIndexingForCodesystemsOfSize;
    }

    public void setDeferIndexingForCodesystemsOfSize(int theDeferIndexingForCodesystemsOfSize) {
        this.myDeferIndexingForCodesystemsOfSize = theDeferIndexingForCodesystemsOfSize;
    }

    public int getEverythingIncludesFetchPageSize() {
        return this.myEverythingIncludesFetchPageSize;
    }

    public void setEverythingIncludesFetchPageSize(int theEverythingIncludesFetchPageSize) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)theEverythingIncludesFetchPageSize);
        this.myEverythingIncludesFetchPageSize = theEverythingIncludesFetchPageSize;
    }

    public long getExpireSearchResultsAfterMillis() {
        return this.myExpireSearchResultsAfterMillis;
    }

    public void setExpireSearchResultsAfterMillis(long theExpireSearchResultsAfterMillis) {
        this.myExpireSearchResultsAfterMillis = theExpireSearchResultsAfterMillis;
    }

    public Integer getFetchSizeDefaultMaximum() {
        return this.myFetchSizeDefaultMaximum;
    }

    public void setFetchSizeDefaultMaximum(Integer theFetchSizeDefaultMaximum) {
        this.myFetchSizeDefaultMaximum = theFetchSizeDefaultMaximum;
    }

    public int getMaximumExpansionSize() {
        return this.myMaximumExpansionSize;
    }

    public void setMaximumExpansionSize(int theMaximumExpansionSize) {
        Validate.isTrue((theMaximumExpansionSize > 0 ? 1 : 0) != 0, (String)"theMaximumExpansionSize must be > 0", (Object[])new Object[0]);
        this.myMaximumExpansionSize = theMaximumExpansionSize;
    }

    public Integer getMaximumSearchResultCountInTransaction() {
        return this.myMaximumSearchResultCountInTransaction;
    }

    public void setMaximumSearchResultCountInTransaction(Integer theMaximumSearchResultCountInTransaction) {
        this.myMaximumSearchResultCountInTransaction = theMaximumSearchResultCountInTransaction;
    }

    public int getReindexThreadCount() {
        return this.myReindexThreadCount;
    }

    public void setReindexThreadCount(int theReindexThreadCount) {
        this.myReindexThreadCount = theReindexThreadCount;
        this.myReindexThreadCount = Math.max(this.myReindexThreadCount, 1);
    }

    public int getExpungeThreadCount() {
        return this.myExpungeThreadCount;
    }

    public void setExpungeThreadCount(int theExpungeThreadCount) {
        this.myExpungeThreadCount = theExpungeThreadCount;
        this.myExpungeThreadCount = Math.max(this.myExpungeThreadCount, 1);
    }

    public ResourceEncodingEnum getResourceEncoding() {
        return this.myResourceEncoding;
    }

    public void setResourceEncoding(ResourceEncodingEnum theResourceEncoding) {
        this.myResourceEncoding = theResourceEncoding;
    }

    public Integer getResourceMetaCountHardLimit() {
        return this.myResourceMetaCountHardLimit;
    }

    public void setResourceMetaCountHardLimit(Integer theResourceMetaCountHardLimit) {
        this.myResourceMetaCountHardLimit = theResourceMetaCountHardLimit;
    }

    public ClientIdStrategyEnum getResourceClientIdStrategy() {
        return this.myResourceClientIdStrategy;
    }

    public void setResourceClientIdStrategy(ClientIdStrategyEnum theResourceClientIdStrategy) {
        Validate.notNull((Object)((Object)theResourceClientIdStrategy), (String)"theClientIdStrategy must not be null", (Object[])new Object[0]);
        this.myResourceClientIdStrategy = theResourceClientIdStrategy;
    }

    public IdStrategyEnum getResourceServerIdStrategy() {
        return this.myResourceServerIdStrategy;
    }

    public void setResourceServerIdStrategy(IdStrategyEnum theResourceIdStrategy) {
        Validate.notNull((Object)((Object)theResourceIdStrategy), (String)"theResourceIdStrategy must not be null", (Object[])new Object[0]);
        this.myResourceServerIdStrategy = theResourceIdStrategy;
    }

    public Long getReuseCachedSearchResultsForMillis() {
        return this.myReuseCachedSearchResultsForMillis;
    }

    public void setReuseCachedSearchResultsForMillis(Long theReuseCachedSearchResultsForMillis) {
        this.myReuseCachedSearchResultsForMillis = theReuseCachedSearchResultsForMillis;
    }

    public boolean isAllowInlineMatchUrlReferences() {
        return this.myAllowInlineMatchUrlReferences;
    }

    public void setAllowInlineMatchUrlReferences(boolean theAllowInlineMatchUrlReferences) {
        this.myAllowInlineMatchUrlReferences = theAllowInlineMatchUrlReferences;
    }

    public boolean isAllowMultipleDelete() {
        return this.myAllowMultipleDelete;
    }

    public void setAllowMultipleDelete(boolean theAllowMultipleDelete) {
        this.myAllowMultipleDelete = theAllowMultipleDelete;
    }

    public boolean isPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets() {
        return this.myPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets;
    }

    public void setPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets(boolean thePopulateIdentifierInAutoCreatedPlaceholderReferenceTargets) {
        this.myPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets = thePopulateIdentifierInAutoCreatedPlaceholderReferenceTargets;
    }

    public boolean isEnforceReferentialIntegrityOnDelete() {
        return this.myEnforceReferentialIntegrityOnDelete;
    }

    public void setEnforceReferentialIntegrityOnDelete(boolean theEnforceReferentialIntegrityOnDelete) {
        this.myEnforceReferentialIntegrityOnDelete = theEnforceReferentialIntegrityOnDelete;
    }

    public Set<String> getEnforceReferentialIntegrityOnDeleteDisableForPaths() {
        return this.myEnforceReferentialIntegrityOnDeleteDisableForPaths;
    }

    public void setEnforceReferentialIntegrityOnDeleteDisableForPaths(Set<String> theEnforceReferentialIntegrityOnDeleteDisableForPaths) {
        this.myEnforceReferentialIntegrityOnDeleteDisableForPaths = theEnforceReferentialIntegrityOnDeleteDisableForPaths;
    }

    public boolean isEnforceReferentialIntegrityOnWrite() {
        return this.myEnforceReferentialIntegrityOnWrite;
    }

    public void setEnforceReferentialIntegrityOnWrite(boolean theEnforceReferentialIntegrityOnWrite) {
        this.myEnforceReferentialIntegrityOnWrite = theEnforceReferentialIntegrityOnWrite;
    }

    public boolean isExpireSearchResults() {
        return this.myDeleteStaleSearches;
    }

    public void setExpireSearchResults(boolean theDeleteStaleSearches) {
        this.myDeleteStaleSearches = theDeleteStaleSearches;
    }

    public boolean isExpungeEnabled() {
        return this.myExpungeEnabled;
    }

    public void setExpungeEnabled(boolean theExpungeEnabled) {
        this.myExpungeEnabled = theExpungeEnabled;
    }

    public boolean isDeleteExpungeEnabled() {
        return this.myDeleteExpungeEnabled;
    }

    public void setDeleteExpungeEnabled(boolean theDeleteExpungeEnabled) {
        this.myDeleteExpungeEnabled = theDeleteExpungeEnabled;
    }

    public int getExpungeBatchSize() {
        return this.myExpungeBatchSize;
    }

    public void setExpungeBatchSize(int theExpungeBatchSize) {
        this.myExpungeBatchSize = theExpungeBatchSize;
    }

    public boolean isMarkResourcesForReindexingUponSearchParameterChange() {
        return this.myMarkResourcesForReindexingUponSearchParameterChange;
    }

    public void setMarkResourcesForReindexingUponSearchParameterChange(boolean theMarkResourcesForReindexingUponSearchParameterChange) {
        this.myMarkResourcesForReindexingUponSearchParameterChange = theMarkResourcesForReindexingUponSearchParameterChange;
    }

    public boolean isSchedulingDisabled() {
        return this.mySchedulingDisabled;
    }

    public void setSchedulingDisabled(boolean theSchedulingDisabled) {
        this.mySchedulingDisabled = theSchedulingDisabled;
    }

    public boolean isSuppressUpdatesWithNoChange() {
        return this.mySuppressUpdatesWithNoChange;
    }

    public void setSuppressUpdatesWithNoChange(boolean theSuppressUpdatesWithNoChange) {
        this.mySuppressUpdatesWithNoChange = theSuppressUpdatesWithNoChange;
    }

    public boolean isUniqueIndexesCheckedBeforeSave() {
        return this.myUniqueIndexesCheckedBeforeSave;
    }

    public void setUniqueIndexesCheckedBeforeSave(boolean theUniqueIndexesCheckedBeforeSave) {
        this.myUniqueIndexesCheckedBeforeSave = theUniqueIndexesCheckedBeforeSave;
    }

    public boolean isUniqueIndexesEnabled() {
        return this.myUniqueIndexesEnabled;
    }

    public void setUniqueIndexesEnabled(boolean theUniqueIndexesEnabled) {
        this.myUniqueIndexesEnabled = theUniqueIndexesEnabled;
    }

    public boolean isValidateSearchParameterExpressionsOnSave() {
        return this.myValidateSearchParameterExpressionsOnSave;
    }

    public void setValidateSearchParameterExpressionsOnSave(boolean theValidateSearchParameterExpressionsOnSave) {
        this.myValidateSearchParameterExpressionsOnSave = theValidateSearchParameterExpressionsOnSave;
    }

    public List<Integer> getSearchPreFetchThresholds() {
        return this.mySearchPreFetchThresholds;
    }

    public void setSearchPreFetchThresholds(List<Integer> thePreFetchThresholds) {
        Validate.isTrue((thePreFetchThresholds.size() > 0 ? 1 : 0) != 0, (String)"thePreFetchThresholds must not be empty", (Object[])new Object[0]);
        int last = 0;
        for (Integer nextInt : thePreFetchThresholds) {
            Validate.isTrue((nextInt > 0 || nextInt == -1 ? 1 : 0) != 0, (String)(nextInt + " is not a valid prefetch threshold"), (Object[])new Object[0]);
            Validate.isTrue((nextInt != last ? 1 : 0) != 0, (String)"Prefetch thresholds must be sequential", (Object[])new Object[0]);
            Validate.isTrue((nextInt > last || nextInt == -1 ? 1 : 0) != 0, (String)"Prefetch thresholds must be sequential", (Object[])new Object[0]);
            Validate.isTrue((last != -1 ? 1 : 0) != 0, (String)"Prefetch thresholds must be sequential", (Object[])new Object[0]);
            last = nextInt;
        }
        this.mySearchPreFetchThresholds = thePreFetchThresholds;
    }

    public boolean isFilterParameterEnabled() {
        return this.myFilterParameterEnabled;
    }

    public void setFilterParameterEnabled(boolean theFilterParameterEnabled) {
        this.myFilterParameterEnabled = theFilterParameterEnabled;
    }

    public StoreMetaSourceInformationEnum getStoreMetaSourceInformation() {
        return this.myStoreMetaSourceInformation;
    }

    public void setStoreMetaSourceInformation(StoreMetaSourceInformationEnum theStoreMetaSourceInformation) {
        Validate.notNull((Object)((Object)theStoreMetaSourceInformation), (String)"theStoreMetaSourceInformation must not be null", (Object[])new Object[0]);
        this.myStoreMetaSourceInformation = theStoreMetaSourceInformation;
    }

    public boolean isAccessMetaSourceInformationFromProvenanceTable() {
        return this.myAccessMetaSourceInformationFromProvenanceTable;
    }

    public void setAccessMetaSourceInformationFromProvenanceTable(boolean theAccessMetaSourceInformationFromProvenanceTable) {
        this.myAccessMetaSourceInformationFromProvenanceTable = theAccessMetaSourceInformationFromProvenanceTable;
    }

    public boolean isPreExpandValueSets() {
        return this.myPreExpandValueSets;
    }

    public void setPreExpandValueSets(boolean thePreExpandValueSets) {
        this.myPreExpandValueSets = thePreExpandValueSets;
    }

    public int getPreExpandValueSetsDefaultOffset() {
        return 0;
    }

    public int getPreExpandValueSetsDefaultCount() {
        return this.myPreExpandValueSetsDefaultCount;
    }

    public void setPreExpandValueSetsDefaultCount(int thePreExpandValueSetsDefaultCount) {
        this.myPreExpandValueSetsDefaultCount = Math.min(thePreExpandValueSetsDefaultCount, this.getPreExpandValueSetsMaxCount());
    }

    public int getPreExpandValueSetsMaxCount() {
        return this.myPreExpandValueSetsMaxCount;
    }

    public void setPreExpandValueSetsMaxCount(int thePreExpandValueSetsMaxCount) {
        this.myPreExpandValueSetsMaxCount = thePreExpandValueSetsMaxCount;
        this.setPreExpandValueSetsDefaultCount(Math.min(this.getPreExpandValueSetsDefaultCount(), this.getPreExpandValueSetsMaxCount()));
    }

    public boolean isDeleteEnabled() {
        return this.myDeleteEnabled;
    }

    public void setDeleteEnabled(boolean theDeleteEnabled) {
        this.myDeleteEnabled = theDeleteEnabled;
    }

    public Integer getMaximumDeleteConflictQueryCount() {
        return this.myMaximumDeleteConflictQueryCount;
    }

    public void setMaximumDeleteConflictQueryCount(Integer theMaximumDeleteConflictQueryCount) {
        this.myMaximumDeleteConflictQueryCount = theMaximumDeleteConflictQueryCount;
    }

    @Deprecated
    public void setPreloadBlobFromInputStream(Boolean thePreloadBlobFromInputStream) {
    }

    public Integer getInternalSynchronousSearchSize() {
        return this.myInternalSynchronousSearchSize;
    }

    public void setInternalSynchronousSearchSize(Integer theInternalSynchronousSearchSize) {
        this.myInternalSynchronousSearchSize = theInternalSynchronousSearchSize;
    }

    public boolean isEnableTaskBulkImportJobExecution() {
        return this.myEnableTaskBulkImportJobExecution;
    }

    public void setEnableTaskBulkImportJobExecution(boolean theEnableTaskBulkImportJobExecution) {
        this.myEnableTaskBulkImportJobExecution = theEnableTaskBulkImportJobExecution;
    }

    public boolean isEnableTaskBulkExportJobExecution() {
        return this.myEnableTaskBulkExportJobExecution;
    }

    public void setEnableTaskBulkExportJobExecution(boolean theEnableTaskBulkExportJobExecution) {
        this.myEnableTaskBulkExportJobExecution = theEnableTaskBulkExportJobExecution;
    }

    public boolean isEnableTaskPreExpandValueSets() {
        return this.myEnableTaskPreExpandValueSets;
    }

    public void setEnableTaskPreExpandValueSets(boolean theEnableTaskPreExpandValueSets) {
        this.myEnableTaskPreExpandValueSets = theEnableTaskPreExpandValueSets;
    }

    public boolean isEnableTaskStaleSearchCleanup() {
        return this.myEnableTaskStaleSearchCleanup;
    }

    public void setEnableTaskStaleSearchCleanup(boolean theEnableTaskStaleSearchCleanup) {
        this.myEnableTaskStaleSearchCleanup = theEnableTaskStaleSearchCleanup;
    }

    public boolean isEnableTaskResourceReindexing() {
        return this.myEnableTaskResourceReindexing;
    }

    public void setEnableTaskResourceReindexing(boolean theEnableTaskResourceReindexing) {
        this.myEnableTaskResourceReindexing = theEnableTaskResourceReindexing;
    }

    public boolean isAccountForDateIndexNulls() {
        return this.myAccountForDateIndexNulls;
    }

    public void setAccountForDateIndexNulls(boolean theAccountForDateIndexNulls) {
        this.myAccountForDateIndexNulls = theAccountForDateIndexNulls;
    }

    public boolean canDeleteExpunge() {
        return this.isAllowMultipleDelete() && this.isExpungeEnabled() && this.isDeleteExpungeEnabled();
    }

    public String cannotDeleteExpungeReason() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (!this.isAllowMultipleDelete()) {
            reasons.add("Multiple Delete");
        }
        if (!this.isExpungeEnabled()) {
            reasons.add("Expunge");
        }
        if (!this.isDeleteExpungeEnabled()) {
            reasons.add("Delete Expunge");
        }
        Object retval = "Delete Expunge is not supported on this server.  ";
        retval = reasons.size() == 1 ? (String)retval + (String)reasons.get(0) + " is disabled." : (String)retval + "The following configurations are disabled: " + StringUtils.join(reasons, (String)", ");
        return retval;
    }

    public String getHSearchIndexPrefix() {
        return this.myHSearchIndexPrefix;
    }

    public void setHSearchIndexPrefix(String thePrefix) {
        this.myHSearchIndexPrefix = thePrefix;
    }

    @Deprecated(since="8.0.0", forRemoval=true)
    public boolean isAdvancedHSearchIndexing() {
        return this.isHibernateSearchIndexSearchParams();
    }

    @Deprecated(since="8.0.0", forRemoval=true)
    public void setAdvancedHSearchIndexing(boolean theAdvancedHSearchIndexing) {
        this.setHibernateSearchIndexSearchParams(theAdvancedHSearchIndexing);
    }

    public boolean isHibernateSearchIndexSearchParams() {
        return this.myHibernateSearchIndexSearchParams;
    }

    public void setHibernateSearchIndexSearchParams(boolean theAdvancedHSearchIndexing) {
        this.myHibernateSearchIndexSearchParams = theAdvancedHSearchIndexing;
    }

    public boolean isStoreResourceInHSearchIndex() {
        return this.myStoreResourceInHSearchIndex;
    }

    public void setStoreResourceInHSearchIndex(boolean theStoreResourceInHSearchIndex) {
        this.myStoreResourceInHSearchIndex = theStoreResourceInHSearchIndex;
    }

    public boolean isConcurrentBundleValidation() {
        return this.myConcurrentBundleValidation;
    }

    public JpaStorageSettings setConcurrentBundleValidation(boolean theConcurrentBundleValidation) {
        this.myConcurrentBundleValidation = theConcurrentBundleValidation;
        return this;
    }

    public boolean isAllowAutoInflateBinaries() {
        return this.myAllowAutoInflateBinaries;
    }

    public void setAllowAutoInflateBinaries(boolean theAllowAutoDeExternalizingBinaries) {
        this.myAllowAutoInflateBinaries = theAllowAutoDeExternalizingBinaries;
    }

    public long getAutoInflateBinariesMaximumBytes() {
        return this.myAutoInflateBinariesMaximumBytes;
    }

    public void setAutoInflateBinariesMaximumBytes(long theAutoInflateBinariesMaximumBytes) {
        this.myAutoInflateBinariesMaximumBytes = theAutoInflateBinariesMaximumBytes;
    }

    public int getBulkExportFileRetentionPeriodHours() {
        return this.myBulkExportFileRetentionPeriodHours;
    }

    public void setBulkExportFileRetentionPeriodHours(int theBulkExportFileRetentionPeriodHours) {
        this.myBulkExportFileRetentionPeriodHours = theBulkExportFileRetentionPeriodHours;
    }

    public boolean getEnableBulkExportJobReuse() {
        return this.myEnableBulkExportJobReuse;
    }

    public void setEnableBulkExportJobReuse(boolean theEnableBulkExportJobReuse) {
        this.myEnableBulkExportJobReuse = theEnableBulkExportJobReuse;
    }

    public boolean isUpdateWithHistoryRewriteEnabled() {
        return this.myUpdateWithHistoryRewriteEnabled;
    }

    public void setUpdateWithHistoryRewriteEnabled(boolean theUpdateWithHistoryRewriteEnabled) {
        this.myUpdateWithHistoryRewriteEnabled = theUpdateWithHistoryRewriteEnabled;
    }

    public boolean isPreserveRequestIdInResourceBody() {
        return this.myPreserveRequestIdInResourceBody;
    }

    public void setPreserveRequestIdInResourceBody(boolean thePreserveRequestIdInResourceBody) {
        this.myPreserveRequestIdInResourceBody = thePreserveRequestIdInResourceBody;
    }

    public int getBulkExportFileMaximumCapacity() {
        return this.myBulkExportFileMaximumCapacity;
    }

    public void setBulkExportFileMaximumCapacity(int theBulkExportFileMaximumCapacity) {
        this.myBulkExportFileMaximumCapacity = theBulkExportFileMaximumCapacity;
    }

    public long getBulkExportFileMaximumSize() {
        return this.myBulkExportFileMaximumSize;
    }

    public void setBulkExportFileMaximumSize(long theBulkExportFileMaximumSize) {
        Validate.isTrue((theBulkExportFileMaximumSize > 0L ? 1 : 0) != 0, (String)"theBulkExportFileMaximumSize must be positive", (Object[])new Object[0]);
        this.myBulkExportFileMaximumSize = theBulkExportFileMaximumSize;
    }

    public boolean isJobFastTrackingEnabled() {
        return this.myJobFastTrackingEnabled;
    }

    public void setJobFastTrackingEnabled(boolean theJobFastTrackingEnabled) {
        this.myJobFastTrackingEnabled = theJobFastTrackingEnabled;
    }

    public boolean isResourceDbHistoryEnabled() {
        return this.myResourceHistoryDbEnabled;
    }

    public void setResourceDbHistoryEnabled(boolean theResourceHistoryEnabled) {
        this.myResourceHistoryDbEnabled = theResourceHistoryEnabled;
    }

    public boolean isNonResourceDbHistoryEnabled() {
        return this.myNonResourceDbHistoryEnabled;
    }

    @Nonnull
    public IValidationSupport.IssueSeverity getIssueSeverityForCodeDisplayMismatch() {
        return this.myIssueSeverityForCodeDisplayMismatch;
    }

    public void setIssueSeverityForCodeDisplayMismatch(@Nonnull IValidationSupport.IssueSeverity theIssueSeverityForCodeDisplayMismatch) {
        Validate.notNull((Object)theIssueSeverityForCodeDisplayMismatch, (String)"theIssueSeverityForCodeDisplayMismatch must not be null", (Object[])new Object[0]);
        this.myIssueSeverityForCodeDisplayMismatch = theIssueSeverityForCodeDisplayMismatch;
    }

    public boolean isWriteToLegacyLobColumns() {
        return this.myWriteToLegacyLobColumns;
    }

    public void setWriteToLegacyLobColumns(boolean theWriteToLegacyLobColumns) {
        this.myWriteToLegacyLobColumns = theWriteToLegacyLobColumns;
    }

    public void setNonResourceDbHistoryEnabled(boolean theNonResourceDbHistoryEnabled) {
        this.myNonResourceDbHistoryEnabled = theNonResourceDbHistoryEnabled;
    }

    public void setPreventInvalidatingConditionalMatchCriteria(boolean theCriteria) {
        this.myPreventInvalidatingConditionalMatchCriteria = theCriteria;
    }

    public boolean isPreventInvalidatingConditionalMatchCriteria() {
        return this.myPreventInvalidatingConditionalMatchCriteria;
    }

    public long getRestDeleteByUrlResourceIdThreshold() {
        return this.myRestDeleteByUrlResourceIdThreshold;
    }

    public void setRestDeleteByUrlResourceIdThreshold(long theRestDeleteByUrlResourceIdThreshold) {
        this.myRestDeleteByUrlResourceIdThreshold = theRestDeleteByUrlResourceIdThreshold;
    }

    public int getMaxTransactionEntriesForWrite() {
        return this.myMaxTransactionEntriesForWrite;
    }

    public void setMaxTransactionEntriesForWrite(int theMaxTransactionEntriesForWrite) {
        this.myMaxTransactionEntriesForWrite = theMaxTransactionEntriesForWrite;
    }

    public int getDefaultTransactionEntriesForWrite() {
        return this.myDefaultTransactionEntriesForWrite;
    }

    public void setDefaultTransactionEntriesForWrite(int theDefaultTransactionEntriesForWrite) {
        this.myDefaultTransactionEntriesForWrite = theDefaultTransactionEntriesForWrite;
    }

    public boolean isWriteToSearchParamIdentityTable() {
        return this.myWriteToSearchParamIdentityTable;
    }

    public void setWriteToSearchParamIdentityTable(boolean theWriteToSearchParamIdentityTable) {
        this.myWriteToSearchParamIdentityTable = theWriteToSearchParamIdentityTable;
    }

    public static enum IdStrategyEnum {
        SEQUENTIAL_NUMERIC,
        UUID;

    }

    public static enum ClientIdStrategyEnum {
        NOT_ALLOWED,
        ALPHANUMERIC,
        ANY;

    }

    public static enum StoreMetaSourceInformationEnum {
        NONE(false, false),
        SOURCE_URI(true, false),
        REQUEST_ID(false, true),
        SOURCE_URI_AND_REQUEST_ID(true, true);

        private final boolean myStoreSourceUri;
        private final boolean myStoreRequestId;

        private StoreMetaSourceInformationEnum(boolean theStoreSourceUri, boolean theStoreRequestId) {
            this.myStoreSourceUri = theStoreSourceUri;
            this.myStoreRequestId = theStoreRequestId;
        }

        public boolean isStoreSourceUri() {
            return this.myStoreSourceUri;
        }

        public boolean isStoreRequestId() {
            return this.myStoreRequestId;
        }
    }
}

