/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DaoRegistry
implements ApplicationContextAware,
IDaoRegistry {
    private ApplicationContext myAppCtx;
    @Autowired
    private FhirContext myFhirContext;
    private volatile Map<String, IFhirResourceDao<?>> myResourceNameToResourceDao;
    private volatile IFhirSystemDao<?, ?> mySystemDao;
    private Set<String> mySupportedResourceTypes;

    public DaoRegistry() {
        this(null);
    }

    public DaoRegistry(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public void setSupportedResourceTypes(Collection<String> theSupportedResourceTypes) {
        HashSet<String> supportedResourceTypes = new HashSet<String>();
        if (theSupportedResourceTypes != null) {
            supportedResourceTypes.addAll(theSupportedResourceTypes);
        }
        this.mySupportedResourceTypes = supportedResourceTypes;
        this.myResourceNameToResourceDao = null;
    }

    public void setApplicationContext(ApplicationContext theApplicationContext) throws BeansException {
        this.myAppCtx = theApplicationContext;
    }

    public IFhirSystemDao getSystemDao() {
        IFhirSystemDao retVal = this.mySystemDao;
        if (retVal == null) {
            this.mySystemDao = retVal = (IFhirSystemDao)this.myAppCtx.getBean(IFhirSystemDao.class);
        }
        return retVal;
    }

    public IFhirResourceDao getResourceDao(String theResourceName) {
        IFhirResourceDao retVal = this.getResourceDaoOrNull(theResourceName);
        if (retVal == null) {
            List supportedResourceTypes = this.myResourceNameToResourceDao.keySet().stream().sorted().collect(Collectors.toList());
            throw new InvalidRequestException(Msg.code((int)572) + "Unable to process request, this server does not know how to handle resources of type " + theResourceName + " - Can handle: " + String.valueOf(supportedResourceTypes));
        }
        return retVal;
    }

    public <R extends IBaseResource> IFhirResourceDao<R> getResourceDao(R theResource) {
        return this.getResourceDao(theResource.getClass());
    }

    public <R extends IBaseResource> IFhirResourceDao<R> getResourceDao(Class<R> theResourceType) {
        IFhirResourceDao<R> retVal = this.getResourceDaoIfExists(theResourceType);
        Validate.notNull(retVal, (String)"No DAO exists for resource type %s - Have: %s", (Object[])new Object[]{theResourceType, this.myResourceNameToResourceDao});
        return retVal;
    }

    @Deprecated
    public <T extends IBaseResource> IFhirResourceDao<T> getResourceDaoIfExists(Class<T> theResourceType) {
        return this.getResourceDaoOrNull(theResourceType);
    }

    @Nullable
    public <T extends IBaseResource> IFhirResourceDao<T> getResourceDaoOrNull(Class<T> theResourceType) {
        String resourceName = this.myFhirContext.getResourceType(theResourceType);
        try {
            return this.getResourceDao(resourceName);
        }
        catch (InvalidRequestException e) {
            return null;
        }
    }

    @Deprecated
    public <T extends IBaseResource> IFhirResourceDao<T> getResourceDaoIfExists(String theResourceType) {
        return this.getResourceDaoOrNull(theResourceType);
    }

    @Nullable
    public <T extends IBaseResource> IFhirResourceDao<T> getResourceDaoOrNull(String theResourceName) {
        this.init();
        return this.myResourceNameToResourceDao.get(theResourceName);
    }

    @Override
    public boolean isResourceTypeSupported(String theResourceType) {
        if (this.mySupportedResourceTypes == null) {
            return this.getResourceDaoOrNull(theResourceType) != null;
        }
        return this.mySupportedResourceTypes.contains(theResourceType);
    }

    private void init() {
        if (this.myResourceNameToResourceDao != null && !this.myResourceNameToResourceDao.isEmpty()) {
            return;
        }
        Map resourceDaos = this.myAppCtx.getBeansOfType(IFhirResourceDao.class);
        this.initializeMaps(resourceDaos.values());
    }

    private void initializeMaps(Collection<IFhirResourceDao> theResourceDaos) {
        this.myResourceNameToResourceDao = new HashMap();
        for (IFhirResourceDao nextResourceDao : theResourceDaos) {
            Class resourceType = nextResourceDao.getResourceType();
            assert (resourceType != null);
            RuntimeResourceDefinition nextResourceDef = this.myFhirContext.getResourceDefinition(resourceType);
            if (this.mySupportedResourceTypes != null && !this.mySupportedResourceTypes.contains(nextResourceDef.getName())) continue;
            this.myResourceNameToResourceDao.put(nextResourceDef.getName(), nextResourceDao);
        }
    }

    public void register(IFhirResourceDao theResourceDao) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResourceDao.getResourceType());
        String resourceName = resourceDef.getName();
        this.myResourceNameToResourceDao.put(resourceName, theResourceDao);
    }

    @Deprecated
    public IFhirResourceDao getDaoOrThrowException(Class<? extends IBaseResource> theClass) {
        return this.getDaoOrThrow(theClass);
    }

    public <T extends IBaseResource> IFhirResourceDao<T> getDaoOrThrow(Class<T> theClass) {
        IFhirResourceDao<T> retVal = this.getResourceDao(theClass);
        if (retVal == null) {
            List<String> supportedResourceNames = this.myResourceNameToResourceDao.keySet().stream().map(t -> this.myFhirContext.getResourceType(t)).sorted().toList();
            throw new InvalidRequestException(Msg.code((int)573) + "Unable to process request, this server does not know how to handle resources of type " + this.myFhirContext.getResourceType(theClass) + " - Can handle: " + String.valueOf(supportedResourceNames));
        }
        return retVal;
    }

    public void setResourceDaos(Collection<IFhirResourceDao> theResourceDaos) {
        this.initializeMaps(theResourceDaos);
    }

    public IFhirResourceDao getSubscriptionDao() {
        return this.getResourceDao(ResourceTypeEnum.SUBSCRIPTION.getCode());
    }

    public void setSupportedResourceTypes(String ... theResourceTypes) {
        this.setSupportedResourceTypes(this.toCollection(theResourceTypes));
    }

    private List<String> toCollection(String[] theResourceTypes) {
        List<String> retVal = null;
        if (theResourceTypes != null && theResourceTypes.length > 0) {
            retVal = Arrays.asList(theResourceTypes);
        }
        return retVal;
    }

    public Set<String> getRegisteredDaoTypes() {
        return Collections.unmodifiableSet(this.myResourceNameToResourceDao.keySet());
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }
}

