/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;
import org.springframework.transaction.annotation.Transactional;

public interface IFhirResourceDaoCodeSystem<T extends IBaseResource>
extends IFhirResourceDao<T> {
    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String var1, String var2, RequestDetails var3);

    @Transactional
    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> var1, IPrimitiveType<String> var2, IBaseCoding var3, RequestDetails var4);

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> var1, IPrimitiveType<String> var2, IBaseCoding var3, IPrimitiveType<String> var4, RequestDetails var5);

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> var1, IPrimitiveType<String> var2, IBaseCoding var3, IPrimitiveType<String> var4, Collection<IPrimitiveType<String>> var5, RequestDetails var6);

    public SubsumesResult subsumes(IPrimitiveType<String> var1, IPrimitiveType<String> var2, IPrimitiveType<String> var3, IBaseCoding var4, IBaseCoding var5, RequestDetails var6);

    @Nonnull
    public IValidationSupport.CodeValidationResult validateCode(IIdType var1, IPrimitiveType<String> var2, IPrimitiveType<String> var3, IPrimitiveType<String> var4, IPrimitiveType<String> var5, IBaseCoding var6, IBaseDatatype var7, RequestDetails var8);

    public static class SubsumesResult {
        private final ConceptSubsumptionOutcome myOutcome;

        public SubsumesResult(ConceptSubsumptionOutcome theOutcome) {
            this.myOutcome = theOutcome;
        }

        public ConceptSubsumptionOutcome getOutcome() {
            return this.myOutcome;
        }

        public IBaseParameters toParameters(FhirContext theFhirContext) {
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)theFhirContext);
            IPrimitiveType outcomeValue = (IPrimitiveType)theFhirContext.getElementDefinition("code").newInstance();
            outcomeValue.setValueAsString(this.getOutcome().toCode());
            ParametersUtil.addParameterToParameters((FhirContext)theFhirContext, (IBaseParameters)retVal, (String)"outcome", (Object)outcomeValue);
            return retVal;
        }
    }
}

