/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.model;

import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.util.Assert;

public class DeleteConflictList
implements Iterable<DeleteConflict> {
    private final List<DeleteConflict> myList = new ArrayList<DeleteConflict>();
    private final Set<String> myResourceIdsMarkedForDeletion;
    private final Set<String> myResourceIdsToIgnoreConflict;
    private int myRemoveModCount;

    public DeleteConflictList() {
        this.myResourceIdsMarkedForDeletion = new HashSet<String>();
        this.myResourceIdsToIgnoreConflict = new HashSet<String>();
    }

    public DeleteConflictList(DeleteConflictList theParentList) {
        this.myResourceIdsMarkedForDeletion = theParentList.myResourceIdsMarkedForDeletion;
        this.myResourceIdsToIgnoreConflict = theParentList.myResourceIdsToIgnoreConflict;
    }

    public boolean isResourceIdMarkedForDeletion(IIdType theIdType) {
        Validate.notNull((Object)theIdType);
        Validate.notBlank((CharSequence)theIdType.toUnqualifiedVersionless().getValue());
        return this.myResourceIdsMarkedForDeletion.contains(theIdType.toUnqualifiedVersionless().getValue());
    }

    public void setResourceIdMarkedForDeletion(IIdType theIdType) {
        Validate.notNull((Object)theIdType);
        Validate.notBlank((CharSequence)theIdType.toUnqualifiedVersionless().getValue());
        this.myResourceIdsMarkedForDeletion.add(theIdType.toUnqualifiedVersionless().getValue());
    }

    public boolean isResourceIdToIgnoreConflict(IIdType theIdType) {
        Validate.notNull((Object)theIdType);
        Validate.notBlank((CharSequence)theIdType.toUnqualifiedVersionless().getValue());
        return this.myResourceIdsToIgnoreConflict.contains(theIdType.toUnqualifiedVersionless().getValue());
    }

    public void setResourceIdToIgnoreConflict(IIdType theIdType) {
        Validate.notNull((Object)theIdType);
        Validate.notBlank((CharSequence)theIdType.toUnqualifiedVersionless().getValue());
        this.myResourceIdsToIgnoreConflict.add(theIdType.toUnqualifiedVersionless().getValue());
    }

    public void add(DeleteConflict theDeleteConflict) {
        this.myList.add(theDeleteConflict);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @Override
    public Iterator<DeleteConflict> iterator() {
        return new Iterator<DeleteConflict>(){
            private final int myOriginalRemoveModCont;
            private int myNextIndex;
            private boolean myLastOperationWasNext;
            {
                this.myOriginalRemoveModCont = DeleteConflictList.this.myRemoveModCount;
                this.myNextIndex = 0;
            }

            @Override
            public boolean hasNext() {
                this.checkForCoModification();
                this.myLastOperationWasNext = false;
                return this.myNextIndex < DeleteConflictList.this.myList.size();
            }

            @Override
            public DeleteConflict next() {
                this.checkForCoModification();
                this.myLastOperationWasNext = true;
                return DeleteConflictList.this.myList.get(this.myNextIndex++);
            }

            @Override
            public void remove() {
                Assert.isTrue((boolean)this.myLastOperationWasNext, (String)"myLastOperationWasNext is not true");
                --this.myNextIndex;
                DeleteConflictList.this.myList.remove(this.myNextIndex);
                this.myLastOperationWasNext = false;
            }

            private void checkForCoModification() {
                Validate.isTrue((this.myOriginalRemoveModCont == DeleteConflictList.this.myRemoveModCount ? 1 : 0) != 0);
            }
        };
    }

    public boolean removeIf(Predicate<DeleteConflict> theFilter) {
        boolean retVal = this.myList.removeIf(theFilter);
        if (retVal) {
            ++this.myRemoveModCount;
        }
        return retVal;
    }

    public void addAll(DeleteConflictList theNewConflicts) {
        this.myList.addAll(theNewConflicts.myList);
    }

    public int size() {
        return this.myList.size();
    }

    public void removeAll() {
        this.removeIf(x -> true);
    }

    public String toString() {
        return this.myList.toString();
    }
}

