/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.pid;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.TypedResourcePid;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class BaseResourcePidList<T extends IResourcePersistentId<?>>
implements IResourcePidList<T> {
    final List<T> myIds = new ArrayList<T>();
    @Nullable
    final Date myLastDate;
    private final RequestPartitionId myRequestPartitionId;

    BaseResourcePidList(Collection<T> theIds, @Nullable Date theLastDate, RequestPartitionId theRequestPartitionId) {
        this.myIds.addAll(theIds);
        this.myLastDate = theLastDate;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    @Override
    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    @Override
    @Nullable
    public Date getLastDate() {
        return this.myLastDate;
    }

    @Override
    public int size() {
        return this.myIds.size();
    }

    @Override
    @Nonnull
    public List<TypedResourcePid> getTypedResourcePids() {
        ArrayList<TypedResourcePid> retval = new ArrayList<TypedResourcePid>();
        for (int i = 0; i < this.myIds.size(); ++i) {
            retval.add(new TypedResourcePid(this.getResourceType(i), (IResourcePersistentId)this.myIds.get(i)));
        }
        return Collections.unmodifiableList(retval);
    }

    @Override
    public boolean isEmpty() {
        return this.myIds.isEmpty();
    }

    @Override
    public List<T> getIds() {
        return Collections.unmodifiableList(this.myIds);
    }

    public T getId(int theIndex) {
        return (T)((IResourcePersistentId)this.myIds.get(theIndex));
    }

    public String toString() {
        return this.myIds.toString();
    }
}

