/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.jpa.api.pid.ListWrappingPidStream;
import ca.uhn.fhir.model.primitive.IdDt;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IBatch2DaoSvc {
    public boolean isAllResourceTypeSupported();

    default public IResourcePidList fetchResourceIdsPage(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, @Nullable String theUrl) {
        throw new UnsupportedOperationException(Msg.code((int)2425) + "Not implemented unless explicitly overridden");
    }

    @Deprecated
    default public IResourcePidList fetchResourceIdsPage(Date theStart, Date theEnd, @Nonnull Integer thePageSize, @Nullable RequestPartitionId theRequestPartitionId, @Nullable String theUrl) {
        return this.fetchResourceIdsPage(theStart, theEnd, theRequestPartitionId, theUrl);
    }

    default public IResourcePidStream fetchResourceIdStream(Date theStart, Date theEnd, RequestPartitionId theTargetPartitionId, String theUrl) {
        return new ListWrappingPidStream(this.fetchResourceIdsPage(theStart, theEnd, 20000, theTargetPartitionId, theUrl));
    }

    default public Stream<IdDt> streamSourceIdsThatReferenceTargetId(IIdType theTargetId) {
        throw new UnsupportedOperationException(Msg.code((int)2594) + "Not implemented unless explicitly overridden");
    }
}

