/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.ResolveIdentityMode;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IIdHelperService<T extends IResourcePersistentId<?>> {
    @Nonnull
    public IIdType translatePidIdToForcedId(FhirContext var1, String var2, T var3);

    @Nonnull
    public IResourceLookup<T> resolveResourceIdentity(@Nonnull RequestPartitionId var1, @Nullable String var2, @Nonnull String var3, @Nonnull ResolveIdentityMode var4) throws ResourceNotFoundException;

    @Nonnull
    default public T resolveResourceIdentityPid(@Nonnull RequestPartitionId theRequestPartitionId, @Nullable String theResourceType, @Nonnull String theResourceId, @Nonnull ResolveIdentityMode theMode) throws ResourceNotFoundException {
        return (T)this.resolveResourceIdentity(theRequestPartitionId, theResourceType, theResourceId, theMode).getPersistentId();
    }

    @Nonnull
    public Map<IIdType, IResourceLookup<T>> resolveResourceIdentities(@Nonnull RequestPartitionId var1, Collection<IIdType> var2, ResolveIdentityMode var3);

    default public List<T> resolveResourcePids(RequestPartitionId theRequestPartitionId, List<IIdType> theTargetIds, ResolveIdentityMode theResolveIdentityMode) {
        return this.resolveResourceIdentities(theRequestPartitionId, theTargetIds, theResolveIdentityMode).values().stream().map(IResourceLookup::getPersistentId).collect(Collectors.toList());
    }

    public boolean idRequiresForcedId(String var1);

    public Optional<String> translatePidIdToForcedIdWithCache(T var1);

    public PersistentIdToForcedIdMap<T> translatePidsToForcedIds(Set<T> var1);

    public void addResolvedPidToFhirIdAfterCommit(@Nonnull T var1, @Nonnull RequestPartitionId var2, @Nonnull String var3, @Nonnull String var4, @Nullable Date var5);

    @Nullable
    public T getPidOrNull(RequestPartitionId var1, IBaseResource var2);

    @Nonnull
    default public T getPidOrThrowException(RequestPartitionId theRequestPartitionId, IIdType theId) {
        IResourceLookup<T> identity = this.resolveResourceIdentity(theRequestPartitionId, theId.getResourceType(), theId.getIdPart(), ResolveIdentityMode.includeDeleted().cacheOk());
        if (identity == null) {
            throw new InvalidRequestException(Msg.code((int)2295) + "Invalid ID was provided: [" + theId.getIdPart() + "]");
        }
        return (T)identity.getPersistentId();
    }

    @Nonnull
    public T getPidOrThrowException(@Nonnull IAnyResource var1);

    public IIdType resourceIdFromPidOrThrowException(T var1, String var2);

    public Set<String> translatePidsToFhirResourceIds(Set<T> var1);

    @Deprecated
    public T newPid(Object var1);

    public T newPid(Object var1, Integer var2);

    public T newPidFromStringIdAndResourceName(Integer var1, String var2, String var3);
}

