/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.svc;

public class ResolveIdentityMode {
    private final boolean myIncludeDeleted;
    private final boolean myUseCache;
    private final boolean myFailOnDeleted;

    private ResolveIdentityMode(boolean theIncludeDeleted, boolean theFailOnDeleted, boolean theUseCache) {
        this.myIncludeDeleted = theIncludeDeleted;
        this.myUseCache = theUseCache;
        this.myFailOnDeleted = theFailOnDeleted;
    }

    public boolean isUseCache(boolean theDeleteEnabled) {
        if (this.myUseCache) {
            return true;
        }
        return !theDeleteEnabled;
    }

    public boolean isIncludeDeleted() {
        return this.myIncludeDeleted;
    }

    public boolean isFailOnDeleted() {
        return this.myFailOnDeleted;
    }

    public static Builder includeDeleted() {
        return new Builder(true, false);
    }

    public static Builder excludeDeleted() {
        return new Builder(false, false);
    }

    public static Builder failOnDeleted() {
        return new Builder(false, true);
    }

    public static class Builder {
        private final boolean myIncludeDeleted;
        private final boolean myFailOnDeleted;

        private Builder(boolean theIncludeDeleted, boolean theFailOnDeleted) {
            this.myIncludeDeleted = theIncludeDeleted;
            this.myFailOnDeleted = theFailOnDeleted;
        }

        public ResolveIdentityMode cacheOk() {
            return new ResolveIdentityMode(this.myIncludeDeleted, this.myFailOnDeleted, true);
        }

        public ResolveIdentityMode noCacheUnlessDeletesDisabled() {
            return new ResolveIdentityMode(this.myIncludeDeleted, this.myFailOnDeleted, false);
        }
    }
}

