/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binary.interceptor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.binary.api.IBinaryTarget;
import ca.uhn.fhir.jpa.binary.api.StoredDetails;
import ca.uhn.fhir.jpa.binary.provider.BinaryAccessProvider;
import ca.uhn.fhir.jpa.binary.svc.BaseBinaryStorageSvcImpl;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.IModelVisitor2;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class BinaryStorageInterceptor<T extends IPrimitiveType<byte[]>> {
    private static final Logger ourLog = LoggerFactory.getLogger(BinaryStorageInterceptor.class);
    public static final String AUTO_INFLATE_BINARY_CONTENT_KEY = BinaryStorageInterceptor.class.getName() + "_AUTO_INFLATE_BINARY_CONTENT";
    private static final Predicate<IBaseExtension<?, ?>> EXTENSION_FILTER_PREDICATE = ext -> ext.getUserData(JpaConstants.EXTENSION_EXT_SYSTEMDEFINED) == null;
    @Autowired
    private IBinaryStorageSvc myBinaryStorageSvc;
    private final FhirContext myCtx;
    @Autowired
    private BinaryAccessProvider myBinaryAccessProvider;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private Class<T> myBinaryType;
    private String myDeferredListKey;
    private long myAutoInflateBinariesMaximumBytes = 0xA00000L;
    private boolean myAllowAutoInflateBinaries = true;

    public BinaryStorageInterceptor(FhirContext theCtx) {
        this.myCtx = theCtx;
        BaseRuntimeElementDefinition base64Binary = this.myCtx.getElementDefinition("base64Binary");
        assert (base64Binary != null);
        this.myBinaryType = base64Binary.getImplementingClass();
        this.myDeferredListKey = this.getClass().getName() + "_" + this.hashCode() + "_DEFERRED_LIST";
    }

    public long getAutoInflateBinariesMaximumSize() {
        return this.myAutoInflateBinariesMaximumBytes;
    }

    public void setAutoInflateBinariesMaximumSize(long theAutoInflateBinariesMaximumBytes) {
        this.myAutoInflateBinariesMaximumBytes = theAutoInflateBinariesMaximumBytes;
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE)
    public void expungeResource(AtomicInteger theCounter, IBaseResource theResource) {
        List binaryElements = this.myCtx.newTerser().getAllPopulatedChildElementsOfType(theResource, this.myBinaryType);
        List attachmentIds = binaryElements.stream().flatMap(t -> ((IBaseHasExtensions)t).getExtension().stream()).filter(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl())).map(t -> ((IPrimitiveType)t.getValue()).getValueAsString()).collect(Collectors.toList());
        for (String next : attachmentIds) {
            this.myBinaryStorageSvc.expungeBinaryContent(theResource.getIdElement(), next);
            theCounter.incrementAndGet();
            ourLog.info("Deleting binary blob {} because resource {} is being expunged", (Object)next, (Object)theResource.getIdElement().getValue());
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void extractLargeBinariesBeforeCreate(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        this.extractLargeBinaries(theRequestDetails, theTransactionDetails, theResource, null, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void extractLargeBinariesBeforeUpdate(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, IBaseResource thePreviousResource, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        this.blockIllegalExternalExtensions(thePreviousResource, theResource);
        this.extractLargeBinaries(theRequestDetails, theTransactionDetails, theResource, thePreviousResource, thePointcut);
    }

    private void blockIllegalExternalExtensions(IBaseResource thePreviousResource, IBaseResource theResource) {
        Map<String, String> existingAttachmentIdToHashMap = this.buildHashAttachmentIdMap(thePreviousResource, true);
        Set<String> existingBinaryIds = existingAttachmentIdToHashMap.keySet();
        Collection<String> existingHashes = existingAttachmentIdToHashMap.values();
        this.recursivelyScanResourceForBinaryData(theResource).forEach(target -> {
            String expected;
            String id = target.getAttachmentIdFiltered(EXTENSION_FILTER_PREDICATE).orElse(null);
            String hash = target.getHashExtensionFiltered(EXTENSION_FILTER_PREDICATE).orElse(null);
            if (id != null && !existingBinaryIds.contains(id)) {
                this.throwIllegalExtension("http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id", id);
            }
            if (hash != null && !existingHashes.contains(hash)) {
                this.throwIllegalExtension("http://hapifhir.io/fhir/StructureDefinition/externalized-binary-hash-sha256", hash);
            }
            if (id != null && hash != null && !Objects.equals(expected = (String)existingAttachmentIdToHashMap.get(id), hash)) {
                this.throwIllegalExtension("http://hapifhir.io/fhir/StructureDefinition/externalized-binary-hash-sha256", hash);
            }
        });
    }

    private void throwIllegalExtension(String theExtensionUrl, String theValue) {
        String msg = this.myCtx.getLocalizer().getMessage(BinaryStorageInterceptor.class, "externalizedBinaryStorageExtensionFoundInRequestBody", new Object[]{theExtensionUrl, theValue});
        throw new InvalidRequestException(Msg.code((int)1329) + msg);
    }

    private void extractLargeBinaries(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, IBaseResource theResource, IBaseResource thePreviousResource, Pointcut thePointcut) throws IOException {
        IIdType resourceId = theResource.getIdElement();
        if (!resourceId.hasResourceType() && resourceId.hasIdPart()) {
            String resourceType = this.myCtx.getResourceType(theResource);
            resourceId = new IdType(resourceType + "/" + resourceId.getIdPart());
        }
        Map<String, String> existingHashToAttachmentId = this.buildHashAttachmentIdMap(thePreviousResource, false);
        List<IBinaryTarget> attachments = this.recursivelyScanResourceForBinaryData(theResource);
        for (IBinaryTarget nextTarget : attachments) {
            Object newBinaryContentId;
            String nextContentType;
            long nextPayloadLength;
            boolean shouldStoreBlob;
            byte[] data = nextTarget.getData();
            if (data == null || data.length <= 0 || !(shouldStoreBlob = this.myBinaryStorageSvc.shouldStoreBinaryContent(nextPayloadLength = (long)data.length, resourceId, nextContentType = nextTarget.getContentType()))) continue;
            String binaryContentHash = this.myBinaryAccessProvider.getBinaryContentHash(data);
            if (thePointcut == Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED) {
                newBinaryContentId = this.storeBinaryContentIfRequired(theRequestDetails, existingHashToAttachmentId, binaryContentHash, data, resourceId, nextContentType);
            } else {
                assert (thePointcut == Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED) : thePointcut.name();
                newBinaryContentId = this.myBinaryStorageSvc.newBinaryContentId();
                String prefix = this.invokeAssignBinaryContentPrefix(theRequestDetails, theResource);
                if (StringUtils.isNotBlank((CharSequence)prefix)) {
                    newBinaryContentId = prefix + (String)newBinaryContentId;
                }
                if (this.myBinaryStorageSvc.isValidBinaryContentId((String)newBinaryContentId)) {
                    List<DeferredBinaryTarget> deferredBinaryTargets = this.getOrCreateDeferredBinaryStorageList(theResource);
                    DeferredBinaryTarget newDeferredBinaryTarget = new DeferredBinaryTarget((String)newBinaryContentId, nextTarget, data);
                    deferredBinaryTargets.add(newDeferredBinaryTarget);
                    newDeferredBinaryTarget.setBlobIdPrefixHookApplied(true);
                } else {
                    throw new InternalErrorException(Msg.code((int)2341) + "Invalid binaryContent ID for backing storage service.[binaryContentId=" + (String)newBinaryContentId + ",service=" + this.myBinaryStorageSvc.getClass().getName() + "]");
                }
            }
            this.myBinaryAccessProvider.replaceDataWithExtension(nextTarget, (String)newBinaryContentId);
            this.myBinaryAccessProvider.addHashExtension(nextTarget, binaryContentHash);
        }
    }

    private Map<String, String> buildHashAttachmentIdMap(IBaseResource thePreviousResource, boolean isAttachmentIdToHash) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (thePreviousResource == null) {
            return result;
        }
        List<IBinaryTarget> previousAttachments = this.recursivelyScanResourceForBinaryData(thePreviousResource);
        for (IBinaryTarget attachment : previousAttachments) {
            Optional<String> hashOpt = attachment.getHashExtensionFiltered(EXTENSION_FILTER_PREDICATE);
            Optional<String> idOpt = attachment.getAttachmentIdFiltered(EXTENSION_FILTER_PREDICATE);
            if (isAttachmentIdToHash) {
                idOpt.ifPresent(id -> result.put((String)id, hashOpt.orElse(null)));
                continue;
            }
            hashOpt.ifPresent(hash -> result.put((String)hash, idOpt.orElse(null)));
        }
        return result;
    }

    private String storeBinaryContentIfRequired(RequestDetails theRequestDetails, Map<String, String> existingHashToAttachmentId, String binaryContentHash, byte[] data, IIdType resourceId, String nextContentType) throws IOException {
        if (existingHashToAttachmentId.get(binaryContentHash) != null) {
            return existingHashToAttachmentId.get(binaryContentHash);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        StoredDetails storedDetails = this.myBinaryStorageSvc.storeBinaryContent(resourceId, null, nextContentType, inputStream, theRequestDetails);
        return storedDetails.getBinaryContentId();
    }

    private String invokeAssignBinaryContentPrefix(RequestDetails theRequest, IBaseResource theResource) {
        IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest);
        boolean hasStorageBinaryAssignBlobIdPrefixHooks = compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_BINARY_ASSIGN_BLOB_ID_PREFIX);
        boolean hasStorageBinaryAssignBinaryContentIdPrefixHooks = compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_BINARY_ASSIGN_BINARY_CONTENT_ID_PREFIX);
        if (!hasStorageBinaryAssignBlobIdPrefixHooks && !hasStorageBinaryAssignBinaryContentIdPrefixHooks) {
            return null;
        }
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).add(IBaseResource.class, (Object)theResource);
        BaseBinaryStorageSvcImpl.setBinaryContentIdPrefixApplied(theRequest);
        Pointcut pointcutToInvoke = Pointcut.STORAGE_BINARY_ASSIGN_BINARY_CONTENT_ID_PREFIX;
        if (hasStorageBinaryAssignBlobIdPrefixHooks) {
            pointcutToInvoke = Pointcut.STORAGE_BINARY_ASSIGN_BLOB_ID_PREFIX;
        }
        return (String)compositeBroadcaster.callHooksAndReturnObject((IPointcut)pointcutToInvoke, params);
    }

    @Nonnull
    private List<DeferredBinaryTarget> getOrCreateDeferredBinaryStorageList(IBaseResource theResource) {
        ArrayList deferredBinaryTargetList = theResource.getUserData(this.getDeferredListKey());
        if (deferredBinaryTargetList == null) {
            deferredBinaryTargetList = new ArrayList();
            theResource.setUserData(this.getDeferredListKey(), deferredBinaryTargetList);
        }
        return deferredBinaryTargetList;
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void storeLargeBinariesBeforeCreatePersistence(TransactionDetails theTransactionDetails, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        if (theResource == null) {
            return;
        }
        Object deferredBinaryTargetList = theResource.getUserData(this.getDeferredListKey());
        if (deferredBinaryTargetList != null) {
            IIdType resourceId = theResource.getIdElement();
            for (DeferredBinaryTarget next : (List)deferredBinaryTargetList) {
                String blobId = next.getBlobId();
                IBinaryTarget target = next.getBinaryTarget();
                InputStream dataStream = next.getDataStream();
                String contentType = target.getContentType();
                RequestDetails requestDetails = this.initRequestDetails(next);
                this.myBinaryStorageSvc.storeBinaryContent(resourceId, blobId, contentType, dataStream, requestDetails);
            }
        }
    }

    private RequestDetails initRequestDetails(DeferredBinaryTarget theDeferredBinaryTarget) {
        ServletRequestDetails requestDetails = new ServletRequestDetails();
        if (theDeferredBinaryTarget.isBlobIdPrefixHookApplied()) {
            BaseBinaryStorageSvcImpl.setBinaryContentIdPrefixApplied((RequestDetails)requestDetails);
        }
        return requestDetails;
    }

    public String getDeferredListKey() {
        return this.myDeferredListKey;
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void preShow(IPreResourceShowDetails theDetails, RequestDetails theRequestDetails) throws IOException {
        boolean isAllowAutoInflateBinaries = this.isAllowAutoInflateBinaries();
        if (theRequestDetails != null && theRequestDetails.getUserData().containsKey(AUTO_INFLATE_BINARY_CONTENT_KEY)) {
            isAllowAutoInflateBinaries = Boolean.TRUE.equals(theRequestDetails.getUserData().get(AUTO_INFLATE_BINARY_CONTENT_KEY));
        }
        if (!isAllowAutoInflateBinaries) {
            return;
        }
        long cumulativeInflatedBytes = 0L;
        int inflatedResourceCount = 0;
        for (IBaseResource nextResource : theDetails) {
            if (nextResource == null) {
                ourLog.warn("Received a null resource during STORAGE_PRESHOW_RESOURCES. This is a bug and should be reported. Skipping resource.");
                continue;
            }
            cumulativeInflatedBytes = this.inflateBinariesInResource(cumulativeInflatedBytes, nextResource);
            ++inflatedResourceCount;
            if (cumulativeInflatedBytes < this.myAutoInflateBinariesMaximumBytes) continue;
            ourLog.debug("Exiting binary data inflation early.[byteCount={}, resourcesInflated={}, resourcesSkipped={}]", new Object[]{cumulativeInflatedBytes, inflatedResourceCount, theDetails.size() - inflatedResourceCount});
            return;
        }
        ourLog.debug("Exiting binary data inflation having inflated everything.[byteCount={}, resourcesInflated={}, resourcesSkipped=0]", (Object)cumulativeInflatedBytes, (Object)inflatedResourceCount);
    }

    private long inflateBinariesInResource(long theCumulativeInflatedBytes, IBaseResource theResource) throws IOException {
        IIdType resourceId = theResource.getIdElement();
        List<IBinaryTarget> attachments = this.recursivelyScanResourceForBinaryData(theResource);
        for (IBinaryTarget nextTarget : attachments) {
            Optional<String> attachmentId = nextTarget.getAttachmentId();
            if (!attachmentId.isPresent()) continue;
            StoredDetails blobDetails = this.myBinaryStorageSvc.fetchBinaryContentDetails(resourceId, attachmentId.get());
            if (blobDetails == null) {
                String msg = this.myCtx.getLocalizer().getMessage(BinaryAccessProvider.class, "unknownBlobId", new Object[0]);
                throw new InvalidRequestException(Msg.code((int)1330) + msg);
            }
            if (theCumulativeInflatedBytes + blobDetails.getBytes() >= this.myAutoInflateBinariesMaximumBytes) continue;
            byte[] bytes = this.myBinaryStorageSvc.fetchBinaryContent(resourceId, attachmentId.get());
            nextTarget.setData(bytes);
            theCumulativeInflatedBytes += blobDetails.getBytes();
        }
        return theCumulativeInflatedBytes;
    }

    @Nonnull
    private List<IBinaryTarget> recursivelyScanResourceForBinaryData(IBaseResource theResource) {
        final ArrayList<IBinaryTarget> binaryTargets = new ArrayList<IBinaryTarget>();
        this.myCtx.newTerser().visit((IBase)theResource, new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement.getClass().equals(BinaryStorageInterceptor.this.myBinaryType)) {
                    IBase parent = theContainingElementPath.get(theContainingElementPath.size() - 2);
                    Optional<IBinaryTarget> binaryTarget = BinaryStorageInterceptor.this.myBinaryAccessProvider.toBinaryTarget(parent);
                    binaryTarget.ifPresent(binaryTargets::add);
                }
                return true;
            }
        });
        return binaryTargets;
    }

    public void setAllowAutoInflateBinaries(boolean theAllowAutoInflateBinaries) {
        this.myAllowAutoInflateBinaries = theAllowAutoInflateBinaries;
    }

    public boolean isAllowAutoInflateBinaries() {
        return this.myAllowAutoInflateBinaries;
    }

    private static class DeferredBinaryTarget {
        private final String myBlobId;
        private final IBinaryTarget myBinaryTarget;
        private final InputStream myDataStream;
        private boolean myBlobIdPrefixHookApplied;

        private DeferredBinaryTarget(String theBlobId, IBinaryTarget theBinaryTarget, byte[] theData) {
            this.myBlobId = theBlobId;
            this.myBinaryTarget = theBinaryTarget;
            this.myDataStream = new ByteArrayInputStream(theData);
        }

        String getBlobId() {
            return this.myBlobId;
        }

        IBinaryTarget getBinaryTarget() {
            return this.myBinaryTarget;
        }

        InputStream getDataStream() {
            return this.myDataStream;
        }

        boolean isBlobIdPrefixHookApplied() {
            return this.myBlobIdPrefixHookApplied;
        }

        void setBlobIdPrefixHookApplied(boolean theBlobIdPrefixHookApplied) {
            this.myBlobIdPrefixHookApplied = theBlobIdPrefixHookApplied;
        }
    }
}

