/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.binary.api.StoredDetails;
import ca.uhn.fhir.jpa.binary.svc.BaseBinaryStorageSvcImpl;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.hash.HashingInputStream;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemBinaryStorageSvcImpl
extends BaseBinaryStorageSvcImpl {
    private static final Logger ourLog = LoggerFactory.getLogger(FilesystemBinaryStorageSvcImpl.class);
    private final File myBasePath;
    private final ObjectMapper myJsonSerializer;

    public FilesystemBinaryStorageSvcImpl(String theBasePath) {
        Validate.notBlank((CharSequence)theBasePath);
        this.myBasePath = new File(theBasePath);
        this.myJsonSerializer = new ObjectMapper();
        this.myJsonSerializer.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.myJsonSerializer.enable(SerializationFeature.INDENT_OUTPUT);
        this.createBasePathDirectory();
    }

    private void createBasePathDirectory() {
        ourLog.info("Starting binary storage service with base path: {}", (Object)this.myBasePath);
        this.mkdir(this.myBasePath);
    }

    @Override
    public boolean isValidBinaryContentId(String theNewBinaryContentId) {
        return !StringUtils.containsAny((CharSequence)theNewBinaryContentId, (char[])new char[]{'\\', '/', '|', '.'});
    }

    @Override
    @Nonnull
    public StoredDetails storeBinaryContent(IIdType theResourceId, String theBlobIdOrNull, String theContentType, InputStream theInputStream, RequestDetails theRequestDetails) throws IOException {
        String id = super.provideIdForNewBinaryContent(theBlobIdOrNull, null, theRequestDetails, theContentType);
        File storagePath = this.getStoragePath(id, true);
        File storageFilename = this.getStorageFilename(storagePath, theResourceId, id);
        ourLog.info("Writing to file: {}", (Object)storageFilename.getAbsolutePath());
        CountingInputStream countingInputStream = this.createCountingInputStream(theInputStream);
        HashingInputStream hashingInputStream = this.createHashingInputStream((InputStream)countingInputStream);
        try (FileOutputStream outputStream = new FileOutputStream(storageFilename);){
            IOUtils.copy((InputStream)hashingInputStream, (OutputStream)outputStream);
        }
        long count = countingInputStream.getByteCount();
        StoredDetails details = new StoredDetails(id, count, theContentType, hashingInputStream, new Date());
        File descriptorFilename = this.getDescriptorFilename(storagePath, theResourceId, id);
        ourLog.info("Writing to file: {}", (Object)descriptorFilename.getAbsolutePath());
        try (FileWriter writer = new FileWriter(descriptorFilename);){
            this.myJsonSerializer.writeValue((Writer)writer, (Object)details);
        }
        ourLog.info("Stored binary blob with {} bytes and ContentType {} for resource {}", new Object[]{count, theContentType, theResourceId});
        return details;
    }

    @Override
    public StoredDetails fetchBinaryContentDetails(IIdType theResourceId, String theBlobId) throws IOException {
        File file;
        StoredDetails retVal = null;
        File storagePath = this.getStoragePath(theBlobId, false);
        if (storagePath != null && (file = this.getDescriptorFilename(storagePath, theResourceId, theBlobId)).exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);
                 InputStreamReader reader = new InputStreamReader((InputStream)inputStream, Charsets.UTF_8);){
                retVal = (StoredDetails)this.myJsonSerializer.readValue((Reader)reader, StoredDetails.class);
            }
        }
        return retVal;
    }

    @Override
    public boolean writeBinaryContent(IIdType theResourceId, String theBlobId, OutputStream theOutputStream) throws IOException {
        InputStream inputStream = this.getInputStream(theResourceId, theBlobId);
        if (inputStream != null) {
            try (InputStream inputStream2 = inputStream;){
                IOUtils.copy((InputStream)inputStream, (OutputStream)theOutputStream);
                theOutputStream.close();
            }
        }
        return false;
    }

    @Nullable
    private InputStream getInputStream(IIdType theResourceId, String theBlobId) throws FileNotFoundException {
        File file;
        File storagePath = this.getStoragePath(theBlobId, false);
        FileInputStream inputStream = null;
        if (storagePath != null && (file = this.getStorageFilename(storagePath, theResourceId, theBlobId)).exists()) {
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }

    @Override
    public void expungeBinaryContent(IIdType theResourceId, String theBlobId) {
        File storagePath = this.getStoragePath(theBlobId, false);
        if (storagePath != null) {
            File descriptorFile;
            File storageFile = this.getStorageFilename(storagePath, theResourceId, theBlobId);
            if (storageFile.exists()) {
                this.delete(storageFile, theBlobId);
            }
            if ((descriptorFile = this.getDescriptorFilename(storagePath, theResourceId, theBlobId)).exists()) {
                this.delete(descriptorFile, theBlobId);
            }
        }
    }

    @Override
    public byte[] fetchBinaryContent(IIdType theResourceId, String theBlobId) throws IOException {
        StoredDetails details = this.fetchBinaryContentDetails(theResourceId, theBlobId);
        try (InputStream inputStream = this.getInputStream(theResourceId, theBlobId);){
            if (inputStream != null) {
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream, (long)details.getBytes());
                return byArray;
            }
        }
        throw new ResourceNotFoundException(Msg.code((int)1327) + "Unknown blob ID: " + theBlobId + " for resource ID " + String.valueOf(theResourceId));
    }

    private void delete(File theStorageFile, String theBlobId) {
        Validate.isTrue((boolean)theStorageFile.delete(), (String)"Failed to delete file for blob %s", (Object[])new Object[]{theBlobId});
    }

    @Nonnull
    private File getDescriptorFilename(File theStoragePath, IIdType theResourceId, String theId) {
        return this.getStorageFilename(theStoragePath, theResourceId, theId, ".json");
    }

    @Nonnull
    private File getStorageFilename(File theStoragePath, IIdType theResourceId, String theId) {
        return this.getStorageFilename(theStoragePath, theResourceId, theId, ".bin");
    }

    private File getStorageFilename(File theStoragePath, IIdType theResourceId, String theId, String theExtension) {
        Validate.notBlank((CharSequence)theResourceId.getResourceType());
        Validate.notBlank((CharSequence)theResourceId.getIdPart());
        String filename = theResourceId.getResourceType() + "_" + theResourceId.getIdPart() + "_" + theId;
        return new File(theStoragePath, filename + theExtension);
    }

    private File getStoragePath(String theId, boolean theCreate) {
        File path = this.myBasePath;
        for (int i = 0; i < 10; ++i) {
            if ((path = new File(path, theId.substring(i, i + 1))).exists()) continue;
            if (theCreate) {
                this.mkdir(path);
                continue;
            }
            return null;
        }
        return path;
    }

    private void mkdir(File theBasePath) {
        try {
            FileUtils.forceMkdir((File)theBasePath);
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code((int)1328) + "Unable to create path " + String.valueOf(this.myBasePath) + ": " + String.valueOf(e));
        }
    }
}

