/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.bulk.export.model.ExportPIDIteratorParameters;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkExportHelperService {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkExportHelperService.class);
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private FhirContext myContext;

    public List<SearchParameterMap> createSearchParameterMapsForResourceType(RuntimeResourceDefinition theDef, ExportPIDIteratorParameters theParams, boolean theConsiderDateRange) {
        String resourceType = theDef.getName();
        List<String> typeFilters = theParams.getFilters();
        List<SearchParameterMap> spMaps = null;
        spMaps = typeFilters.stream().filter(typeFilter -> typeFilter.startsWith(resourceType + "?")).map(filter -> this.buildSearchParameterMapForTypeFilter((String)filter, theDef, theParams.getStartDate(), theParams.getEndDate())).collect(Collectors.toList());
        typeFilters.stream().filter(filter -> !filter.contains("?")).forEach(filter -> ourLog.warn("Found a strange _typeFilter that we could not process: {}. _typeFilters should follow the format ResourceType?searchparameter=value .", filter));
        if (spMaps.isEmpty()) {
            SearchParameterMap defaultMap = new SearchParameterMap();
            if (theConsiderDateRange) {
                this.addLastUpdatedFilter(defaultMap, theParams.getStartDate(), theParams.getEndDate());
            }
            spMaps = Collections.singletonList(defaultMap);
        }
        return spMaps;
    }

    private SearchParameterMap buildSearchParameterMapForTypeFilter(String theFilter, RuntimeResourceDefinition theDef, Date theStartDate, Date theEndDate) {
        SearchParameterMap searchParameterMap = this.myMatchUrlService.translateMatchUrl(theFilter, theDef, new MatchUrlService.Flag[0]);
        this.addLastUpdatedFilter(searchParameterMap, theStartDate, theEndDate);
        return searchParameterMap;
    }

    void addLastUpdatedFilter(SearchParameterMap map, Date theStartDate, Date theEndDate) {
        map.setLoadSynchronous(true);
        if (theStartDate != null || theEndDate != null) {
            map.setLastUpdated(new DateRangeParam(theStartDate, theEndDate));
        }
    }

    public IIdType toId(String theResourceId) {
        IIdType retVal = this.myContext.getVersion().newIdType();
        retVal.setValue(theResourceId);
        return retVal;
    }
}

