/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.LazyDaoMethodOutcome;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourcePersistentIdMap;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.StorageResponseCodeEnum;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IMetaTagSorter;
import ca.uhn.fhir.util.MetaUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseStorageDao {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseStorageDao.class);
    @Deprecated(forRemoval=true, since="8.4.0")
    public static final String OO_SEVERITY_ERROR = "error";
    @Deprecated(forRemoval=true, since="8.4.0")
    public static final String OO_SEVERITY_INFO = "information";
    @Deprecated(forRemoval=true, since="8.4.0")
    public static final String OO_SEVERITY_WARN = "warning";
    private static final String PROCESSING_SUB_REQUEST = "BaseStorageDao.processingSubRequest";
    protected static final String MESSAGE_KEY_DELETE_RESOURCE_NOT_EXISTING = "deleteResourceNotExisting";
    protected static final String MESSAGE_KEY_DELETE_RESOURCE_ALREADY_DELETED = "deleteResourceAlreadyDeleted";
    public static final String OO_ISSUE_CODE_INFORMATIONAL = "informational";
    @Autowired
    protected ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected IResourceVersionSvc myResourceVersionSvc;
    @Autowired
    protected JpaStorageSettings myStorageSettings;
    @Autowired
    protected IMetaTagSorter myMetaTagSorter;

    @VisibleForTesting
    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    @VisibleForTesting
    public void setMyMetaTagSorter(IMetaTagSorter theMetaTagSorter) {
        this.myMetaTagSorter = theMetaTagSorter;
    }

    protected void preProcessResourceForStorage(IBaseResource theResource) {
    }

    protected void preProcessResourceForStorage(IBaseResource theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, boolean thePerformIndexing) {
        this.verifyResourceTypeIsAppropriateForDao(theResource);
        this.verifyResourceIdIsValid(theResource);
        this.verifyBundleTypeIsAppropriateForStorage(theResource);
        if (!this.getStorageSettings().getTreatBaseUrlsAsLocal().isEmpty()) {
            this.replaceAbsoluteReferencesWithRelative(theResource, this.myFhirContext.newTerser());
        }
        this.performAutoVersioning(theResource, thePerformIndexing);
        this.myMetaTagSorter.sort(theResource.getMeta());
    }

    private void verifyResourceTypeIsAppropriateForDao(IBaseResource theResource) {
        String type = this.getContext().getResourceType(theResource);
        if (this.getResourceName() != null && !this.getResourceName().equals(type)) {
            throw new InvalidRequestException(Msg.code((int)520) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "incorrectResourceType", new Object[]{type, this.getResourceName()}));
        }
    }

    private void verifyResourceIdIsValid(IBaseResource theResource) {
        String expectedType;
        if (theResource.getIdElement().hasResourceType() && !(expectedType = this.getContext().getResourceType(theResource)).equals(theResource.getIdElement().getResourceType())) {
            throw new InvalidRequestException(Msg.code((int)2616) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "failedToCreateWithInvalidIdWrongResourceType", new Object[]{theResource.getIdElement().toUnqualifiedVersionless()}));
        }
        if (theResource.getIdElement().hasIdPart() && !theResource.getIdElement().isIdPartValid()) {
            throw new InvalidRequestException(Msg.code((int)521) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "failedToCreateWithInvalidId", new Object[]{theResource.getIdElement().getIdPart()}));
        }
    }

    private void verifyBundleTypeIsAppropriateForStorage(IBaseResource theResource) {
        if (theResource instanceof IBaseBundle) {
            Set<String> allowedBundleTypes = this.getStorageSettings().getBundleTypesAllowedForStorage();
            String bundleType = BundleUtil.getBundleType((FhirContext)this.getContext(), (IBaseBundle)((IBaseBundle)theResource));
            if (!allowedBundleTypes.contains(bundleType = StringUtils.defaultString((String)bundleType))) {
                String message = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidBundleTypeForStorage", new Object[]{StringUtils.isNotBlank((CharSequence)bundleType) ? bundleType : "(missing)"});
                throw new UnprocessableEntityException(Msg.code((int)522) + message);
            }
        }
    }

    private void replaceAbsoluteReferencesWithRelative(IBaseResource theResource, FhirTerser theTerser) {
        List refs = theTerser.getAllResourceReferences(theResource);
        for (ResourceReferenceInfo nextRef : refs) {
            IIdType refId = nextRef.getResourceReference().getReferenceElement();
            if (refId == null || !refId.hasBaseUrl() || !this.getStorageSettings().getTreatBaseUrlsAsLocal().contains(refId.getBaseUrl())) continue;
            IIdType newRefId = refId.toUnqualified();
            nextRef.getResourceReference().setReference(newRefId.getValue());
        }
    }

    private void performAutoVersioning(IBaseResource theResource, boolean thePerformIndexing) {
        if (thePerformIndexing) {
            Set<IBaseReference> referencesToVersion = BaseStorageDao.extractReferencesToAutoVersion(this.myFhirContext, this.myStorageSettings, theResource);
            for (IBaseReference nextReference : referencesToVersion) {
                Long version;
                IIdType referenceElement = nextReference.getReferenceElement();
                if (referenceElement.hasBaseUrl()) continue;
                ResourcePersistentIdMap resourceVersionMap = this.myResourceVersionSvc.getLatestVersionIdsForResourceIds(RequestPartitionId.allPartitions(), Collections.singletonList(referenceElement));
                if (resourceVersionMap.containsKey(referenceElement)) {
                    version = resourceVersionMap.getResourcePersistentId(referenceElement).getVersion();
                } else if (this.myStorageSettings.isAutoCreatePlaceholderReferenceTargets()) {
                    version = 1L;
                } else {
                    throw new ResourceNotFoundException(Msg.code((int)523) + String.valueOf(referenceElement));
                }
                String newTargetReference = referenceElement.withVersion(version.toString()).getValue();
                nextReference.setReference(newTargetReference);
            }
        }
    }

    protected DaoMethodOutcome toMethodOutcome(RequestDetails theRequest, @Nonnull IBasePersistedResource theEntity, @Nonnull IBaseResource theResource, @Nullable String theMatchUrl, @Nonnull RestOperationTypeEnum theOperationType) {
        DaoMethodOutcome outcome = new DaoMethodOutcome();
        IResourcePersistentId persistentId = theEntity.getPersistentId();
        persistentId.setAssociatedResourceId(theResource.getIdElement());
        outcome.setPersistentId(persistentId);
        outcome.setMatchUrl(theMatchUrl);
        outcome.setOperationType(theOperationType);
        if (theEntity instanceof ResourceTable && ((ResourceTable)theEntity).isUnchangedInCurrentOperation()) {
            outcome.setNop(true);
        }
        IIdType id = null;
        if (theResource.getIdElement().getValue() != null) {
            id = theResource.getIdElement();
        }
        if (id == null) {
            id = theEntity.getIdDt();
            if (this.getContext().getVersion().getVersion().isRi()) {
                id = this.getContext().getVersion().newIdType().setValue(id.getValue());
            }
        }
        outcome.setId(id);
        if (theEntity.getDeleted() == null) {
            outcome.setResource(theResource);
        }
        outcome.setEntity(theEntity);
        if (outcome.getResource() != null) {
            SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(outcome.getResource());
            IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest);
            if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PREACCESS_RESOURCES)) {
                HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                compositeBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, params);
                if (accessDetails.isDontReturnResourceAtIndex(0)) {
                    outcome.setResource(null);
                }
            }
        }
        outcome.registerResourceViewCallback(() -> {
            IInterceptorBroadcaster compositeBroadcaster;
            if (outcome.getResource() != null && (compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest)).hasHooks((IPointcut)Pointcut.STORAGE_PRESHOW_RESOURCES)) {
                SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(outcome.getResource());
                HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                compositeBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, params);
                outcome.setResource(showDetails.getResource(0));
            }
        });
        return outcome;
    }

    protected DaoMethodOutcome toMethodOutcomeLazy(RequestDetails theRequest, IResourcePersistentId theResourcePersistentId, @Nonnull Supplier<LazyDaoMethodOutcome.EntityAndResource> theEntity, Supplier<IIdType> theIdSupplier) {
        LazyDaoMethodOutcome outcome = new LazyDaoMethodOutcome(theResourcePersistentId);
        outcome.setEntitySupplier(theEntity);
        outcome.setIdSupplier(theIdSupplier);
        outcome.setEntitySupplierUseCallback(() -> {
            IInterceptorBroadcaster compositeBroadcaster;
            if (outcome.getResource() != null && (compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest)).hasHooks((IPointcut)Pointcut.STORAGE_PREACCESS_RESOURCES)) {
                SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(outcome.getResource());
                HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                compositeBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, params);
                if (accessDetails.isDontReturnResourceAtIndex(0)) {
                    outcome.setResource(null);
                }
            }
            outcome.registerResourceViewCallback(() -> {
                IInterceptorBroadcaster compositeBroadcaster;
                if (outcome.getResource() != null && (compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequest)).hasHooks((IPointcut)Pointcut.STORAGE_PRESHOW_RESOURCES)) {
                    SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(outcome.getResource());
                    HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                    compositeBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, params);
                    outcome.setResource(showDetails.getResource(0));
                }
            });
        });
        return outcome;
    }

    protected void doCallHooks(TransactionDetails theTransactionDetails, RequestDetails theRequestDetails, Pointcut thePointcut, HookParams theParams) {
        if (theTransactionDetails.isAcceptingDeferredInterceptorBroadcasts(thePointcut)) {
            theTransactionDetails.addDeferredInterceptorBroadcast(thePointcut, theParams);
        } else {
            IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.getInterceptorBroadcaster(), (RequestDetails)theRequestDetails);
            compositeBroadcaster.callHooks((IPointcut)thePointcut, theParams);
        }
    }

    protected abstract IInterceptorBroadcaster getInterceptorBroadcaster();

    public IBaseOperationOutcome createErrorOperationOutcome(String theMessage, String theCode) {
        return this.createOperationOutcome(OO_SEVERITY_ERROR, theMessage, theCode);
    }

    public IBaseOperationOutcome createInfoOperationOutcome(String theMessage) {
        return this.createInfoOperationOutcome(theMessage, null);
    }

    public IBaseOperationOutcome createInfoOperationOutcome(String theMessage, @Nullable StorageResponseCodeEnum theStorageResponseCode) {
        return OperationOutcomeUtil.createOperationOutcome((String)OO_SEVERITY_INFO, (String)theMessage, (String)OO_ISSUE_CODE_INFORMATIONAL, (FhirContext)this.getContext(), (StorageResponseCodeEnum)theStorageResponseCode);
    }

    private IBaseOperationOutcome createOperationOutcome(String theSeverity, String theMessage, String theCode) {
        return OperationOutcomeUtil.createOperationOutcome((String)theSeverity, (String)theMessage, (String)theCode, (FhirContext)this.getContext(), null);
    }

    @Nonnull
    public IBaseOperationOutcome createWarnOperationOutcome(String theMsg, String theCode, StorageResponseCodeEnum theResponseCodeEnum) {
        return OperationOutcomeUtil.createOperationOutcome((String)OO_SEVERITY_WARN, (String)theMsg, (String)theCode, (FhirContext)this.getContext(), (StorageResponseCodeEnum)theResponseCodeEnum);
    }

    protected DaoMethodOutcome createMethodOutcomeForResourceId(String theResourceId, String theMessageKey, StorageResponseCodeEnum theStorageResponseCode) {
        DaoMethodOutcome outcome = new DaoMethodOutcome();
        IIdType id = this.getContext().getVersion().newIdType();
        id.setValue(theResourceId);
        outcome.setId(id);
        String message = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, theMessageKey, new Object[]{id});
        String severity = OO_SEVERITY_INFO;
        String code = OO_ISSUE_CODE_INFORMATIONAL;
        IBaseOperationOutcome oo = OperationOutcomeUtil.createOperationOutcome((String)severity, (String)message, (String)code, (FhirContext)this.getContext(), (StorageResponseCodeEnum)theStorageResponseCode);
        outcome.setOperationOutcome(oo);
        return outcome;
    }

    @Nonnull
    protected ResourceGoneException createResourceGoneException(IBasePersistedResource theResourceEntity) {
        StringBuilder b = new StringBuilder();
        b.append("Resource was deleted at ");
        b.append(new InstantType(theResourceEntity.getDeleted()).getValueAsString());
        ResourceGoneException retVal = new ResourceGoneException(b.toString());
        retVal.setResourceId(theResourceEntity.getIdDt());
        return retVal;
    }

    protected abstract JpaStorageSettings getStorageSettings();

    @Nullable
    protected abstract String getResourceName();

    protected abstract FhirContext getContext();

    @Transactional(propagation=Propagation.SUPPORTS)
    public void translateRawParameters(Map<String, List<String>> theSource, SearchParameterMap theTarget) {
        if (theSource == null || theSource.isEmpty()) {
            return;
        }
        ResourceSearchParams searchParams = this.mySearchParamRegistry.getActiveSearchParams(this.getResourceName(), ISearchParamRegistry.SearchParamLookupContextEnum.SEARCH);
        Set<String> paramNames = theSource.keySet();
        for (String nextParamName : paramNames) {
            QualifierDetails qualifiedParamName = QualifierDetails.extractQualifiersFromParameterName((String)nextParamName);
            RuntimeSearchParam param = searchParams.get(qualifiedParamName.getParamName());
            if (param == null) {
                String msg;
                Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(this.getResourceName(), ISearchParamRegistry.SearchParamLookupContextEnum.SEARCH);
                RuntimeSearchParam notEnabledForSearchParam = this.mySearchParamRegistry.getActiveSearchParam(this.getResourceName(), qualifiedParamName.getParamName(), ISearchParamRegistry.SearchParamLookupContextEnum.ALL);
                if (notEnabledForSearchParam != null) {
                    msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameterNotEnabledForSearch", new Object[]{qualifiedParamName.getParamName(), this.getResourceName(), validNames});
                    throw new InvalidRequestException(Msg.code((int)2539) + msg);
                }
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameter", new Object[]{qualifiedParamName.getParamName(), this.getResourceName(), validNames});
                throw new InvalidRequestException(Msg.code((int)524) + msg);
            }
            RuntimeSearchParam paramDef = this.mySearchParamRegistry.getActiveSearchParam(this.getResourceName(), qualifiedParamName.getParamName(), ISearchParamRegistry.SearchParamLookupContextEnum.SEARCH);
            for (String nextValue : theSource.get(nextParamName)) {
                QualifiedParamList qualifiedParam = QualifiedParamList.splitQueryStringByCommasIgnoreEscape((String)qualifiedParamName.getWholeQualifier(), (String)nextValue);
                List<QualifiedParamList> paramList = Collections.singletonList(qualifiedParam);
                IQueryParameterAnd parsedParam = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.getContext(), (RuntimeSearchParam)paramDef, (String)nextParamName, paramList);
                theTarget.add(qualifiedParamName.getParamName(), parsedParam);
            }
        }
    }

    protected void populateOperationOutcomeForUpdate(@Nullable StopWatch theItemStopwatch, DaoMethodOutcome theMethodOutcome, String theMatchUrl, RestOperationTypeEnum theOperationType, TransactionDetails theTransactionDetails) {
        Object msg;
        StorageResponseCodeEnum outcome;
        if (theOperationType == RestOperationTypeEnum.PATCH) {
            if (theMatchUrl != null) {
                if (theMethodOutcome.isNop()) {
                    outcome = StorageResponseCodeEnum.SUCCESSFUL_CONDITIONAL_PATCH_NO_CHANGE;
                    msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulPatchConditionalNoChange", new Object[]{theMethodOutcome.getId(), UrlUtil.sanitizeUrlPart((CharSequence)theMatchUrl), theMethodOutcome.getId()});
                } else {
                    outcome = StorageResponseCodeEnum.SUCCESSFUL_CONDITIONAL_PATCH;
                    msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulPatchConditional", new Object[]{theMethodOutcome.getId(), UrlUtil.sanitizeUrlPart((CharSequence)theMatchUrl), theMethodOutcome.getId()});
                }
            } else if (theMethodOutcome.isNop()) {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_PATCH_NO_CHANGE;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulPatchNoChange", new Object[]{theMethodOutcome.getId()});
            } else {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_PATCH;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulPatch", new Object[]{theMethodOutcome.getId()});
            }
        } else if (theOperationType == RestOperationTypeEnum.CREATE) {
            if (theMatchUrl == null) {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_CREATE;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulCreate", new Object[]{theMethodOutcome.getId()});
            } else if (theMethodOutcome.isNop()) {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_CREATE_WITH_CONDITIONAL_MATCH;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulCreateConditionalWithMatch", new Object[]{theMethodOutcome.getId(), UrlUtil.sanitizeUrlPart((CharSequence)theMatchUrl)});
            } else {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_CREATE_NO_CONDITIONAL_MATCH;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulCreateConditionalNoMatch", new Object[]{theMethodOutcome.getId(), UrlUtil.sanitizeUrlPart((CharSequence)theMatchUrl)});
            }
        } else if (theMethodOutcome.isNop()) {
            if (theMatchUrl != null) {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE_WITH_CONDITIONAL_MATCH_NO_CHANGE;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdateConditionalNoChangeWithMatch", new Object[]{theMethodOutcome.getId(), theMatchUrl});
            } else {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE_NO_CHANGE;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdateNoChange", new Object[]{theMethodOutcome.getId()});
            }
        } else if (theMatchUrl != null) {
            if (theMethodOutcome.getCreated() == Boolean.TRUE) {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE_NO_CONDITIONAL_MATCH;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdateConditionalNoMatch", new Object[]{theMethodOutcome.getId()});
            } else {
                outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE_WITH_CONDITIONAL_MATCH;
                msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdateConditionalWithMatch", new Object[]{theMethodOutcome.getId(), theMatchUrl});
            }
        } else if (theMethodOutcome.getCreated() == Boolean.TRUE) {
            outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE_AS_CREATE;
            msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdateAsCreate", new Object[]{theMethodOutcome.getId()});
        } else {
            outcome = StorageResponseCodeEnum.SUCCESSFUL_UPDATE;
            msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulUpdate", new Object[]{theMethodOutcome.getId()});
        }
        if (theItemStopwatch != null) {
            String msgSuffix = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulTimingSuffix", new Object[]{theItemStopwatch.getMillis()});
            msg = (String)msg + " " + msgSuffix;
        }
        IBaseOperationOutcome oo = this.createInfoOperationOutcome((String)msg, outcome);
        if (theTransactionDetails != null) {
            List autoCreatedPlaceholderResources = theTransactionDetails.getAutoCreatedPlaceholderResourcesAndClear();
            for (IIdType next : autoCreatedPlaceholderResources) {
                msg = BaseStorageDao.addIssueToOperationOutcomeForAutoCreatedPlaceholder(this.getContext(), next, oo);
            }
        }
        theMethodOutcome.setOperationOutcome(oo);
        ourLog.debug((String)msg);
    }

    public static String addIssueToOperationOutcomeForAutoCreatedPlaceholder(FhirContext theFhirContext, IIdType thePlaceholderId, IBaseOperationOutcome theOperationOutcomeToPopulate) {
        String detailDescription;
        String detailCode;
        String detailSystem;
        String msg = theFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulAutoCreatePlaceholder", new Object[]{thePlaceholderId});
        IBase issue = OperationOutcomeUtil.addIssue((FhirContext)theFhirContext, (IBaseOperationOutcome)theOperationOutcomeToPopulate, (String)OO_SEVERITY_INFO, (String)msg, null, (String)OO_ISSUE_CODE_INFORMATIONAL, (String)(detailSystem = StorageResponseCodeEnum.AUTOMATICALLY_CREATED_PLACEHOLDER_RESOURCE.getSystem()), (String)(detailCode = StorageResponseCodeEnum.AUTOMATICALLY_CREATED_PLACEHOLDER_RESOURCE.getCode()), (String)(detailDescription = StorageResponseCodeEnum.AUTOMATICALLY_CREATED_PLACEHOLDER_RESOURCE.getDisplay()));
        if (issue instanceof IBaseHasExtensions) {
            IBaseExtension resourceIdExtension = ((IBaseHasExtensions)issue).addExtension();
            resourceIdExtension.setUrl("http://hapifhir.io/fhir/StructureDefinition/oo-placeholder-id");
            resourceIdExtension.setValue((IBaseDatatype)theFhirContext.getVersion().newIdType(thePlaceholderId.getValue()));
        }
        return msg;
    }

    public static Set<IBaseReference> extractReferencesToAvoidReplacement(FhirContext theFhirContext, IBaseResource theResource) {
        if (!theFhirContext.getParserOptions().getDontStripVersionsFromReferencesAtPaths().isEmpty()) {
            String theResourceType = theFhirContext.getResourceType(theResource);
            Set versionReferencesPaths = theFhirContext.getParserOptions().getDontStripVersionsFromReferencesAtPathsByResourceType(theResourceType);
            return BaseStorageDao.getReferencesWithOrWithoutVersionId(versionReferencesPaths, theFhirContext, theResource, false);
        }
        return Collections.emptySet();
    }

    @Nonnull
    public static Set<IBaseReference> extractReferencesToAutoVersion(FhirContext theFhirContext, StorageSettings theStorageSettings, IBaseResource theResource) {
        Set<IBaseReference> referencesToAutoVersionFromConfig = BaseStorageDao.getReferencesToAutoVersionFromConfig(theFhirContext, theStorageSettings, theResource);
        Set<IBaseReference> referencesToAutoVersionFromExtensions = BaseStorageDao.getReferencesToAutoVersionFromExtension(theFhirContext, theResource);
        return Stream.concat(referencesToAutoVersionFromConfig.stream(), referencesToAutoVersionFromExtensions.stream()).collect(Collectors.toMap(ref -> ref, ref -> ref, (oldRef, newRef) -> oldRef, IdentityHashMap::new)).keySet();
    }

    @Nonnull
    private static Set<IBaseReference> getReferencesToAutoVersionFromExtension(FhirContext theFhirContext, IBaseResource theResource) {
        String resourceType = theFhirContext.getResourceType(theResource);
        Set autoVersionReferencesAtPaths = MetaUtil.getAutoVersionReferencesAtPath((IBaseMetaType)theResource.getMeta(), (String)resourceType);
        if (!autoVersionReferencesAtPaths.isEmpty()) {
            return BaseStorageDao.getReferencesWithOrWithoutVersionId(autoVersionReferencesAtPaths, theFhirContext, theResource, true);
        }
        return Collections.emptySet();
    }

    @Nonnull
    private static Set<IBaseReference> getReferencesToAutoVersionFromConfig(FhirContext theFhirContext, StorageSettings theStorageSettings, IBaseResource theResource) {
        if (!theStorageSettings.getAutoVersionReferenceAtPaths().isEmpty()) {
            String resourceName = theFhirContext.getResourceType(theResource);
            Set autoVersionReferencesPaths = theStorageSettings.getAutoVersionReferenceAtPathsByResourceType(resourceName);
            return BaseStorageDao.getReferencesWithOrWithoutVersionId(autoVersionReferencesPaths, theFhirContext, theResource, true);
        }
        return Collections.emptySet();
    }

    private static Set<IBaseReference> getReferencesWithOrWithoutVersionId(Set<String> theVersionReferencesPaths, FhirContext theFhirContext, IBaseResource theResource, boolean theShouldFilterByRefsWithoutVersionId) {
        return theVersionReferencesPaths.stream().map(fullPath -> theFhirContext.newTerser().getValues((IBase)theResource, fullPath, IBaseReference.class)).flatMap(Collection::stream).filter(reference -> reference.getReferenceElement().hasVersionIdPart() ^ theShouldFilterByRefsWithoutVersionId).collect(Collectors.toMap(ref -> ref, ref -> ref, (oldRef, newRef) -> oldRef, IdentityHashMap::new)).keySet();
    }

    public static void clearRequestAsProcessingSubRequest(RequestDetails theRequestDetails) {
        if (theRequestDetails != null) {
            theRequestDetails.getUserData().remove(PROCESSING_SUB_REQUEST);
        }
    }

    public static void markRequestAsProcessingSubRequest(RequestDetails theRequestDetails) {
        if (theRequestDetails != null) {
            theRequestDetails.getUserData().put(PROCESSING_SUB_REQUEST, Boolean.TRUE);
        }
    }
}

