/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IJpaDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IStorageResourceParser;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.patch.FhirPatch;
import ca.uhn.fhir.jpa.patch.JsonPatchUtils;
import ca.uhn.fhir.jpa.patch.XmlPatchUtils;
import ca.uhn.fhir.jpa.update.UpdateParameters;
import ca.uhn.fhir.parser.StrictErrorHandler;
import ca.uhn.fhir.rest.api.DeleteCascadeModeEnum;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class BaseStorageResourceDao<T extends IBaseResource>
extends BaseStorageDao
implements IFhirResourceDao<T>,
IJpaDao<T> {
    public static final StrictErrorHandler STRICT_ERROR_HANDLER = new StrictErrorHandler();

    @Autowired
    protected abstract HapiTransactionService getTransactionService();

    @Autowired
    protected abstract MatchResourceUrlService getMatchResourceUrlService();

    @Autowired
    protected abstract IStorageResourceParser getStorageResourceParser();

    @Autowired
    protected abstract IDeleteExpungeJobSubmitter getDeleteExpungeJobSubmitter();

    @Autowired
    protected abstract IRequestPartitionHelperSvc getRequestPartitionHelperService();

    @Override
    public DaoMethodOutcome patch(IIdType theId, String theConditionalUrl, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        return (DaoMethodOutcome)((Object)this.getTransactionService().withRequest(theRequestDetails).withTransactionDetails(transactionDetails).execute(tx -> this.patchInTransaction(theId, theConditionalUrl, true, thePatchType, thePatchBody, theFhirPatchBody, theRequestDetails, transactionDetails)));
    }

    @Override
    public DaoMethodOutcome patchInTransaction(IIdType theId, String theConditionalUrl, boolean thePerformIndexing, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource destination;
        IIdType resourceId;
        IBasePersistedResource entityToUpdate;
        boolean isHistoryRewrite;
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        boolean bl = isHistoryRewrite = this.myStorageSettings.isUpdateWithHistoryRewriteEnabled() && theRequestDetails != null && theRequestDetails.isRewriteHistory();
        if (isHistoryRewrite && !theId.hasVersionIdPart()) {
            throw new InvalidRequestException(Msg.code((int)2717) + "Invalid resource ID for rewrite history: ID must contain a history version");
        }
        RequestPartitionId theRequestPartitionId = this.getRequestPartitionHelperService().determineReadPartitionForRequestForSearchType(theRequestDetails, this.getResourceName());
        if (StringUtils.isNotBlank((CharSequence)theConditionalUrl)) {
            entityToUpdate = this.getEntityToPatchWithMatchUrlCache(theConditionalUrl, theRequestDetails, theTransactionDetails, theRequestPartitionId);
            resourceId = entityToUpdate.getIdDt();
        } else {
            resourceId = theId;
            if (isHistoryRewrite) {
                entityToUpdate = this.readEntity(theId, theRequestDetails);
            } else {
                entityToUpdate = this.readEntityLatestVersion(theId, theRequestDetails, theTransactionDetails);
                BaseStorageResourceDao.validateIsCurrentVersionOrThrow(theId, entityToUpdate);
            }
        }
        this.validateResourceIsNotDeletedOrThrow(entityToUpdate);
        BaseStorageResourceDao.validateResourceType(entityToUpdate, this.getResourceName());
        IBaseResource resourceToUpdate = this.getStorageResourceParser().toResource(entityToUpdate, false);
        if (resourceToUpdate == null) {
            resourceToUpdate = theTransactionDetails.getResolvedResource(resourceId);
        }
        IBaseResource destinationCasted = destination = this.applyPatchToResource(thePatchType, thePatchBody, theFhirPatchBody, resourceToUpdate);
        this.preProcessResourceForStorage(destinationCasted, theRequestDetails, theTransactionDetails, true);
        if (isHistoryRewrite) {
            return (DaoMethodOutcome)((Object)this.getTransactionService().withRequest(theRequestDetails).withTransactionDetails(theTransactionDetails).execute(tx -> this.doUpdateWithHistoryRewrite(destinationCasted, theRequestDetails, theTransactionDetails, theRequestPartitionId, RestOperationTypeEnum.PATCH)));
        }
        UpdateParameters<IBaseResource> updateParameters = new UpdateParameters().setRequestDetails(theRequestDetails).setResourceIdToUpdate(resourceId).setMatchUrl(theConditionalUrl).setShouldPerformIndexing(thePerformIndexing).setShouldForceUpdateVersion(false).setResource(destinationCasted).setEntity(entityToUpdate).setOperationType(RestOperationTypeEnum.PATCH).setTransactionDetails(theTransactionDetails).setShouldForcePopulateOldResourceForProcessing(false);
        return this.doUpdateForUpdateOrPatch(updateParameters);
    }

    private static void validateIsCurrentVersionOrThrow(IIdType theId, IBasePersistedResource theEntityToUpdate) {
        if (theId.hasVersionIdPart() && theId.getVersionIdPartAsLong().longValue() != theEntityToUpdate.getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)974) + "Version " + theId.getVersionIdPart() + " is not the most recent version of this resource, unable to apply patch");
        }
    }

    DaoMethodOutcome doUpdateWithHistoryRewrite(T theResource, RequestDetails theRequest, TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId, RestOperationTypeEnum theRestOperationType) {
        throw new UnsupportedOperationException(Msg.code((int)2718) + "Patch with history rewrite is unsupported.");
    }

    private void validateResourceIsNotDeletedOrThrow(IBasePersistedResource theEntityToUpdate) {
        if (theEntityToUpdate.isDeleted()) {
            throw this.createResourceGoneException(theEntityToUpdate);
        }
    }

    private IBaseResource applyPatchToResource(PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, IBaseResource theResourceToUpdate) {
        return switch (thePatchType) {
            case PatchTypeEnum.JSON_PATCH -> JsonPatchUtils.apply(this.getContext(), theResourceToUpdate, thePatchBody);
            case PatchTypeEnum.XML_PATCH -> XmlPatchUtils.apply(this.getContext(), theResourceToUpdate, thePatchBody);
            default -> {
                IBaseParameters fhirPatchJson = theFhirPatchBody;
                new FhirPatch(this.getContext()).apply(theResourceToUpdate, (IBaseResource)fhirPatchJson);
                yield theResourceToUpdate;
            }
        };
    }

    private IBasePersistedResource getEntityToPatchWithMatchUrlCache(String theConditionalUrl, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId) {
        Set match = this.getMatchResourceUrlService().processMatchUrl(theConditionalUrl, this.getResourceType(), theTransactionDetails, theRequestDetails, theRequestPartitionId);
        if (match.size() > 1) {
            String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"PATCH", this.getResourceName(), theConditionalUrl, match.size()});
            throw new PreconditionFailedException(Msg.code((int)972) + msg);
        }
        if (match.size() != 1) {
            String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidMatchUrlNoMatches", new Object[]{theConditionalUrl});
            throw new ResourceNotFoundException(Msg.code((int)973) + msg);
        }
        IResourcePersistentId pid = (IResourcePersistentId)match.iterator().next();
        IBasePersistedResource theEntityToUpdate = this.readEntityLatestVersion(pid, theRequestDetails, theTransactionDetails);
        return theEntityToUpdate;
    }

    @Override
    @Nonnull
    public abstract Class<T> getResourceType();

    @Override
    @Nonnull
    protected abstract String getResourceName();

    protected abstract IBasePersistedResource readEntityLatestVersion(IResourcePersistentId var1, RequestDetails var2, TransactionDetails var3);

    protected abstract IBasePersistedResource readEntityLatestVersion(IIdType var1, RequestDetails var2, TransactionDetails var3);

    protected DaoMethodOutcome doUpdateForUpdateOrPatch(UpdateParameters<T> theUpdateParameters) {
        if (theUpdateParameters.getResourceIdToUpdate().hasVersionIdPart() && Long.parseLong(theUpdateParameters.getResourceIdToUpdate().getVersionIdPart()) != theUpdateParameters.getEntity().getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)989) + "Trying to update " + String.valueOf(theUpdateParameters.getResourceIdToUpdate()) + " but this is not the current version");
        }
        if (theUpdateParameters.getResourceIdToUpdate().hasResourceType() && !theUpdateParameters.getResourceIdToUpdate().getResourceType().equals(this.getResourceName())) {
            throw new UnprocessableEntityException(Msg.code((int)990) + "Invalid resource ID[" + String.valueOf(theUpdateParameters.getEntity().getIdDt().toUnqualifiedVersionless()) + "] of type[" + theUpdateParameters.getEntity().getResourceType() + "] - Does not match expected [" + this.getResourceName() + "]");
        }
        IBaseResource oldResource = this.getStorageSettings().isMassIngestionMode() && !theUpdateParameters.shouldForcePopulateOldResourceForProcessing() ? null : this.getStorageResourceParser().toResource(theUpdateParameters.getEntity(), false);
        boolean wasDeleted = theUpdateParameters.getEntity().isDeleted();
        theUpdateParameters.getEntity().setNotDeleted();
        if (!theUpdateParameters.shouldPerformIndexing()) {
            theUpdateParameters.getResource().setId(theUpdateParameters.getEntity().getIdDt().getValue());
            DaoMethodOutcome outcome = this.toMethodOutcome(theUpdateParameters.getRequest(), theUpdateParameters.getEntity(), (IBaseResource)theUpdateParameters.getResource(), theUpdateParameters.getMatchUrl(), theUpdateParameters.getOperationType()).setCreated(wasDeleted);
            outcome.setPreviousResource(oldResource);
            if (!outcome.isNop()) {
                outcome.setId(outcome.getId().withVersion(Long.toString(outcome.getId().getVersionIdPartAsLong() + 1L)));
            }
            return outcome;
        }
        return this.updateInternal(theUpdateParameters.getRequest(), theUpdateParameters.getResource(), theUpdateParameters.getMatchUrl(), theUpdateParameters.shouldPerformIndexing(), theUpdateParameters.shouldForceUpdateVersion(), theUpdateParameters.getEntity(), theUpdateParameters.getResourceIdToUpdate(), oldResource, theUpdateParameters.getOperationType(), theUpdateParameters.getTransactionDetails());
    }

    public static void validateResourceType(IBasePersistedResource<?> theEntity, String theResourceName) {
        if (!theResourceName.equals(theEntity.getResourceType())) {
            throw new ResourceNotFoundException(Msg.code((int)935) + "Resource with ID " + theEntity.getIdDt().getIdPart() + " exists but it is not of type " + theResourceName + ", found resource of type " + theEntity.getResourceType());
        }
    }

    protected DeleteMethodOutcome deleteExpunge(String theUrl, RequestDetails theRequest) {
        if (!this.getStorageSettings().canDeleteExpunge()) {
            throw new MethodNotAllowedException(Msg.code((int)963) + "_expunge is not enabled on this server: " + this.getStorageSettings().cannotDeleteExpungeReason());
        }
        RestfulServerUtils.DeleteCascadeDetails cascadeDelete = RestfulServerUtils.extractDeleteCascadeParameter((RequestDetails)theRequest);
        boolean cascade = false;
        Integer cascadeMaxRounds = null;
        if (cascadeDelete.getMode() == DeleteCascadeModeEnum.DELETE) {
            cascade = true;
            cascadeMaxRounds = cascadeDelete.getMaxRounds();
            if (cascadeMaxRounds == null) {
                cascadeMaxRounds = this.myStorageSettings.getMaximumDeleteConflictQueryCount();
            } else if (this.myStorageSettings.getMaximumDeleteConflictQueryCount() != null && this.myStorageSettings.getMaximumDeleteConflictQueryCount() < cascadeMaxRounds) {
                cascadeMaxRounds = this.myStorageSettings.getMaximumDeleteConflictQueryCount();
            }
        }
        List<String> urlsToDeleteExpunge = Collections.singletonList(theUrl);
        try {
            String jobId = this.getDeleteExpungeJobSubmitter().submitJob(Integer.valueOf(this.getStorageSettings().getExpungeBatchSize()), urlsToDeleteExpunge, cascade, cascadeMaxRounds, theRequest);
            return new DeleteMethodOutcome(this.createInfoOperationOutcome("Delete job submitted with id " + jobId));
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(Msg.code((int)965) + "Invalid Delete Expunge Request: " + e.getMessage(), (Throwable)e);
        }
    }
}

