/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.model.search.SearchBuilderLoadIncludesParameters;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import com.google.common.collect.Streams;
import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManager;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ISearchBuilder<T extends IResourcePersistentId<?>> {
    public static final Logger ourLog = LoggerFactory.getLogger(ISearchBuilder.class);
    public static final String SEARCH_BUILDER_BEAN_NAME = "SearchBuilder";

    public IResultIterator<T> createQuery(SearchParameterMap var1, SearchRuntimeDetails var2, RequestDetails var3, @Nonnull RequestPartitionId var4);

    default public Stream<T> createQueryStream(SearchParameterMap theParams, SearchRuntimeDetails theSearchRuntime, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        IResultIterator iter = this.createQuery(theParams, theSearchRuntime, theRequest, theRequestPartitionId);
        Stream stream = Streams.stream(iter);
        return (Stream)stream.onClose(() -> IOUtils.closeQuietly((Closeable)iter));
    }

    public Long createCountQuery(SearchParameterMap var1, String var2, RequestDetails var3, RequestPartitionId var4);

    public void setMaxResultsToFetch(Integer var1);

    public void setDeduplicateInDatabase(boolean var1);

    public void setRequireTotal(boolean var1);

    public boolean requiresTotal();

    public void loadResourcesByPid(Collection<T> var1, Collection<T> var2, List<IBaseResource> var3, boolean var4, RequestDetails var5);

    default public List<IBaseResource> loadResourcesByPid(Collection<T> thePids, RequestDetails theDetails) {
        ArrayList<IBaseResource> result = new ArrayList<IBaseResource>();
        this.loadResourcesByPid(thePids, List.of(), result, false, theDetails);
        if (result.size() != thePids.size()) {
            ourLog.warn("Only found {} resources for {} pids", (Object)result.size(), (Object)thePids.size());
        }
        return result;
    }

    @Deprecated
    public Set<T> loadIncludes(FhirContext var1, EntityManager var2, Collection<T> var3, Collection<Include> var4, boolean var5, DateRangeParam var6, String var7, RequestDetails var8, Integer var9);

    default public Set<T> loadIncludes(SearchBuilderLoadIncludesParameters<T> theParameters) {
        return this.loadIncludes(theParameters.getFhirContext(), theParameters.getEntityManager(), theParameters.getMatches(), theParameters.getIncludeFilters(), theParameters.isReverseMode(), theParameters.getLastUpdated(), theParameters.getSearchIdOrDescription(), theParameters.getRequestDetails(), theParameters.getMaxCount());
    }

    public void setFetchSize(int var1);

    public void setPreviouslyAddedResourcePids(List<T> var1);
}

