/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.model.api.StorageResponseCodeEnum;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.MetaUtil;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class TransactionUtil {
    private TransactionUtil() {
    }

    public static TransactionResponse parseTransactionResponse(FhirContext theContext, IBaseBundle theTransactionRequestBundle, IBaseBundle theTransactionResponseBundle) {
        FhirTerser terser = theContext.newTerser();
        ArrayList<StorageOutcome> storageOutcomes = new ArrayList<StorageOutcome>();
        String bundleMetaSource = null;
        if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            bundleMetaSource = MetaUtil.getSource((FhirContext)theContext, (IBaseResource)theTransactionRequestBundle);
        }
        List requestEntries = terser.getValues((IBase)theTransactionRequestBundle, "entry");
        List responseEntries = terser.getValues((IBase)theTransactionResponseBundle, "entry");
        for (int i = 0; i < responseEntries.size(); ++i) {
            int statusSpaceIdx;
            IBase responseResponse;
            IBase requestEntry = (IBase)requestEntries.get(i);
            IBase responseEntry = (IBase)responseEntries.get(i);
            String requestVerb = terser.getSinglePrimitiveValueOrNull(requestEntry, "request.method");
            if ("GET".equals(requestVerb)) continue;
            IBaseResource requestResource = (IBaseResource)terser.getSingleValueOrNull(requestEntry, "resource", IBaseResource.class);
            String requestMetaSource = null;
            if (requestResource != null && theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
                requestMetaSource = MetaUtil.getSource((FhirContext)theContext, (IBaseResource)requestResource);
            }
            if (StringUtils.isBlank(requestMetaSource)) {
                requestMetaSource = bundleMetaSource;
            }
            String requestFullUrlString = terser.getSinglePrimitiveValueOrNull(requestEntry, "fullUrl");
            IIdType requestFullUrl = null;
            if (requestFullUrlString != null) {
                requestFullUrl = theContext.getVersion().newIdType(requestFullUrlString);
                requestFullUrl = TransactionUtil.toUnqualified(requestFullUrl);
            }
            if ((responseResponse = terser.getSingleValueOrNull(responseEntry, "response", IBase.class)) == null) continue;
            int statusCode = 0;
            String statusMessage = terser.getSinglePrimitiveValueOrNull(responseResponse, "status");
            if (statusMessage != null && (statusSpaceIdx = statusMessage.indexOf(32)) > 0) {
                statusCode = Integer.parseInt(statusMessage.substring(0, statusSpaceIdx));
            }
            List issues = Collections.emptyList();
            if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
                issues = terser.getValues(responseResponse, "outcome.issue");
            } else {
                IBaseResource responseResource = (IBaseResource)terser.getSingleValueOrNull(responseEntry, "resource", IBaseResource.class);
                if (responseResource instanceof IBaseOperationOutcome) {
                    issues = terser.getValues((IBase)responseResource, "issue");
                }
            }
            IIdType groupSourceId = null;
            for (int issueIndex = 0; issueIndex < issues.size(); ++issueIndex) {
                IIdType targetId;
                IValidationSupport.IssueSeverity issueSeverity;
                IBase issue = (IBase)issues.get(issueIndex);
                IIdType sourceId = requestFullUrl;
                String outcomeSystem = terser.getSinglePrimitiveValueOrNull(issue, "details.coding.system");
                StorageResponseCodeEnum responseCode = null;
                if ("https://hapifhir.io/fhir/CodeSystem/hapi-fhir-storage-response-code".equals(outcomeSystem)) {
                    String outcomeCode = terser.getSinglePrimitiveValueOrNull(issue, "details.coding.code");
                    responseCode = StorageResponseCodeEnum.valueOf((String)outcomeCode);
                }
                String errorMessage = null;
                String issueSeverityString = terser.getSinglePrimitiveValueOrNull(issue, "severity");
                if (StringUtils.isNotBlank((CharSequence)issueSeverityString) && (issueSeverity = IValidationSupport.IssueSeverity.fromCode((String)issueSeverityString)) != null && issueSeverity.ordinal() <= IValidationSupport.IssueSeverity.ERROR.ordinal()) {
                    errorMessage = terser.getSinglePrimitiveValueOrNull(issue, "diagnostics");
                }
                if (responseCode == null && statusCode >= 400 && statusCode <= 599) {
                    responseCode = StorageResponseCodeEnum.FAILURE;
                }
                if (responseCode == StorageResponseCodeEnum.AUTOMATICALLY_CREATED_PLACEHOLDER_RESOURCE) {
                    targetId = ((IBaseHasExtensions)issue).getExtension().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/oo-placeholder-id".equals(t.getUrl())).findFirst().map(t -> (IIdType)t.getValue()).orElse(null);
                    sourceId = groupSourceId;
                } else {
                    String responseLocation = terser.getSinglePrimitiveValueOrNull(responseEntry, "response.location");
                    if (StringUtils.isNotBlank((CharSequence)responseLocation)) {
                        targetId = theContext.getVersion().newIdType(responseLocation);
                        if (issueIndex == 0) {
                            groupSourceId = targetId;
                        }
                    } else {
                        targetId = null;
                    }
                }
                StorageOutcome outcome = new StorageOutcome(statusCode, statusMessage, responseCode, TransactionUtil.toUnqualified(sourceId), TransactionUtil.toUnqualified(targetId), errorMessage, requestMetaSource);
                storageOutcomes.add(outcome);
            }
        }
        return new TransactionResponse(storageOutcomes);
    }

    private static IIdType toUnqualified(@Nullable IIdType theId) {
        if (theId != null && theId.hasBaseUrl()) {
            return theId.toUnqualified();
        }
        return theId;
    }

    public static class StorageOutcome {
        private final StorageResponseCodeEnum myStorageResponseCode;
        private final IIdType myTargetId;
        private final IIdType mySourceId;
        private final int myStatusCode;
        private final String myErrorMessage;
        private final String myRequestMetaSource;
        private final String myStatusMessage;

        public StorageOutcome(int theStatusCode, String theStatusMessage, StorageResponseCodeEnum theStorageResponseCode, IIdType theSourceId, IIdType theTargetId, String theErrorMessage, String theRequestMetaSource) {
            this.myStatusCode = theStatusCode;
            this.myStatusMessage = theStatusMessage;
            this.myStorageResponseCode = theStorageResponseCode;
            this.myTargetId = theTargetId;
            this.mySourceId = theSourceId;
            this.myErrorMessage = theErrorMessage;
            this.myRequestMetaSource = theRequestMetaSource;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        public String getStatusMessage() {
            return this.myStatusMessage;
        }

        public StorageResponseCodeEnum getStorageResponseCode() {
            return this.myStorageResponseCode;
        }

        public IIdType getTargetId() {
            return this.myTargetId;
        }

        public IIdType getSourceId() {
            return this.mySourceId;
        }

        public String getRequestMetaSource() {
            return this.myRequestMetaSource;
        }
    }

    public static class TransactionResponse {
        private final List<StorageOutcome> myStorageOutcomes;

        public TransactionResponse(List<StorageOutcome> theStorageOutcomes) {
            this.myStorageOutcomes = theStorageOutcomes;
        }

        public List<StorageOutcome> getStorageOutcomes() {
            return this.myStorageOutcomes;
        }
    }
}

