/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.expunge.IResourceExpungeService;
import ca.uhn.fhir.jpa.dao.expunge.PartitionAwareSupplier;
import ca.uhn.fhir.jpa.dao.expunge.PartitionRunner;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.IResourceVersionPersistentId;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExpungeOperation<T extends IResourcePersistentId<?>, V extends IResourceVersionPersistentId>
implements Callable<ExpungeOutcome> {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeOperation.class);
    public static final String PROCESS_NAME = "Expunging";
    public static final String THREAD_PREFIX = "expunge";
    @Autowired
    private IResourceExpungeService<T, V> myResourceExpungeService;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    private final String myResourceName;
    private final T myResourceId;
    private final ExpungeOptions myExpungeOptions;
    private final RequestDetails myRequestDetails;
    private final AtomicInteger myRemainingCount;
    @Autowired
    private HapiTransactionService myTxService;

    public ExpungeOperation(String theResourceName, T theResourceId, ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        this.myResourceName = theResourceName;
        this.myResourceId = theResourceId;
        this.myExpungeOptions = theExpungeOptions;
        this.myRequestDetails = theRequestDetails;
        this.myRemainingCount = new AtomicInteger(this.myExpungeOptions.getLimit());
    }

    @Override
    public ExpungeOutcome call() {
        if (this.myExpungeOptions.isExpungeDeletedResources() && (this.myResourceId == null || this.myResourceId.getVersion() == null)) {
            this.expungeDeletedResources();
            if (this.expungeLimitReached()) {
                return this.expungeOutcome();
            }
        }
        if (this.myExpungeOptions.isExpungeOldVersions()) {
            this.expungeOldVersions();
            if (this.expungeLimitReached()) {
                return this.expungeOutcome();
            }
        }
        return this.expungeOutcome();
    }

    private void expungeDeletedResources() {
        List<T> resourceIds = this.findHistoricalVersionsOfDeletedResources();
        this.deleteHistoricalVersions(resourceIds);
        if (this.expungeLimitReached()) {
            return;
        }
        this.deleteCurrentVersionsOfDeletedResources(resourceIds);
    }

    private List<T> findHistoricalVersionsOfDeletedResources() {
        List retVal = this.getPartitionAwareSupplier().supplyInPartitionedContext(() -> this.myResourceExpungeService.findHistoricalVersionsOfDeletedResources(this.myResourceName, this.myResourceId, this.myRemainingCount.get()));
        ourLog.debug("Found {} historical versions", (Object)retVal.size());
        return retVal;
    }

    private boolean expungeLimitReached() {
        boolean expungeLimitReached;
        boolean bl = expungeLimitReached = this.myRemainingCount.get() <= 0;
        if (expungeLimitReached) {
            ourLog.debug("Expunge limit has been hit - Stopping operation");
        }
        return expungeLimitReached;
    }

    private void expungeOldVersions() {
        List historicalIds = this.getPartitionAwareSupplier().supplyInPartitionedContext(() -> this.myResourceExpungeService.findHistoricalVersionsOfNonDeletedResources(this.myResourceName, this.myResourceId, this.myRemainingCount.get()));
        this.getPartitionRunner().runInPartitionedThreads(historicalIds, partition -> this.myResourceExpungeService.expungeHistoricalVersions(this.myRequestDetails, (List<V>)partition, this.myRemainingCount));
    }

    private PartitionAwareSupplier getPartitionAwareSupplier() {
        return new PartitionAwareSupplier(this.myTxService, this.myRequestDetails);
    }

    private PartitionRunner getPartitionRunner() {
        return new PartitionRunner(PROCESS_NAME, THREAD_PREFIX, this.myStorageSettings.getExpungeBatchSize(), this.myStorageSettings.getExpungeThreadCount(), this.myTxService, this.myRequestDetails);
    }

    private void deleteCurrentVersionsOfDeletedResources(List<T> theResourceIds) {
        this.getPartitionRunner().runInPartitionedThreads(theResourceIds, partition -> this.myResourceExpungeService.expungeCurrentVersionOfResources(this.myRequestDetails, (List<T>)partition, this.myRemainingCount));
    }

    private void deleteHistoricalVersions(List<T> theResourceIds) {
        this.getPartitionRunner().runInPartitionedThreads(theResourceIds, partition -> this.myResourceExpungeService.expungeHistoricalVersionsOfIds(this.myRequestDetails, (List<T>)partition, this.myRemainingCount));
    }

    private ExpungeOutcome expungeOutcome() {
        return new ExpungeOutcome().setDeletedCount(this.myExpungeOptions.getLimit() - this.myRemainingCount.get());
    }

    @VisibleForTesting
    public void setHapiTransactionServiceForTesting(HapiTransactionService theHapiTransactionService) {
        this.myTxService = theHapiTransactionService;
    }

    @VisibleForTesting
    public void setStorageSettingsForTesting(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @VisibleForTesting
    public void setExpungeDaoServiceForTesting(IResourceExpungeService theIResourceExpungeService) {
        this.myResourceExpungeService = theIResourceExpungeService;
    }
}

