/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.ResolveIdentityMode;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.searchparam.extractor.IResourceLinkResolver;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetRequest;
import ca.uhn.fhir.storage.interceptor.AutoCreatePlaceholderReferenceTargetResponse;
import ca.uhn.fhir.util.CanonicalIdentifier;
import ca.uhn.fhir.util.TerserUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DaoResourceLinkResolver<T extends IResourcePersistentId<?>>
implements IResourceLinkResolver {
    private static final Logger ourLog = LoggerFactory.getLogger(DaoResourceLinkResolver.class);
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IIdHelperService<T> myIdHelperService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IHapiTransactionService myTransactionService;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public IResourceLookup findTargetResource(@Nonnull RequestPartitionId theRequestPartitionId, String theSourceResourceName, PathAndRef thePathAndRef, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IResourceLookup<T> resolvedResource;
        IResourcePersistentId resolvedResourceId;
        IBaseReference targetReference = thePathAndRef.getRef();
        String sourcePath = thePathAndRef.getPath();
        IIdType targetResourceId = targetReference.getReferenceElement();
        if (targetResourceId.isEmpty() && targetReference.getResource() != null) {
            targetResourceId = targetReference.getResource().getIdElement();
        }
        String resourceType = targetResourceId.getResourceType();
        RuntimeResourceDefinition resourceDef = this.myContext.getResourceDefinition(resourceType);
        Class type = resourceDef.getImplementingClass();
        Object persistentId = null;
        if (theTransactionDetails != null && (resolvedResourceId = theTransactionDetails.getResolvedResourceId(targetResourceId)) != null && resolvedResourceId.getId() != null && resolvedResourceId.getAssociatedResourceId() != null) {
            persistentId = resolvedResourceId;
        }
        String idPart = targetResourceId.getIdPart();
        try {
            if (persistentId == null) {
                if (theTransactionDetails != null && theTransactionDetails.hasNullResolvedResourceId(targetResourceId)) {
                    throw new ResourceNotFoundException(Msg.code((int)2602));
                }
                resolvedResource = this.myIdHelperService.resolveResourceIdentity(theRequestPartitionId, resourceType, idPart, ResolveIdentityMode.excludeDeleted().noCacheUnlessDeletesDisabled());
                ourLog.trace("Translated {}/{} to resource PID {}", new Object[]{type, idPart, resolvedResource});
            } else {
                resolvedResource = new IResourceLookup<T>(persistentId);
            }
        }
        catch (ResourceNotFoundException e) {
            Optional<IBasePersistedResource> createdTableOpt = this.createPlaceholderTargetIfConfiguredToDoSo(type, targetReference, idPart, theRequest, theTransactionDetails);
            if (!createdTableOpt.isPresent()) {
                if (!this.myStorageSettings.isEnforceReferentialIntegrityOnWrite()) {
                    return null;
                }
                RuntimeResourceDefinition missingResourceDef = this.myContext.getResourceDefinition(type);
                String resName = missingResourceDef.getName();
                try {
                    resolvedResource = this.myIdHelperService.resolveResourceIdentity(theRequestPartitionId, resourceType, idPart, ResolveIdentityMode.includeDeleted().noCacheUnlessDeletesDisabled());
                    this.handleDeletedTarget(resourceType, idPart, sourcePath);
                }
                catch (ResourceNotFoundException e2) {
                    resolvedResource = null;
                }
                if (resolvedResource == null) {
                    throw new InvalidRequestException(Msg.code((int)1094) + "Resource " + resName + "/" + idPart + " not found, specified in path: " + sourcePath);
                }
            }
            resolvedResource = (IResourceLookup<T>)createdTableOpt.get();
        }
        ourLog.trace("Resolved resource of type {} as PID: {}", (Object)resolvedResource.getResourceType(), (Object)resolvedResource.getPersistentId());
        if (!this.validateResolvedResourceOrThrow(resourceType, (IResourceLookup)resolvedResource, targetResourceId, idPart, sourcePath)) {
            return null;
        }
        if (persistentId == null) {
            Object id = resolvedResource.getPersistentId().getId();
            Integer partitionId = null;
            if (resolvedResource.getPartitionId() != null) {
                partitionId = resolvedResource.getPartitionId().getPartitionId();
            }
            persistentId = this.myIdHelperService.newPid(id, partitionId);
            persistentId.setAssociatedResourceId(targetResourceId);
            if (theTransactionDetails != null) {
                theTransactionDetails.addResolvedResourceId(targetResourceId, persistentId);
            }
        }
        return resolvedResource;
    }

    private boolean validateResolvedResourceOrThrow(String resourceType, IResourceLookup resolvedResource, IIdType targetResourceId, String idPart, String sourcePath) {
        if (!resourceType.equals(resolvedResource.getResourceType())) {
            ourLog.error("Resource with PID {} was of type {} and wanted {}", new Object[]{resolvedResource.getPersistentId(), resourceType, resolvedResource.getResourceType()});
            if (!this.myStorageSettings.isEnforceReferentialIntegrityOnWrite()) {
                return false;
            }
            throw new UnprocessableEntityException(Msg.code((int)1095) + "Resource contains reference to unknown resource ID " + targetResourceId.getValue());
        }
        if (resolvedResource.getDeleted() != null) {
            return this.handleDeletedTarget(resolvedResource.getResourceType(), idPart, sourcePath);
        }
        return true;
    }

    private boolean handleDeletedTarget(String resType, String idPart, String sourcePath) {
        if (!this.myStorageSettings.isEnforceReferentialIntegrityOnWrite()) {
            return false;
        }
        String resName = resType;
        throw new InvalidRequestException(Msg.code((int)1096) + "Resource " + resName + "/" + idPart + " is deleted, specified in path: " + sourcePath);
    }

    @Nullable
    public IBaseResource loadTargetResource(@Nonnull RequestPartitionId theRequestPartitionId, String theSourceResourceName, PathAndRef thePathAndRef, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        return this.myTransactionService.withRequest(theRequest).withTransactionDetails(theTransactionDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            IIdType targetId = thePathAndRef.getRef().getReferenceElement();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(targetId.getResourceType());
            return dao.read(targetId, theRequest);
        });
    }

    public <T extends IBaseResource> Optional<IBasePersistedResource> createPlaceholderTargetIfConfiguredToDoSo(Class<T> theType, IBaseReference theReference, @Nullable String theIdToAssignToPlaceholder, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IBasePersistedResource valueOf = null;
        if (this.myStorageSettings.isAutoCreatePlaceholderReferenceTargets()) {
            IInterceptorBroadcaster interceptorBroadcaster;
            RuntimeResourceDefinition missingResourceDef = this.myContext.getResourceDefinition(theType);
            String resName = missingResourceDef.getName();
            IBaseResource newResource = (IBaseResource)missingResourceDef.newInstance();
            this.tryToAddPlaceholderExtensionToResource(newResource);
            IFhirResourceDao<IBaseResource> placeholderResourceDao = this.myDaoRegistry.getResourceDao(theType);
            ourLog.debug("Automatically creating empty placeholder resource: {}", (Object)newResource.getIdElement().getValue());
            if (this.myStorageSettings.isPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets()) {
                this.tryToCopyIdentifierFromReferenceToTargetResource(theReference, missingResourceDef, newResource);
            }
            if (theIdToAssignToPlaceholder != null) {
                if (theTransactionDetails != null) {
                    String existingId = newResource.getIdElement().getValue();
                    theTransactionDetails.addRollbackUndoAction(() -> newResource.setId(existingId));
                }
                newResource.setId(resName + "/" + theIdToAssignToPlaceholder);
            }
            if ((interceptorBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)).hasHooks((IPointcut)Pointcut.STORAGE_PRE_AUTO_CREATE_PLACEHOLDER_REFERENCE)) {
                AutoCreatePlaceholderReferenceTargetRequest request = new AutoCreatePlaceholderReferenceTargetRequest(newResource);
                HookParams params = new HookParams().add(AutoCreatePlaceholderReferenceTargetRequest.class, (Object)request).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                AutoCreatePlaceholderReferenceTargetResponse response = (AutoCreatePlaceholderReferenceTargetResponse)interceptorBroadcaster.callHooksAndReturnObject((IPointcut)Pointcut.STORAGE_PRE_AUTO_CREATE_PLACEHOLDER_REFERENCE, params);
                if (response != null && response.isDoNotCreateTarget()) {
                    return Optional.empty();
                }
                if (theIdToAssignToPlaceholder != null) {
                    Validate.isTrue((boolean)theIdToAssignToPlaceholder.equals(newResource.getIdElement().getIdPart()), (String)"Interceptors must not modify the ID of auto-created placeholder reference targets", (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)newResource.getIdElement().getIdPart()), (String)"Interceptors must not modify the ID of auto-created placeholder reference targets", (Object[])new Object[0]);
                }
            }
            valueOf = theIdToAssignToPlaceholder != null ? placeholderResourceDao.update(newResource, null, true, false, theRequest, theTransactionDetails).getEntity() : placeholderResourceDao.create(newResource, theRequest).getEntity();
            Object persistentId = valueOf.getPersistentId();
            persistentId = this.myIdHelperService.newPid(persistentId.getId());
            persistentId.setAssociatedResourceId(valueOf.getIdDt());
            theTransactionDetails.addResolvedResourceId(persistentId.getAssociatedResourceId(), persistentId);
            theTransactionDetails.addAutoCreatedPlaceholderResource(newResource.getIdElement());
        }
        return Optional.ofNullable(valueOf);
    }

    private <T extends IBaseResource> void tryToAddPlaceholderExtensionToResource(T newResource) {
        if (newResource instanceof IBaseHasExtensions) {
            IBaseExtension extension = ((IBaseHasExtensions)newResource).addExtension();
            extension.setUrl("http://hapifhir.io/fhir/StructureDefinition/resource-placeholder");
            extension.setValue((IBaseDatatype)this.myContext.newPrimitiveBoolean(Boolean.valueOf(true)));
        }
    }

    private <T extends IBaseResource> void tryToCopyIdentifierFromReferenceToTargetResource(IBaseReference theSourceReference, RuntimeResourceDefinition theTargetResourceDef, T theTargetResource) {
        CanonicalIdentifier referenceMatchUrlIdentifier = this.extractIdentifierFromUrl(theSourceReference.getReferenceElement().getValue());
        CanonicalIdentifier referenceIdentifier = this.extractIdentifierReference(theSourceReference);
        if (referenceIdentifier == null && referenceMatchUrlIdentifier != null) {
            this.addMatchUrlIdentifierToTargetResource(theTargetResourceDef, theTargetResource, referenceMatchUrlIdentifier);
        } else if (referenceIdentifier != null && referenceMatchUrlIdentifier == null) {
            this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
        } else if (referenceIdentifier != null && referenceMatchUrlIdentifier != null) {
            if (referenceIdentifier.equals((Object)referenceMatchUrlIdentifier)) {
                this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
            } else {
                this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
                this.addMatchUrlIdentifierToTargetResource(theTargetResourceDef, theTargetResource, referenceMatchUrlIdentifier);
            }
        }
    }

    private <T extends IBaseResource> void addSubjectIdentifierToTargetResource(IBaseReference theSourceReference, RuntimeResourceDefinition theTargetResourceDef, T theTargetResource) {
        BaseRuntimeElementDefinition identifierElement;
        String identifierElementName;
        boolean targetHasIdentifierElement;
        BaseRuntimeChildDefinition targetIdentifier = theTargetResourceDef.getChildByName("identifier");
        if (targetIdentifier != null && (targetHasIdentifierElement = (identifierElementName = (identifierElement = targetIdentifier.getChildByName("identifier")).getName()).equals("Identifier"))) {
            BaseRuntimeElementCompositeDefinition referenceElement = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSourceReference.getClass());
            BaseRuntimeChildDefinition referenceIdentifierChild = referenceElement.getChildByName("identifier");
            Optional identifierOpt = referenceIdentifierChild.getAccessor().getFirstValueOrNull((IBase)theSourceReference);
            identifierOpt.ifPresent(theIBase -> targetIdentifier.getMutator().addValue((IBase)theTargetResource, theIBase));
        }
    }

    private <T extends IBaseResource> void addMatchUrlIdentifierToTargetResource(RuntimeResourceDefinition theTargetResourceDef, T theTargetResource, CanonicalIdentifier referenceMatchUrlIdentifier) {
        BaseRuntimeChildDefinition identifierDefinition = theTargetResourceDef.getChildByName("identifier");
        IBase identifierIBase = identifierDefinition.getChildByName("identifier").newInstance(identifierDefinition.getInstanceConstructorArguments());
        IBase systemIBase = TerserUtil.newElement((FhirContext)this.myContext, (String)"uri", (Object)referenceMatchUrlIdentifier.getSystemElement().getValueAsString());
        IBase valueIBase = TerserUtil.newElement((FhirContext)this.myContext, (String)"string", (Object)referenceMatchUrlIdentifier.getValueElement().getValueAsString());
        BaseRuntimeElementDefinition elementDefinition = this.myContext.getElementDefinition(identifierIBase.getClass());
        BaseRuntimeChildDefinition systemDefinition = elementDefinition.getChildByName("system");
        systemDefinition.getMutator().setValue(identifierIBase, systemIBase);
        BaseRuntimeChildDefinition valueDefinition = elementDefinition.getChildByName("value");
        valueDefinition.getMutator().setValue(identifierIBase, valueIBase);
        identifierDefinition.getMutator().addValue(theTargetResource, identifierIBase);
    }

    private CanonicalIdentifier extractIdentifierReference(IBaseReference theSourceReference) {
        Optional identifier = this.myContext.newFhirPath().evaluateFirst((IBase)theSourceReference, "identifier", IBase.class);
        if (!identifier.isPresent()) {
            return null;
        }
        CanonicalIdentifier canonicalIdentifier = new CanonicalIdentifier();
        Optional system = this.myContext.newFhirPath().evaluateFirst((IBase)identifier.get(), "system", IPrimitiveType.class);
        Optional value = this.myContext.newFhirPath().evaluateFirst((IBase)identifier.get(), "value", IPrimitiveType.class);
        system.ifPresent(theIPrimitiveType -> canonicalIdentifier.setSystem(theIPrimitiveType.getValueAsString()));
        value.ifPresent(theIPrimitiveType -> canonicalIdentifier.setValue(theIPrimitiveType.getValueAsString()));
        return canonicalIdentifier;
    }

    protected CanonicalIdentifier extractIdentifierFromUrl(String theValue) {
        int identifierIndex = theValue.indexOf("identifier=");
        if (identifierIndex == -1) {
            return null;
        }
        List params = URLEncodedUtils.parse((String)theValue.substring(identifierIndex), (Charset)StandardCharsets.UTF_8, (char[])new char[]{'&', ';'});
        Optional<NameValuePair> idOptional = params.stream().filter(p -> p.getName().equals("identifier")).findFirst();
        if (!idOptional.isPresent()) {
            return null;
        }
        NameValuePair id = idOptional.get();
        String identifierString = id.getValue();
        String[] split = identifierString.split("\\|");
        if (split.length != 2) {
            throw new IllegalArgumentException(Msg.code((int)1097) + "Can't create a placeholder reference with identifier " + theValue + ". It is not a valid identifier");
        }
        CanonicalIdentifier identifier = new CanonicalIdentifier();
        identifier.setSystem(split[0]);
        identifier.setValue(split[1]);
        return identifier;
    }

    public void validateTypeOrThrowException(Class<? extends IBaseResource> theType) {
        this.myDaoRegistry.getDaoOrThrow(theType);
    }

    private static class ResourceLookupPersistentIdWrapper<P extends IResourcePersistentId>
    implements IResourceLookup {
        private final P myPersistentId;

        public ResourceLookupPersistentIdWrapper(P thePersistentId) {
            this.myPersistentId = thePersistentId;
        }

        public String getResourceType() {
            return this.myPersistentId.getAssociatedResourceId().getResourceType();
        }

        public String getFhirId() {
            return this.myPersistentId.getAssociatedResourceId().getIdPart();
        }

        public Date getDeleted() {
            return null;
        }

        public P getPersistentId() {
            return this.myPersistentId;
        }

        public PartitionablePartitionId getPartitionId() {
            return new PartitionablePartitionId(this.myPersistentId.getPartitionId(), null);
        }
    }
}

