/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.graphql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberOrListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityOrListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialOrListParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.hl7.fhir.utilities.graphql.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DaoRegistryGraphQLStorageServices
implements IGraphQLStorageServices {
    static final String SEARCH_ID_PARAM = "search-id";
    static final String SEARCH_OFFSET_PARAM = "search-offset";
    private static final int MAX_SEARCH_SIZE = 500;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    protected ISearchCoordinatorSvc mySearchCoordinatorSvc;
    @Autowired
    private IRequestPartitionHelperSvc myPartitionHelperSvc;
    @Autowired
    private IPagingProvider myPagingProvider;

    private IFhirResourceDao<? extends IBaseResource> getDao(String theResourceType) {
        RuntimeResourceDefinition typeDef = this.myContext.getResourceDefinition(theResourceType);
        return this.myDaoRegistry.getResourceDaoOrNull(typeDef.getImplementingClass());
    }

    private String graphqlArgumentToSearchParam(String name) {
        if (name.startsWith("_")) {
            return name;
        }
        return name.replaceAll("_", "-");
    }

    private String searchParamToGraphqlArgument(String name) {
        return name.replaceAll("-", "_");
    }

    private SearchParameterMap buildSearchParams(String theType, List<Argument> theSearchParams) {
        List resourceSearchParam = theSearchParams.stream().filter(it -> !"_count".equals(it.getName())).collect(Collectors.toList());
        FhirContext fhirContext = this.myContext;
        RuntimeResourceDefinition typeDef = fhirContext.getResourceDefinition(theType);
        SearchParameterMap params = new SearchParameterMap();
        ResourceSearchParams searchParams = this.mySearchParamRegistry.getRuntimeSearchParams(typeDef.getName(), ISearchParamRegistry.SearchParamLookupContextEnum.SEARCH);
        for (Argument nextArgument : resourceSearchParam) {
            if (nextArgument.getName().equals("_filter")) {
                String value = ((Value)nextArgument.getValues().get(0)).getValue();
                params.add("_filter", (IQueryParameterType)new StringParam(value));
                continue;
            }
            String searchParamName = this.graphqlArgumentToSearchParam(nextArgument.getName());
            RuntimeSearchParam searchParam = searchParams.get(searchParamName);
            if (searchParam == null) {
                Set graphqlArguments = searchParams.getSearchParamNames().stream().map(this::searchParamToGraphqlArgument).collect(Collectors.toSet());
                String msg = this.myContext.getLocalizer().getMessageSanitized(DaoRegistryGraphQLStorageServices.class, "invalidGraphqlArgument", new Object[]{nextArgument.getName(), new TreeSet(graphqlArguments)});
                throw new InvalidRequestException(Msg.code((int)1275) + msg);
            }
            params.add(searchParamName, (IQueryParameterOr)(switch (searchParam.getParamType()) {
                case RestSearchParameterTypeEnum.NUMBER -> {
                    NumberOrListParam numberOrListParam = new NumberOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        numberOrListParam.addOr(new NumberParam(value.getValue()));
                    }
                    yield numberOrListParam;
                }
                case RestSearchParameterTypeEnum.DATE -> {
                    Value value;
                    DateOrListParam dateOrListParam = new DateOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value = (Value)value.next();
                        dateOrListParam.addOr(new DateParam(value.getValue()));
                    }
                    yield dateOrListParam;
                }
                case RestSearchParameterTypeEnum.STRING -> {
                    StringOrListParam stringOrListParam = new StringOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        stringOrListParam.addOr(new StringParam(value.getValue()));
                    }
                    yield stringOrListParam;
                }
                case RestSearchParameterTypeEnum.TOKEN -> {
                    Value value;
                    TokenOrListParam tokenOrListParam = new TokenOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value = (Value)value.next();
                        TokenParam tokenParam = new TokenParam();
                        tokenParam.setValueAsQueryToken(fhirContext, searchParamName, null, value.getValue());
                        tokenOrListParam.addOr(tokenParam);
                    }
                    yield tokenOrListParam;
                }
                case RestSearchParameterTypeEnum.REFERENCE -> {
                    ReferenceOrListParam referenceOrListParam = new ReferenceOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        referenceOrListParam.addOr(new ReferenceParam(value.getValue()));
                    }
                    yield referenceOrListParam;
                }
                case RestSearchParameterTypeEnum.QUANTITY -> {
                    Value value;
                    QuantityOrListParam quantityOrListParam = new QuantityOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value = (Value)value.next();
                        quantityOrListParam.addOr(new QuantityParam(value.getValue()));
                    }
                    yield quantityOrListParam;
                }
                case RestSearchParameterTypeEnum.SPECIAL -> {
                    SpecialOrListParam specialOrListParam = new SpecialOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        specialOrListParam.addOr(new SpecialParam().setValue(value.getValue()));
                    }
                    yield specialOrListParam;
                }
                default -> throw new InvalidRequestException(Msg.code((int)1276) + String.format("%s parameters are not yet supported in GraphQL", searchParam.getParamType()));
            }));
        }
        return params;
    }

    @Transactional(propagation=Propagation.NEVER)
    public void listResources(Object theAppInfo, String theType, List<Argument> theSearchParams, List<IBaseResource> theMatches) throws FHIRException {
        SearchParameterMap params = this.buildSearchParams(theType, theSearchParams);
        params.setLoadSynchronousUpTo(Integer.valueOf(500));
        RequestDetails requestDetails = (RequestDetails)theAppInfo;
        IBundleProvider response = this.getDao(theType).search(params, requestDetails);
        Integer size = response.size();
        if (response.preferredPageSize() != null && size != null && response.preferredPageSize() < size || size == null) {
            size = response.preferredPageSize();
        }
        Validate.notNull((Object)size, (String)"size is null", (Object[])new Object[0]);
        theMatches.addAll(response.getResources(0, size.intValue()));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public IBaseResource lookup(Object theAppInfo, String theType, String theId) throws FHIRException {
        IIdType refId = this.myContext.getVersion().newIdType();
        refId.setValue(theType + "/" + theId);
        return this.lookup(theAppInfo, refId);
    }

    private IBaseResource lookup(Object theAppInfo, IIdType theRefId) {
        IFhirResourceDao<? extends IBaseResource> dao = this.getDao(theRefId.getResourceType());
        RequestDetails requestDetails = (RequestDetails)theAppInfo;
        return dao.read(theRefId, requestDetails, false);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public IGraphQLStorageServices.ReferenceResolution lookup(Object theAppInfo, IBaseResource theContext, IBaseReference theReference) throws FHIRException {
        IBaseResource outcome = this.lookup(theAppInfo, theReference.getReferenceElement());
        if (outcome == null) {
            return null;
        }
        return new IGraphQLStorageServices.ReferenceResolution(theContext, outcome);
    }

    private Optional<String> getArgument(List<Argument> params, String name) {
        return params.stream().filter(it -> name.equals(it.getName())).map(it -> ((Value)it.getValues().get(0)).getValue()).findAny();
    }

    @Transactional(propagation=Propagation.NEVER)
    public IBaseBundle search(Object theAppInfo, String theType, List<Argument> theSearchParams) throws FHIRException {
        int pageSize;
        IBundleProvider response;
        int searchOffset;
        String searchId;
        RequestDetails requestDetails = (RequestDetails)theAppInfo;
        Optional<String> searchIdArgument = this.getArgument(theSearchParams, SEARCH_ID_PARAM);
        Optional<String> searchOffsetArgument = this.getArgument(theSearchParams, SEARCH_OFFSET_PARAM);
        if (searchIdArgument.isPresent() && searchOffsetArgument.isPresent()) {
            searchId = searchIdArgument.get();
            searchOffset = Integer.parseInt(searchOffsetArgument.get());
            response = Optional.ofNullable(this.myPagingProvider.retrieveResultList(requestDetails, searchId)).orElseThrow(() -> {
                String msg = this.myContext.getLocalizer().getMessageSanitized(DaoRegistryGraphQLStorageServices.class, "invalidGraphqlCursorArgument", new Object[]{searchId});
                return new InvalidRequestException(Msg.code((int)2076) + msg);
            });
            pageSize = Optional.ofNullable(response.preferredPageSize()).orElseGet(() -> ((IPagingProvider)this.myPagingProvider).getDefaultPageSize());
        } else {
            pageSize = this.getArgument(theSearchParams, "_count").map(Integer::parseInt).orElseGet(() -> ((IPagingProvider)this.myPagingProvider).getDefaultPageSize());
            SearchParameterMap params = this.buildSearchParams(theType, theSearchParams);
            params.setCount(Integer.valueOf(pageSize));
            CacheControlDirective cacheControlDirective = new CacheControlDirective();
            cacheControlDirective.parse(requestDetails.getHeaders("Cache-Control"));
            RequestPartitionId requestPartitionId = this.myPartitionHelperSvc.determineReadPartitionForRequestForSearchType(requestDetails, theType, params);
            response = this.mySearchCoordinatorSvc.registerSearch(this.getDao(theType), params, theType, cacheControlDirective, requestDetails, requestPartitionId);
            searchOffset = 0;
            searchId = this.myPagingProvider.storeResultList(requestDetails, response);
        }
        String serverBase = requestDetails.getFhirServerBase();
        Optional<Integer> numTotalResults = Optional.ofNullable(response.size());
        int numToReturn = numTotalResults.map(integer -> Math.min(pageSize, integer - searchOffset)).orElse(pageSize);
        BundleLinks links = new BundleLinks(requestDetails.getServerBaseForRequest(), null, RestfulServerUtils.prettyPrintResponse((IRestfulServerDefaults)requestDetails.getServer(), (RequestDetails)requestDetails), BundleTypeEnum.SEARCHSET);
        String linkFormat = "%s/%s?_format=application/json&search-id=%s&search-offset=%d&_count=%d";
        String linkSelf = String.format(linkFormat, serverBase, theType, searchId, searchOffset, pageSize);
        links.setSelf(linkSelf);
        boolean hasNext = numTotalResults.map(total -> searchOffset + numToReturn < total).orElse(true);
        if (hasNext) {
            String linkNext = String.format(linkFormat, serverBase, theType, searchId, searchOffset + numToReturn, pageSize);
            links.setNext(linkNext);
        }
        if (searchOffset > 0) {
            String linkPrev = String.format(linkFormat, serverBase, theType, searchId, Math.max(0, searchOffset - pageSize), pageSize);
            links.setPrev(linkPrev);
        }
        List resourceList = response.getResources(searchOffset, numToReturn + searchOffset);
        IVersionSpecificBundleFactory bundleFactory = this.myContext.newBundleFactory();
        bundleFactory.addRootPropertiesToBundle(response.getUuid(), links, response.size(), response.getPublished());
        bundleFactory.addResourcesToBundle(resourceList, BundleTypeEnum.SEARCHSET, serverBase, null, null);
        IBaseResource result = bundleFactory.getResourceBundle();
        return (IBaseBundle)result;
    }
}

