/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.util.ResourceCompartmentUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StopWatch;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class PatientCompartmentEnforcingInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(PatientCompartmentEnforcingInterceptor.class);
    private final FhirContext myFhirContext;
    private final ISearchParamExtractor mySearchParamExtractor;

    public PatientCompartmentEnforcingInterceptor(FhirContext theFhirContext, ISearchParamExtractor theSearchParamExtractor) {
        this.myFhirContext = theFhirContext;
        this.mySearchParamExtractor = theSearchParamExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void storagePreStorageResourceUpdated(IBaseResource theOldResource, IBaseResource theResource) {
        ourLog.info("Interceptor STORAGE_PRESTORAGE_RESOURCE_UPDATED - started");
        StopWatch stopWatch = new StopWatch();
        try {
            String patientCompartmentOld = ResourceCompartmentUtil.getPatientCompartmentIdentity(theOldResource, this.myFhirContext, this.mySearchParamExtractor).orElse("");
            String patientCompartmentCurrent = ResourceCompartmentUtil.getPatientCompartmentIdentity(theResource, this.myFhirContext, this.mySearchParamExtractor).orElse("");
            if (!StringUtils.equals((CharSequence)patientCompartmentOld, (CharSequence)patientCompartmentCurrent)) {
                throw new InternalErrorException(Msg.code((int)2476) + "Resource compartment changed. Was a referenced Patient changed?");
            }
        }
        finally {
            ourLog.info("Interceptor STORAGE_PRESTORAGE_RESOURCE_UPDATED - ended, execution took {}", (Object)stopWatch);
        }
    }
}

