/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.IDefaultPartitionSettings;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.messaging.RequestPartitionHeaderUtil;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class RequestHeaderPartitionInterceptor {
    private final IDefaultPartitionSettings myDefaultPartitionSettings;

    public RequestHeaderPartitionInterceptor(IDefaultPartitionSettings theDefaultPartitionSettings) {
        this.myDefaultPartitionSettings = theDefaultPartitionSettings;
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId identifyPartitionForCreate(RequestDetails theRequestDetails) {
        return this.identifyPartitionOrThrowException(theRequestDetails, RequestPartitionHeaderUtil::fromHeaderFirstPartitionOnly);
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId identifyPartitionForRead(RequestDetails theRequestDetails) {
        return this.identifyPartitionOrThrowException(theRequestDetails, RequestPartitionHeaderUtil::fromHeader);
    }

    private RequestPartitionId identifyPartitionOrThrowException(RequestDetails theRequestDetails, BiFunction<String, IDefaultPartitionSettings, RequestPartitionId> aHeaderParser) {
        String partitionHeader = theRequestDetails.getHeader("X-Request-Partition-IDs");
        if (StringUtils.isBlank((CharSequence)partitionHeader)) {
            if (theRequestDetails instanceof SystemRequestDetails) {
                SystemRequestDetails systemRequestDetails = (SystemRequestDetails)theRequestDetails;
                if (systemRequestDetails.getRequestPartitionId() != null) {
                    return systemRequestDetails.getRequestPartitionId();
                }
                return this.myDefaultPartitionSettings.getDefaultRequestPartitionId();
            }
            throw new InvalidRequestException(Msg.code((int)2642) + String.format("%s header is missing or blank, it is required to identify the storage partition", "X-Request-Partition-IDs"));
        }
        return aHeaderParser.apply(partitionHeader, this.myDefaultPartitionSettings);
    }
}

