/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRequestPartitionHelperSvc
implements IRequestPartitionHelperSvc {
    public static final Logger ourLog = Logs.getPartitionTroubleshootingLog();
    private final HashSet<Object> myNonPartitionableResourceNames = new HashSet();
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    PartitionSettings myPartitionSettings;

    protected BaseRequestPartitionHelperSvc() {
        this.myNonPartitionableResourceNames.add("SearchParameter");
        this.myNonPartitionableResourceNames.add("StructureDefinition");
        this.myNonPartitionableResourceNames.add("Questionnaire");
        this.myNonPartitionableResourceNames.add("CapabilityStatement");
        this.myNonPartitionableResourceNames.add("CompartmentDefinition");
        this.myNonPartitionableResourceNames.add("OperationDefinition");
        this.myNonPartitionableResourceNames.add("Library");
        this.myNonPartitionableResourceNames.add("ConceptMap");
        this.myNonPartitionableResourceNames.add("CodeSystem");
        this.myNonPartitionableResourceNames.add("ValueSet");
        this.myNonPartitionableResourceNames.add("NamingSystem");
        this.myNonPartitionableResourceNames.add("StructureMap");
    }

    @Autowired
    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @Nonnull
    public RequestPartitionId determineReadPartitionForRequest(@Nullable RequestDetails theRequest, @Nonnull ReadPartitionIdRequestDetails theDetails) {
        if (!this.myPartitionSettings.isPartitioningEnabled()) {
            return RequestPartitionId.allPartitions();
        }
        String resourceType = theDetails.getResourceType();
        RequestDetails requestDetails = theRequest;
        if (requestDetails == null) {
            requestDetails = new SystemRequestDetails();
            BaseRequestPartitionHelperSvc.logSubstitutingDefaultSystemRequestDetails();
        }
        boolean nonPartitionableResource = this.isResourceNonPartitionable(resourceType);
        RequestPartitionId requestPartitionId = null;
        if (requestDetails instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)requestDetails) && !nonPartitionableResource) {
            requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)requestDetails, false);
            this.logSystemRequestDetailsResolution((SystemRequestDetails)requestDetails);
        } else if (requestDetails instanceof SystemRequestDetails && nonPartitionableResource) {
            requestPartitionId = this.myPartitionSettings.getDefaultRequestPartitionId();
            this.logSystemRequestDetailsResolution((SystemRequestDetails)requestDetails);
            BaseRequestPartitionHelperSvc.logNonPartitionableType(resourceType);
        } else {
            IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails);
            if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY)) {
                requestPartitionId = BaseRequestPartitionHelperSvc.callAnyPointcut(compositeBroadcaster, requestDetails);
            } else if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_READ)) {
                requestPartitionId = BaseRequestPartitionHelperSvc.callReadPointcut(compositeBroadcaster, requestDetails, theDetails);
            }
        }
        BaseRequestPartitionHelperSvc.validateRequestPartitionNotNull(requestPartitionId, Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, Pointcut.STORAGE_PARTITION_IDENTIFY_READ);
        RequestPartitionId resultRequestPartitionId = this.validateAndNormalizePartition(requestPartitionId, requestDetails, resourceType);
        BaseRequestPartitionHelperSvc.logTroubleshootingResult("read", resourceType, theRequest, resultRequestPartitionId);
        return resultRequestPartitionId;
    }

    private static RequestPartitionId callAnyPointcut(IInterceptorBroadcaster compositeBroadcaster, RequestDetails requestDetails) {
        HookParams params = new HookParams().add(RequestDetails.class, (Object)requestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)requestDetails);
        return BaseRequestPartitionHelperSvc.callAndLog(compositeBroadcaster, Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, params);
    }

    private static RequestPartitionId callCreatePointcut(IInterceptorBroadcaster compositeBroadcaster, RequestDetails requestDetails, @Nonnull IBaseResource theResource) {
        HookParams params = new HookParams().add(IBaseResource.class, (Object)theResource).add(RequestDetails.class, (Object)requestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)requestDetails);
        return BaseRequestPartitionHelperSvc.callAndLog(compositeBroadcaster, Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE, params);
    }

    private static RequestPartitionId callAndLog(IInterceptorBroadcaster compositeBroadcaster, Pointcut pointcut, HookParams params) {
        RequestPartitionId result = (RequestPartitionId)compositeBroadcaster.callHooksAndReturnObject((IPointcut)pointcut, params);
        if (ourLog.isTraceEnabled()) {
            ourLog.trace("{}: result={} hooks={}", new Object[]{pointcut, result, compositeBroadcaster.getInvokersForPointcut((IPointcut)pointcut)});
        }
        return result;
    }

    private static RequestPartitionId callReadPointcut(IInterceptorBroadcaster compositeBroadcaster, RequestDetails requestDetails, @Nonnull ReadPartitionIdRequestDetails theDetails) {
        HookParams params = new HookParams().add(RequestDetails.class, (Object)requestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)requestDetails).add(ReadPartitionIdRequestDetails.class, (Object)theDetails);
        return BaseRequestPartitionHelperSvc.callAndLog(compositeBroadcaster, Pointcut.STORAGE_PARTITION_IDENTIFY_READ, params);
    }

    private static void logNonPartitionableType(String theResourceType) {
        ourLog.trace("Partitioning: resource type {} must be on the DEFAULT partition.", (Object)theResourceType);
    }

    public RequestPartitionId determineGenericPartitionForRequest(RequestDetails theRequestDetails) {
        RequestPartitionId requestPartitionId = null;
        if (!this.myPartitionSettings.isPartitioningEnabled()) {
            return RequestPartitionId.allPartitions();
        }
        if (theRequestDetails instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)theRequestDetails)) {
            requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)theRequestDetails);
            this.logSystemRequestDetailsResolution((SystemRequestDetails)theRequestDetails);
        } else {
            IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails);
            if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY)) {
                requestPartitionId = BaseRequestPartitionHelperSvc.callAnyPointcut(compositeBroadcaster, theRequestDetails);
            }
        }
        if (requestPartitionId != null) {
            requestPartitionId = this.validateAndNormalizePartition(requestPartitionId, theRequestDetails, theRequestDetails.getResourceName());
        }
        BaseRequestPartitionHelperSvc.logTroubleshootingResult("generic", theRequestDetails.getResourceName(), theRequestDetails, requestPartitionId);
        return requestPartitionId;
    }

    private RequestPartitionId getSystemRequestPartitionId(SystemRequestDetails theRequest, boolean theNonPartitionableResource) {
        RequestPartitionId requestPartitionId = this.getSystemRequestPartitionId(theRequest);
        if (theNonPartitionableResource && !requestPartitionId.isPartition(this.myPartitionSettings.getDefaultPartitionId())) {
            throw new InternalErrorException(Msg.code((int)1315) + "System call is attempting to write a non-partitionable resource to a partition! This is a bug!");
        }
        return requestPartitionId;
    }

    @Nonnull
    private RequestPartitionId getSystemRequestPartitionId(@Nonnull SystemRequestDetails theRequest) {
        if (theRequest.getRequestPartitionId() != null) {
            return theRequest.getRequestPartitionId();
        }
        if (theRequest.getTenantId() != null) {
            return RequestPartitionId.fromPartitionName((String)theRequest.getTenantId());
        }
        return RequestPartitionId.defaultPartition();
    }

    @Nonnull
    public RequestPartitionId determineCreatePartitionForRequest(@Nullable RequestDetails theRequest, @Nonnull IBaseResource theResource, @Nonnull String theResourceType) {
        if (!this.myPartitionSettings.isPartitioningEnabled()) {
            return RequestPartitionId.allPartitions();
        }
        RequestDetails requestDetails = theRequest;
        boolean nonPartitionableResource = this.isResourceNonPartitionable(theResourceType);
        if (theRequest == null) {
            requestDetails = new SystemRequestDetails();
            BaseRequestPartitionHelperSvc.logSubstitutingDefaultSystemRequestDetails();
        }
        RequestPartitionId requestPartitionId = null;
        if (theRequest instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)theRequest)) {
            requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)theRequest, nonPartitionableResource);
            this.logSystemRequestDetailsResolution((SystemRequestDetails)theRequest);
        } else {
            IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails);
            if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY)) {
                requestPartitionId = BaseRequestPartitionHelperSvc.callAnyPointcut(compositeBroadcaster, requestDetails);
            } else if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)) {
                requestPartitionId = BaseRequestPartitionHelperSvc.callCreatePointcut(compositeBroadcaster, requestDetails, theResource);
            }
        }
        if (nonPartitionableResource && requestPartitionId == null) {
            BaseRequestPartitionHelperSvc.logNonPartitionableType(theResourceType);
            requestPartitionId = this.myPartitionSettings.getDefaultRequestPartitionId();
        }
        BaseRequestPartitionHelperSvc.validateRequestPartitionNotNull(requestPartitionId, Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE, Pointcut.STORAGE_PARTITION_IDENTIFY_ANY);
        this.validatePartitionForCreate(requestPartitionId, theResourceType);
        RequestPartitionId resultRequestPartitionId = this.validateAndNormalizePartition(requestPartitionId, requestDetails, theResourceType);
        BaseRequestPartitionHelperSvc.logTroubleshootingResult("create", theResourceType, theRequest, resultRequestPartitionId);
        return resultRequestPartitionId;
    }

    private boolean systemRequestHasExplicitPartition(@Nonnull SystemRequestDetails theRequest) {
        return theRequest.getRequestPartitionId() != null || theRequest.getTenantId() != null;
    }

    @Nonnull
    public Set<Integer> toReadPartitions(@Nonnull RequestPartitionId theRequestPartitionId) {
        return theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toSet());
    }

    @Nonnull
    private RequestPartitionId validateAndNormalizePartition(@Nonnull RequestPartitionId theRequestPartitionId, RequestDetails theRequest, @Nullable String theResourceType) {
        RequestPartitionId retVal = theRequestPartitionId;
        if (!this.myPartitionSettings.isUnnamedPartitionMode()) {
            if (retVal.getPartitionNames() != null) {
                retVal = this.validateAndNormalizePartitionNames(retVal);
            } else if (retVal.hasPartitionIds()) {
                retVal = this.validateAndNormalizePartitionIds(retVal);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
            this.validateHasPartitionPermissions(theRequest, theResourceType, retVal);
        }
        if (this.myPartitionSettings.getDefaultPartitionId() != null && retVal.hasPartitionIds() && retVal.hasDefaultPartitionId(null)) {
            ArrayList<Integer> partitionIds = new ArrayList<Integer>(retVal.getPartitionIds());
            for (int i = 0; i < partitionIds.size(); ++i) {
                if (partitionIds.get(i) != null) continue;
                partitionIds.set(i, this.myPartitionSettings.getDefaultPartitionId());
            }
            retVal = RequestPartitionId.fromPartitionIds(partitionIds);
        }
        ourLog.trace("Partition normalization: {} -> {}", (Object)theRequestPartitionId, (Object)retVal);
        return retVal;
    }

    public void validateHasPartitionPermissions(@Nonnull RequestDetails theRequest, String theResourceType, RequestPartitionId theRequestPartitionId) {
        IInterceptorBroadcaster compositeBroadcaster = CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest);
        if (compositeBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_SELECTED)) {
            RuntimeResourceDefinition runtimeResourceDefinition = null;
            if (theResourceType != null) {
                runtimeResourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
            }
            HookParams params = new HookParams().add(RequestPartitionId.class, (Object)theRequestPartitionId).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(RuntimeResourceDefinition.class, (Object)runtimeResourceDefinition);
            compositeBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PARTITION_SELECTED, params);
        }
    }

    public boolean isResourcePartitionable(String theResourceType) {
        return theResourceType != null && !this.myNonPartitionableResourceNames.contains(theResourceType);
    }

    @Nullable
    public Integer getDefaultPartitionId() {
        return this.myPartitionSettings.getDefaultPartitionId();
    }

    private boolean isResourceNonPartitionable(String theResourceType) {
        return theResourceType != null && !this.isResourcePartitionable(theResourceType);
    }

    private void validatePartitionForCreate(RequestPartitionId theRequestPartitionId, String theResourceName) {
        if (theRequestPartitionId.hasPartitionIds()) {
            BaseRequestPartitionHelperSvc.validateSinglePartitionIdOrName(theRequestPartitionId.getPartitionIds());
        }
        BaseRequestPartitionHelperSvc.validateSinglePartitionIdOrName(theRequestPartitionId.getPartitionNames());
        if (this.isDefaultPartition(theRequestPartitionId) || theRequestPartitionId.isAllPartitions()) {
            return;
        }
        if ((theRequestPartitionId.hasPartitionIds() && !theRequestPartitionId.getPartitionIds().contains(null) || theRequestPartitionId.hasPartitionNames() && !theRequestPartitionId.getPartitionNames().contains("DEFAULT")) && this.isResourceNonPartitionable(theResourceName)) {
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseRequestPartitionHelperSvc.class, "nonDefaultPartitionSelectedForNonPartitionable", new Object[]{theResourceName});
            throw new UnprocessableEntityException(Msg.code((int)1318) + msg);
        }
    }

    private static void validateRequestPartitionNotNull(RequestPartitionId theRequestPartitionId, Pointcut ... thePointcuts) {
        if (theRequestPartitionId == null) {
            throw new InternalErrorException(Msg.code((int)1319) + "No interceptor provided a value for pointcuts: " + Arrays.toString(thePointcuts));
        }
    }

    private static void validateSinglePartitionIdOrName(@Nullable List<?> thePartitionIds) {
        if (thePartitionIds != null && thePartitionIds.size() != 1) {
            throw new InternalErrorException(Msg.code((int)1320) + "RequestPartitionId must contain a single partition for create operations, found: " + String.valueOf(thePartitionIds));
        }
    }

    private static void logTroubleshootingResult(String theAction, String theResourceType, @Nullable RequestDetails theRequest, RequestPartitionId theResult) {
        String tenantId = theRequest != null ? theRequest.getTenantId() : null;
        ourLog.debug("Partitioning: action={} resource type={} with request tenant ID={} routed to RequestPartitionId={}", new Object[]{theAction, theResourceType, tenantId, theResult});
    }

    private void logSystemRequestDetailsResolution(SystemRequestDetails theRequest) {
        ourLog.trace("Partitioning: request is a SystemRequestDetails, with RequestPartitionId={}.", (Object)theRequest.getRequestPartitionId());
    }

    private static void logSubstitutingDefaultSystemRequestDetails() {
        ourLog.trace("No RequestDetails present.  Using default SystemRequestDetails.");
    }
}

