/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.patch.ChildDefinition;
import ca.uhn.fhir.jpa.patch.FhirPathChildDefinition;
import ca.uhn.fhir.jpa.patch.ParsedFhirPath;
import ca.uhn.fhir.jpa.patch.ParsedPath;
import ca.uhn.fhir.jpa.util.FhirPathUtils;
import ca.uhn.fhir.parser.path.EncodeContextPath;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirPatch {
    Logger ourLog = LoggerFactory.getLogger(FhirPatch.class);
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_DELETE = "delete";
    public static final String OPERATION_INSERT = "insert";
    public static final String OPERATION_MOVE = "move";
    public static final String OPERATION_REPLACE = "replace";
    public static final String PARAMETER_DESTINATION = "destination";
    public static final String PARAMETER_INDEX = "index";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_OPERATION = "operation";
    public static final String PARAMETER_PATH = "path";
    public static final String PARAMETER_SOURCE = "source";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_VALUE = "value";
    private final FhirContext myContext;
    private boolean myIncludePreviousValueInDiff;
    private Set<EncodeContextPath> myIgnorePaths = Collections.emptySet();

    public FhirPatch(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addIgnorePath(String theIgnorePath) {
        Validate.notBlank((CharSequence)theIgnorePath, (String)"theIgnorePath must not be null or empty", (Object[])new Object[0]);
        if (this.myIgnorePaths.isEmpty()) {
            this.myIgnorePaths = new HashSet<EncodeContextPath>();
        }
        this.myIgnorePaths.add(new EncodeContextPath(theIgnorePath));
    }

    public void setIncludePreviousValueInDiff(boolean theIncludePreviousValueInDiff) {
        this.myIncludePreviousValueInDiff = theIncludePreviousValueInDiff;
    }

    public void apply(IBaseResource theResource, IBaseResource thePatch) {
        List opParameters = ParametersUtil.getNamedParameters((FhirContext)this.myContext, (IBaseResource)thePatch, (String)PARAMETER_OPERATION);
        for (IBase nextOperation : opParameters) {
            String type = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)nextOperation, (String)PARAMETER_TYPE);
            if (OPERATION_DELETE.equals(type = StringUtils.defaultString((String)type))) {
                this.handleDeleteOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_ADD.equals(type)) {
                this.handleAddOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_REPLACE.equals(type)) {
                this.handleReplaceOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_INSERT.equals(type)) {
                this.handleInsertOperation(theResource, nextOperation);
                continue;
            }
            if (OPERATION_MOVE.equals(type)) {
                this.handleMoveOperation(theResource, nextOperation);
                continue;
            }
            throw new InvalidRequestException(Msg.code((int)1267) + "Unknown patch operation type: " + type);
        }
    }

    private void handleAddOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        String elementName = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_NAME);
        String containingPath = StringUtils.defaultString((String)path);
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            IBase newValue = this.getNewValue(theParameters, childDefinition);
            childDefinition.getUseableChildDef().getMutator().addValue(nextElement, newValue);
        }
    }

    private void handleInsertOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        int lastDot = path.lastIndexOf(".");
        String containingPath = path.substring(0, lastDot);
        String elementName = path.substring(lastDot + 1);
        Integer insertIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_INDEX).orElseThrow(() -> new InvalidRequestException("No index supplied for insert operation"));
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            IBase newValue = this.getNewValue(theParameters, childDefinition);
            ArrayList<IBase> existingValues = new ArrayList<IBase>(childDefinition.getUseableChildDef().getAccessor().getValues(nextElement));
            if (insertIndex == null || insertIndex < 0 || insertIndex > existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidInsertIndex", new Object[]{insertIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1270) + msg);
            }
            existingValues.add(insertIndex, newValue);
            childDefinition.getUseableChildDef().getMutator().setValue(nextElement, null);
            for (IBase nextNewValue : existingValues) {
                childDefinition.getUseableChildDef().getMutator().addValue(nextElement, nextNewValue);
            }
        }
    }

    private void handleDeleteOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        ParsedPath parsedPath = ParsedPath.parse(path);
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, parsedPath.getEndsWithAFilterOrIndex() ? parsedPath.getContainingPath() : path, IBase.class);
        for (IBase nextElement : containingElements) {
            if (parsedPath.getEndsWithAFilterOrIndex()) {
                this.deleteFromList(theResource, nextElement, parsedPath.getLastElementName(), path);
                continue;
            }
            this.deleteSingleElement(nextElement);
        }
    }

    private void deleteFromList(IBaseResource theResource, IBase theContainingElement, String theListElementName, String theElementToDeletePath) {
        ChildDefinition childDefinition = this.findChildDefinition(theContainingElement, theListElementName);
        ArrayList existingValues = new ArrayList(childDefinition.getUseableChildDef().getAccessor().getValues(theContainingElement));
        List elementsToRemove = this.myContext.newFhirPath().evaluate((IBase)theResource, theElementToDeletePath, IBase.class);
        existingValues.removeAll(elementsToRemove);
        childDefinition.getUseableChildDef().getMutator().setValue(theContainingElement, null);
        for (IBase nextNewValue : existingValues) {
            childDefinition.getUseableChildDef().getMutator().addValue(theContainingElement, nextNewValue);
        }
    }

    private void handleReplaceOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        IFhirPath fhirPath = this.myContext.newFhirPath();
        try {
            IFhirPath.IParsedExpression iParsedExpression = fhirPath.parse(path);
        }
        catch (Exception theE) {
            throw new IllegalArgumentException(Msg.code((int)2726) + String.format(" %s is not a valid fhir path", path), theE);
        }
        ParsedFhirPath parsedFhirPath = ParsedFhirPath.parse(path);
        FhirPathChildDefinition parentDef = new FhirPathChildDefinition();
        ArrayList<ParsedFhirPath.FhirPathNode> pathNodes = new ArrayList<ParsedFhirPath.FhirPathNode>();
        parsedFhirPath.getAllNodesWithPred(pathNodes, ParsedFhirPath.FhirPathNode::isNormalPathNode);
        ArrayList<String> parts = new ArrayList<String>();
        for (ParsedFhirPath.FhirPathNode node : pathNodes) {
            parts.add(node.getValue());
        }
        FhirPathChildDefinition cd = this.childDefinition(parentDef, parts, (IBase)theResource, fhirPath, parsedFhirPath, path);
        this.replaceValuesByPath(cd, theParameters, fhirPath, parsedFhirPath);
    }

    private void replaceValuesByPath(FhirPathChildDefinition theChildDefinition, IBase theParameters, IFhirPath theFhirPath, ParsedFhirPath theParsedFhirPath) {
        Optional singleValuePart = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        if (singleValuePart.isPresent()) {
            IBase replacementValue = (IBase)singleValuePart.get();
            FhirPathChildDefinition childDefinitionToUse = this.findChildDefinitionByReplacementType(theChildDefinition, replacementValue);
            this.replaceSingleValue(theFhirPath, theParsedFhirPath, childDefinitionToUse, replacementValue);
            return;
        }
        Optional valueParts = ParametersUtil.getParameterPart((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        if (valueParts.isPresent()) {
            List partParts = valueParts.map(this::extractPartsFromPart).orElse(Collections.emptyList());
            for (IBase nextValuePartPart : partParts) {
                Optional optionalValue;
                String name = this.myContext.newTerser().getSingleValue(nextValuePartPart, PARAMETER_NAME, IPrimitiveType.class).map(IPrimitiveType::getValueAsString).orElse(null);
                if (StringUtils.isBlank((CharSequence)name) || !(optionalValue = this.myContext.newTerser().getSingleValue(nextValuePartPart, "value[x]", IBase.class)).isPresent()) continue;
                FhirPathChildDefinition childDefinitionToUse = this.findChildDefinitionAtEndOfPath(theChildDefinition, nextValuePartPart);
                BaseRuntimeChildDefinition subChild = childDefinitionToUse.getElementDefinition().getChildByName(name);
                subChild.getMutator().setValue(childDefinitionToUse.getBase(), (IBase)optionalValue.get());
            }
            return;
        }
        throw new InvalidRequestException(Msg.code((int)2720) + " No valid replacement value for patch operation.");
    }

    private FhirPathChildDefinition findChildDefinitionByReplacementType(FhirPathChildDefinition theChildDefinition, IBase replacementValue) {
        boolean isPrimitive = replacementValue instanceof IPrimitiveType;
        Predicate<FhirPathChildDefinition> predicate = def -> {
            if (isPrimitive) {
                return def.getBase() instanceof IPrimitiveType;
            }
            return def.getBase().fhirType().equalsIgnoreCase(replacementValue.fhirType());
        };
        return this.findChildDefinition(theChildDefinition, predicate);
    }

    private FhirPathChildDefinition findChildDefinitionAtEndOfPath(FhirPathChildDefinition theChildDefinition, IBase replacementValue) {
        return this.findChildDefinition(theChildDefinition, (FhirPathChildDefinition childDefinition) -> childDefinition.getChild() == null);
    }

    private FhirPathChildDefinition findChildDefinition(FhirPathChildDefinition theChildDefinition, Predicate<FhirPathChildDefinition> thePredicate) {
        for (FhirPathChildDefinition childDefinitionToUse = theChildDefinition; childDefinitionToUse != null; childDefinitionToUse = childDefinitionToUse.getChild()) {
            if (!thePredicate.test(childDefinitionToUse)) continue;
            return childDefinitionToUse;
        }
        throw new InvalidRequestException(Msg.code((int)2719) + " No runtime definition found for patch operation.");
    }

    private void replaceSingleValue(IFhirPath theFhirPath, ParsedFhirPath theParsedFhirPath, FhirPathChildDefinition theTargetChildDefinition, IBase theReplacementValue) {
        if (theTargetChildDefinition.getElementDefinition().getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE) {
            IBase iBase = theTargetChildDefinition.getBase();
            if (iBase instanceof IPrimitiveType) {
                IPrimitiveType target = (IPrimitiveType)iBase;
                if (theReplacementValue instanceof IPrimitiveType) {
                    IPrimitiveType source = (IPrimitiveType)theReplacementValue;
                    if (target.fhirType().equalsIgnoreCase(source.fhirType())) {
                        if (theTargetChildDefinition.getParent().getBase().fhirType().equalsIgnoreCase("narrative") && theTargetChildDefinition.getFhirPath().equalsIgnoreCase("div")) {
                            FhirPathChildDefinition narrativeDefinition = theTargetChildDefinition.getParent();
                            BaseRuntimeElementDefinition<?> narrativeElement = narrativeDefinition.getElementDefinition();
                            BaseRuntimeElementDefinition newXhtmlEl = this.myContext.getElementDefinition("xhtml");
                            IPrimitiveType xhtmlType = theTargetChildDefinition.getBaseRuntimeDefinition().getInstanceConstructorArguments() != null ? (IPrimitiveType)newXhtmlEl.newInstance(theTargetChildDefinition.getBaseRuntimeDefinition().getInstanceConstructorArguments()) : (IPrimitiveType)newXhtmlEl.newInstance();
                            xhtmlType.setValueAsString(source.getValueAsString());
                            narrativeElement.getChildByName(theTargetChildDefinition.getFhirPath()).getMutator().setValue(narrativeDefinition.getBase(), (IBase)xhtmlType);
                        } else {
                            target.setValueAsString(source.getValueAsString());
                        }
                    } else if (theTargetChildDefinition.getChild() != null) {
                        FhirPathChildDefinition ct = this.findChildDefinitionAtEndOfPath(theTargetChildDefinition, theReplacementValue);
                        this.replaceSingleValue(theFhirPath, theParsedFhirPath, ct, theReplacementValue);
                    } else {
                        String childFhirPath;
                        if (theTargetChildDefinition.getBaseRuntimeDefinition() != null && !theTargetChildDefinition.getBaseRuntimeDefinition().isMultipleCardinality()) {
                            target.setValueAsString(source.getValueAsString());
                            return;
                        }
                        BaseRuntimeElementDefinition<?> parentEl = theTargetChildDefinition.getParent().getElementDefinition();
                        BaseRuntimeChildDefinition choiceTarget = parentEl.getChildByName(childFhirPath = theTargetChildDefinition.getFhirPath());
                        if (choiceTarget == null) {
                            choiceTarget = parentEl.getChildByName(childFhirPath + "[x]");
                        }
                        choiceTarget.getMutator().setValue(theTargetChildDefinition.getParent().getBase(), theReplacementValue);
                    }
                }
            }
            return;
        }
        IBase containingElement = theTargetChildDefinition.getParent().getBase();
        BaseRuntimeChildDefinition runtimeDef = theTargetChildDefinition.getBaseRuntimeDefinition();
        if (runtimeDef == null) {
            runtimeDef = theTargetChildDefinition.getParent().getBaseRuntimeDefinition();
        }
        if (runtimeDef.isMultipleCardinality()) {
            List<IBase> replaceables;
            ArrayList<IBase> existing = new ArrayList<IBase>(runtimeDef.getAccessor().getValues(containingElement));
            if (existing.isEmpty()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "noMatchingElementForPath", new Object[]{theParsedFhirPath.getRawPath()});
                throw new InvalidRequestException(Msg.code((int)2617) + msg);
            }
            if (FhirPathUtils.isSubsettingNode(theParsedFhirPath.getTail())) {
                replaceables = this.applySubsettingFilter(theParsedFhirPath, theParsedFhirPath.getTail(), existing);
            } else if (existing.size() == 1) {
                replaceables = existing;
            } else {
                String finalNode;
                String raw = theParsedFhirPath.getRawPath();
                String subpath = raw.substring(raw.indexOf(finalNode = theParsedFhirPath.getLastElementName()));
                if (subpath.startsWith(finalNode) && subpath.length() > finalNode.length()) {
                    subpath = subpath.substring(finalNode.length() + 1);
                }
                AtomicReference<String> subpathRef = new AtomicReference<String>();
                subpathRef.set(subpath);
                replaceables = existing.stream().filter(item -> {
                    Optional matched = theFhirPath.evaluateFirst(item, (String)subpathRef.get(), IBase.class);
                    return matched.isPresent();
                }).toList();
            }
            if (replaceables.size() != 1) {
                throw new InvalidRequestException(Msg.code((int)2715) + " Expected to find a single element, but provided FhirPath returned " + replaceables.size() + " elements.");
            }
            IBase valueToReplace = replaceables.get(0);
            BaseRuntimeChildDefinition.IMutator listMutator = runtimeDef.getMutator();
            listMutator.setValue(containingElement, null);
            for (IBase existingValue : existing) {
                if (valueToReplace.equals(existingValue)) {
                    listMutator.addValue(containingElement, theReplacementValue);
                    continue;
                }
                listMutator.addValue(containingElement, existingValue);
            }
        } else {
            runtimeDef.getMutator().setValue(containingElement, theReplacementValue);
        }
    }

    private List<IBase> applySubsettingFilter(ParsedFhirPath theParsed, ParsedFhirPath.FhirPathNode tail, List<IBase> filtered) {
        if (tail.getListIndex() >= 0) {
            if (tail.getListIndex() < filtered.size()) {
                return List.of(filtered.get(tail.getListIndex()));
            }
            this.ourLog.info("Nothing matching index {}; nothing patched.", (Object)tail.getListIndex());
            return List.of();
        }
        if (filtered.isEmpty()) {
            this.ourLog.info("List contains no elements; no patching will occur");
            return List.of();
        }
        switch (tail.getValue()) {
            case "first": {
                return List.of(filtered.get(0));
            }
            case "last": {
                return List.of(filtered.get(filtered.size() - 1));
            }
            case "tail": {
                if (filtered.size() == 1) {
                    this.ourLog.info("List contains only a single element - no patching will occur");
                    return List.of();
                }
                return filtered.subList(1, filtered.size());
            }
            case "single": {
                if (filtered.size() != 1) {
                    throw new InvalidRequestException(Msg.code((int)2710) + " List contains more than a single element.");
                }
                return filtered;
            }
            case "skip": 
            case "take": {
                if (tail instanceof ParsedFhirPath.FhirPathFunction) {
                    ParsedFhirPath.FhirPathFunction fn = (ParsedFhirPath.FhirPathFunction)tail;
                    String containedNum = fn.getContainedExp().getHead().getValue();
                    try {
                        int num = Integer.parseInt(containedNum);
                        if (tail.getValue().equals("skip")) {
                            if (num < filtered.size()) {
                                return filtered.subList(num, filtered.size());
                            }
                        } else if (tail.getValue().equals("take")) {
                            if (num < filtered.size()) {
                                return filtered.subList(0, num);
                            }
                            return filtered;
                        }
                        return List.of();
                    }
                    catch (NumberFormatException ex) {
                        this.ourLog.error("{} is not a number", (Object)containedNum, (Object)ex);
                    }
                }
                throw new InvalidRequestException(Msg.code((int)2712) + " Invalid fhir path element encountered: " + theParsed.getRawPath());
            }
        }
        throw new InvalidRequestException(Msg.code((int)2711) + " Unrecognized filter of type " + tail.getValue());
    }

    private void throwNoElementsError(String theFullReplacePath) {
        String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "noMatchingElementForPath", new Object[]{theFullReplacePath});
        throw new InvalidRequestException(Msg.code((int)2617) + msg);
    }

    private void handleMoveOperation(IBaseResource theResource, IBase theParameters) {
        String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_PATH);
        path = StringUtils.defaultString((String)path);
        int lastDot = path.lastIndexOf(".");
        String containingPath = path.substring(0, lastDot);
        String elementName = path.substring(lastDot + 1);
        Integer insertIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_DESTINATION).orElseThrow(() -> new InvalidRequestException("No index supplied for move operation"));
        Integer removeIndex = (Integer)ParametersUtil.getParameterPartValueAsInteger((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_SOURCE).orElseThrow(() -> new InvalidRequestException("No index supplied for move operation"));
        List containingElements = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
        for (IBase nextElement : containingElements) {
            ChildDefinition childDefinition = this.findChildDefinition(nextElement, elementName);
            ArrayList<IBase> existingValues = new ArrayList<IBase>(childDefinition.getUseableChildDef().getAccessor().getValues(nextElement));
            if (removeIndex == null || removeIndex < 0 || removeIndex >= existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveSourceIndex", new Object[]{removeIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1268) + msg);
            }
            IBase newValue = (IBase)existingValues.remove(removeIndex);
            if (insertIndex == null || insertIndex < 0 || insertIndex > existingValues.size()) {
                String msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveDestinationIndex", new Object[]{insertIndex, path, existingValues.size()});
                throw new InvalidRequestException(Msg.code((int)1269) + msg);
            }
            existingValues.add(insertIndex, newValue);
            childDefinition.getUseableChildDef().getMutator().setValue(nextElement, null);
            for (IBase nextNewValue : existingValues) {
                childDefinition.getUseableChildDef().getMutator().addValue(nextElement, nextNewValue);
            }
        }
    }

    private FhirPathChildDefinition childDefinition(FhirPathChildDefinition theParent, List<String> theFhirPathParts, IBase theBase, IFhirPath theFhirPath, ParsedFhirPath theParsedFhirPath, String theOriginalPath) {
        String rawPath;
        FhirPathChildDefinition definition = new FhirPathChildDefinition();
        definition.setBase(theBase);
        BaseRuntimeElementDefinition parentElementDefinition = this.myContext.getElementDefinition(theBase.getClass());
        definition.setElementDefinition(parentElementDefinition);
        String head = theParsedFhirPath.getHead().getValue();
        definition.setFhirPath(head);
        if (theParent.getElementDefinition() != null) {
            definition.setBaseRuntimeDefinition(theParent.getElementDefinition().getChildByName(head));
        }
        if ((rawPath = theParsedFhirPath.getRawPath()).equalsIgnoreCase(head)) {
            return definition;
        }
        String headVal = theFhirPathParts.remove(0);
        String pathBeneathParent = rawPath.substring(headVal.length());
        if (StringUtils.isNotBlank((CharSequence)(pathBeneathParent = FhirPathUtils.cleansePath(pathBeneathParent))) && !theFhirPathParts.isEmpty()) {
            List<IBase> childs;
            ParsedFhirPath.FhirPathFunction fn;
            Stack<ParsedFhirPath.FhirPathNode> filteringNodes = new Stack<ParsedFhirPath.FhirPathNode>();
            String childFilteringPath = pathBeneathParent;
            String nextPath = pathBeneathParent;
            if (FhirPathUtils.isSubsettingNode(theParsedFhirPath.getTail())) {
                ParsedFhirPath.FhirPathNode filteringNode = theParsedFhirPath.getTail();
                filteringNodes.push(filteringNode);
                int endInd = pathBeneathParent.indexOf(filteringNode.getValue());
                if (endInd == -1) {
                    endInd = pathBeneathParent.length();
                }
                childFilteringPath = pathBeneathParent.substring(0, endInd);
                nextPath = childFilteringPath = FhirPathUtils.cleansePath(childFilteringPath);
            }
            String directChildName = theFhirPathParts.get(0);
            ParsedFhirPath newPath = ParsedFhirPath.parse(nextPath);
            ParsedFhirPath.FhirPathNode fhirPathNode = newPath.getHead();
            if (fhirPathNode instanceof ParsedFhirPath.FhirPathFunction && (fn = (ParsedFhirPath.FhirPathFunction)fhirPathNode).hasContainedExp()) {
                newPath = fn.getContainedExp();
                childFilteringPath = newPath.getRawPath();
            }
            ParsedFhirPath.FhirPathNode newHead = newPath.getHead();
            List<IBase> allChildren = theFhirPath.evaluate(theBase, directChildName, IBase.class);
            String filterPath = childFilteringPath;
            if (filterPath.startsWith(newHead.getValue()) && !filterPath.equalsIgnoreCase(newHead.getValue())) {
                filterPath = filterPath.substring(newHead.getValue().length());
                filterPath = FhirPathUtils.cleansePath(filterPath);
                if (newPath.getHead().getNext() != null && FhirPathUtils.isSubsettingNode(newPath.getHead().getNext())) {
                    ParsedFhirPath.FhirPathNode filterNode = newPath.getHead().getNext();
                    filteringNodes.push(filterNode);
                    String newRaw = newPath.getRawPath();
                    Object updated = "";
                    if (filterNode.hasNext()) {
                        updated = newRaw.substring(newRaw.indexOf(filterNode.getNext().getValue()));
                        updated = FhirPathUtils.cleansePath((String)updated);
                    }
                    filterPath = updated;
                    updated = newPath.getHead().getValue() + "." + (String)updated;
                    newPath = ParsedFhirPath.parse((String)updated);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)filterPath)) {
                if (theFhirPathParts.contains(filterPath)) {
                    childs = allChildren;
                } else {
                    AtomicReference<String> ref = new AtomicReference<String>();
                    ref.set(filterPath);
                    childs = allChildren.size() > 1 ? allChildren.stream().filter(el -> {
                        Optional match = theFhirPath.evaluateFirst(el, (String)ref.get(), IBase.class);
                        return match.isPresent();
                    }).toList() : allChildren.stream().filter(el -> {
                        Optional match = theFhirPath.evaluateFirst(el, (String)ref.get(), IBase.class);
                        return match.isPresent();
                    }).findFirst().stream().toList();
                }
            } else {
                childs = allChildren;
            }
            while (!filteringNodes.empty()) {
                ParsedFhirPath.FhirPathNode filteringNode = (ParsedFhirPath.FhirPathNode)filteringNodes.pop();
                childs = this.applySubsettingFilter(newPath, filteringNode, childs);
            }
            if (childs.size() != 1) {
                if (childs.isEmpty()) {
                    this.throwNoElementsError(theOriginalPath);
                }
                throw new InvalidRequestException(Msg.code((int)2704) + " FhirPath returns more than 1 element. Patch cannot be done. " + theOriginalPath);
            }
            IBase child = (IBase)childs.get(0);
            definition.setChild(this.childDefinition(definition, theFhirPathParts, child, theFhirPath, newPath, theOriginalPath));
        }
        return definition;
    }

    private ChildDefinition findChildDefinition(IBase theContainingElement, String theElementName) {
        BaseRuntimeElementDefinition childElement;
        Object childName;
        BaseRuntimeElementDefinition elementDef = this.myContext.getElementDefinition(theContainingElement.getClass());
        BaseRuntimeChildDefinition childDef = elementDef.getChildByName((String)(childName = theElementName));
        if (childDef == null) {
            childName = theElementName + "[x]";
            childDef = elementDef.getChildByName((String)childName);
            childElement = childDef.getChildByName((String)childDef.getValidChildNames().iterator().next());
        } else {
            childElement = childDef.getChildByName((String)childName);
        }
        return new ChildDefinition(childDef, childElement);
    }

    private IBase getNewValue(IBase theParameters, ChildDefinition theChildDefinition) {
        IBase newValue;
        Optional valuePart = ParametersUtil.getParameterPart((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        Optional valuePartValue = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)theParameters, (String)PARAMETER_VALUE);
        if (valuePartValue.isPresent()) {
            newValue = this.maybeMassageToEnumeration((IBase)valuePartValue.get(), theChildDefinition);
        } else {
            List<IBase> partParts = valuePart.map(this::extractPartsFromPart).orElse(Collections.emptyList());
            newValue = this.createAndPopulateNewElement(theChildDefinition, partParts);
        }
        return newValue;
    }

    private IBase maybeMassageToEnumeration(IBase theValue, ChildDefinition theChildDefinition) {
        IBase retVal = theValue;
        if (IBaseEnumeration.class.isAssignableFrom(theChildDefinition.getChildElement().getImplementingClass()) || XhtmlNode.class.isAssignableFrom(theChildDefinition.getChildElement().getImplementingClass())) {
            IPrimitiveType newValueInstance = theChildDefinition.getUseableChildDef().getInstanceConstructorArguments() != null ? (IPrimitiveType)theChildDefinition.getChildElement().newInstance(theChildDefinition.getUseableChildDef().getInstanceConstructorArguments()) : (IPrimitiveType)theChildDefinition.getChildElement().newInstance();
            newValueInstance.setValueAsString(((IPrimitiveType)theValue).getValueAsString());
            retVal = newValueInstance;
        }
        return retVal;
    }

    @Nonnull
    private List<IBase> extractPartsFromPart(IBase theParametersParameterComponent) {
        return this.myContext.newTerser().getValues(theParametersParameterComponent, "part");
    }

    private IBase createAndPopulateNewElement(ChildDefinition theDefinition, List<IBase> thePartParts) {
        IBase newElement = theDefinition.getChildElement().newInstance();
        for (IBase nextValuePartPart : thePartParts) {
            Object name = this.myContext.newTerser().getSingleValue(nextValuePartPart, PARAMETER_NAME, IPrimitiveType.class).map(IPrimitiveType::getValueAsString).orElse(null);
            if (StringUtils.isBlank((CharSequence)name)) continue;
            Optional optionalValue = this.myContext.newTerser().getSingleValue(nextValuePartPart, "value[x]", IBase.class);
            if (optionalValue.isPresent()) {
                ChildDefinition childDefinition = this.findChildDefinition(newElement, (String)name);
                IBase newValue = this.maybeMassageToEnumeration((IBase)optionalValue.get(), childDefinition);
                BaseRuntimeChildDefinition partChildDef = theDefinition.getUsableChildElement().getChildByName((String)name);
                if (Objects.isNull(partChildDef)) {
                    name = (String)name + "[x]";
                    partChildDef = theDefinition.getUsableChildElement().getChildByName((String)name);
                }
                partChildDef.getMutator().setValue(newElement, newValue);
                continue;
            }
            List<IBase> part = this.extractPartsFromPart(nextValuePartPart);
            if (part.isEmpty()) continue;
            ChildDefinition childDefinition = this.findChildDefinition(newElement, (String)name);
            IBase childNewValue = this.createAndPopulateNewElement(childDefinition, part);
            childDefinition.getUseableChildDef().getMutator().setValue(newElement, childNewValue);
        }
        return newElement;
    }

    private void deleteSingleElement(IBase theElementToDelete) {
        this.myContext.newTerser().visit(theElementToDelete, new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IPrimitiveType) {
                    ((IPrimitiveType)theElement).setValueAsString(null);
                }
                return true;
            }
        });
    }

    public IBaseParameters diff(@Nullable IBaseResource theOldValue, @Nonnull IBaseResource theNewValue) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myContext);
        String newValueTypeName = this.myContext.getResourceDefinition(theNewValue).getName();
        if (theOldValue == null) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)retVal, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_INSERT);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)newValueTypeName);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_VALUE, (IBase)theNewValue);
        } else {
            String oldValueTypeName = this.myContext.getResourceDefinition(theOldValue).getName();
            Validate.isTrue((boolean)oldValueTypeName.equalsIgnoreCase(newValueTypeName), (String)"Resources must be of same type", (Object[])new Object[0]);
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theOldValue).getBaseDefinition();
            String path = def.getName();
            EncodeContextPath contextPath = new EncodeContextPath();
            contextPath.pushPath(path, true);
            this.compare(retVal, contextPath, (BaseRuntimeElementDefinition<?>)def, path, path, (IBase)theOldValue, (IBase)theNewValue);
            contextPath.popPath();
            assert (contextPath.getPath().isEmpty());
        }
        return retVal;
    }

    private void compare(IBaseParameters theDiff, EncodeContextPath theSourceEncodeContext, BaseRuntimeElementDefinition<?> theDef, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField) {
        boolean pathIsIgnored = this.pathIsIgnored(theSourceEncodeContext);
        if (pathIsIgnored) {
            return;
        }
        BaseRuntimeElementDefinition sourceDef = this.myContext.getElementDefinition(theOldField.getClass());
        BaseRuntimeElementDefinition targetDef = this.myContext.getElementDefinition(theNewField.getClass());
        if (!sourceDef.getName().equals(targetDef.getName())) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_REPLACE);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)theTargetPath);
            this.addValueToDiff(operation, theOldField, theNewField);
        } else {
            if (theOldField instanceof IPrimitiveType) {
                String newValueAsString;
                IPrimitiveType oldPrimitive = (IPrimitiveType)theOldField;
                IPrimitiveType newPrimitive = (IPrimitiveType)theNewField;
                String oldValueAsString = this.toValue(oldPrimitive);
                if (!Objects.equals(oldValueAsString, newValueAsString = this.toValue(newPrimitive))) {
                    IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
                    ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_REPLACE);
                    ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)theTargetPath);
                    this.addValueToDiff(operation, (IBase)oldPrimitive, (IBase)newPrimitive);
                }
            }
            List children = theDef.getChildren();
            for (BaseRuntimeChildDefinition nextChild : children) {
                this.compareField(theDiff, theSourceEncodeContext, theSourcePath, theTargetPath, theOldField, theNewField, nextChild);
            }
        }
    }

    private void compareField(IBaseParameters theDiff, EncodeContextPath theSourceEncodePath, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField, BaseRuntimeChildDefinition theChildDef) {
        int targetIndex;
        String elementName = theChildDef.getElementName();
        boolean repeatable = theChildDef.getMax() != 1;
        theSourceEncodePath.pushPath(elementName, false);
        if (this.pathIsIgnored(theSourceEncodePath)) {
            theSourceEncodePath.popPath();
            return;
        }
        List sourceValues = theChildDef.getAccessor().getValues(theOldField);
        List targetValues = theChildDef.getAccessor().getValues(theNewField);
        int sourceIndex = 0;
        for (targetIndex = 0; sourceIndex < sourceValues.size() && targetIndex < targetValues.size(); ++sourceIndex, ++targetIndex) {
            IBase sourceChildField = (IBase)sourceValues.get(sourceIndex);
            Validate.notNull((Object)sourceChildField);
            BaseRuntimeElementDefinition def = this.myContext.getElementDefinition(sourceChildField.getClass());
            IBase targetChildField = (IBase)targetValues.get(targetIndex);
            Validate.notNull((Object)targetChildField);
            String sourcePath = theSourcePath + "." + elementName + (String)(repeatable ? "[" + sourceIndex + "]" : "");
            String targetPath = theSourcePath + "." + elementName + (String)(repeatable ? "[" + targetIndex + "]" : "");
            this.compare(theDiff, theSourceEncodePath, def, sourcePath, targetPath, sourceChildField, targetChildField);
        }
        while (targetIndex < targetValues.size()) {
            String path = theTargetPath + "." + elementName;
            this.addInsertItems(theDiff, targetValues, targetIndex, path, theChildDef);
            ++targetIndex;
        }
        while (sourceIndex < sourceValues.size()) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_DELETE);
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)(theTargetPath + "." + elementName + (String)(repeatable ? "[" + targetIndex + "]" : "")));
            ++sourceIndex;
            ++targetIndex;
        }
        theSourceEncodePath.popPath();
    }

    private void addInsertItems(IBaseParameters theDiff, List<? extends IBase> theTargetValues, int theTargetIndex, String thePath, BaseRuntimeChildDefinition theChildDefinition) {
        IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)PARAMETER_OPERATION);
        ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_TYPE, (String)OPERATION_INSERT);
        ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_PATH, (String)thePath);
        ParametersUtil.addPartInteger((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_INDEX, (Integer)theTargetIndex);
        IBase value = theTargetValues.get(theTargetIndex);
        BaseRuntimeElementDefinition valueDef = this.myContext.getElementDefinition(value.getClass());
        if (valueDef.isStandardType()) {
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)PARAMETER_VALUE, (IBase)value);
        } else {
            for (BaseRuntimeChildDefinition nextChild : valueDef.getChildren()) {
                List childValues = nextChild.getAccessor().getValues(value);
                for (int index = 0; index < childValues.size(); ++index) {
                    boolean childRepeatable = theChildDefinition.getMax() != 1;
                    String elementName = nextChild.getChildNameByDatatype(((IBase)childValues.get(index)).getClass());
                    String targetPath = thePath + (String)(childRepeatable ? "[" + index + "]" : "") + "." + elementName;
                    this.addInsertItems(theDiff, childValues, index, targetPath, nextChild);
                }
            }
        }
    }

    private void addValueToDiff(IBase theOperationPart, IBase theOldValue, IBase theNewValue) {
        if (this.myIncludePreviousValueInDiff) {
            IBase oldValue = this.massageValueForDiff(theOldValue);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)"previousValue", (IBase)oldValue);
        }
        IBase newValue = this.massageValueForDiff(theNewValue);
        ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)PARAMETER_VALUE, (IBase)newValue);
    }

    private boolean pathIsIgnored(EncodeContextPath theSourceEncodeContext) {
        boolean pathIsIgnored = false;
        for (EncodeContextPath next : this.myIgnorePaths) {
            if (!theSourceEncodeContext.startsWith(next, false)) continue;
            pathIsIgnored = true;
            break;
        }
        return pathIsIgnored;
    }

    private IBase massageValueForDiff(IBase theNewValue) {
        IBase massagedValue = theNewValue;
        if (theNewValue instanceof XhtmlNode) {
            String xhtmlString = ((XhtmlNode)theNewValue).getValueAsString();
            massagedValue = this.myContext.getElementDefinition("string").newInstance((Object)xhtmlString);
        }
        if (theNewValue instanceof IIdType) {
            String idPart = ((IIdType)theNewValue).getIdPart();
            massagedValue = this.myContext.getElementDefinition("id").newInstance((Object)idPart);
        }
        return massagedValue;
    }

    private String toValue(IPrimitiveType<?> theOldPrimitive) {
        if (theOldPrimitive instanceof IIdType) {
            return ((IIdType)theOldPrimitive).getIdPart();
        }
        return theOldPrimitive.getValueAsString();
    }
}

