/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.util.RandomTextUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.sourceforge.plantuml.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedFhirPath {
    private static final Logger ourLog = LoggerFactory.getLogger(ParsedFhirPath.class);
    private final FhirPathNode myHead;
    private FhirPathNode myTail;
    private final String myRawPath;
    private boolean myEndsWithFilter;
    private boolean myEndsWithAnIndex;

    ParsedFhirPath(String theFullPath) {
        this.myRawPath = theFullPath;
        this.myHead = ParsedFhirPath.createNode(this, theFullPath);
    }

    public String getRawPath() {
        return this.myRawPath;
    }

    public FhirPathNode getHead() {
        return this.myHead;
    }

    public void setTail(FhirPathNode theTail) {
        this.myTail = theTail;
    }

    public FhirPathNode getTail() {
        return this.myTail;
    }

    public void setEndsWithFilter(boolean theEndsWithFilter) {
        this.myEndsWithFilter = theEndsWithFilter;
    }

    public boolean endsWithAFilter() {
        return this.myEndsWithFilter;
    }

    public void setEndsWithAnIndex(boolean theEndsWithAnIndex) {
        this.myEndsWithAnIndex = theEndsWithAnIndex;
    }

    public boolean endsWithAnIndex() {
        return this.myEndsWithAnIndex;
    }

    public boolean endsWithFilterOrIndex() {
        return this.endsWithAFilter() || this.endsWithAnIndex();
    }

    public FhirPathNode getFirstNode(Predicate<FhirPathNode> thePred) {
        for (FhirPathNode node = this.getHead(); node != null; node = node.getNext()) {
            FhirPathNode subNode;
            FhirPathFunction fn;
            if (thePred.test(node)) {
                return node;
            }
            if (!(node instanceof FhirPathFunction) || !(fn = (FhirPathFunction)node).hasContainedExp() || (subNode = fn.getContainedExp().getFirstNode(thePred)) == null) continue;
            return subNode;
        }
        return null;
    }

    public String getTopLevelPathFromTo(Predicate<FhirPathNode> theFromPred, Predicate<FhirPathNode> theToPred) {
        StringBuilder sb = new StringBuilder();
        boolean hasStarted = false;
        for (FhirPathNode node = this.getHead(); node != null; node = node.getNext()) {
            if (!hasStarted) {
                hasStarted = theFromPred.test(node);
            }
            if (!hasStarted) continue;
            if (theToPred.test(node)) break;
            String nextVal = node.getValue();
            if (!sb.isEmpty() && !nextVal.startsWith("[")) {
                sb.append(".");
            }
            sb.append(nextVal);
            if (!(node instanceof FhirPathFunction)) continue;
            FhirPathFunction fn = (FhirPathFunction)node;
            sb.append("(");
            if (fn.hasContainedExp()) {
                sb.append(fn.getContainedExp().getRawPath());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getContainingPath() {
        StringBuilder sb = new StringBuilder();
        for (FhirPathNode current = this.myHead; current != null && !current.isFunction(); current = current.getNext()) {
            if (!sb.isEmpty()) {
                sb.append(".");
            }
            sb.append(current.getValue());
        }
        return sb.toString();
    }

    public void getAllNodesWithPred(List<FhirPathNode> theNodes, Predicate<FhirPathNode> thePred) {
        for (FhirPathNode node = this.getHead(); node != null; node = node.getNext()) {
            FhirPathFunction fn;
            if (thePred.test(node)) {
                theNodes.add(node);
            }
            if (!(node instanceof FhirPathFunction) || !(fn = (FhirPathFunction)node).hasContainedExp()) continue;
            fn.getContainedExp().getAllNodesWithPred(theNodes, thePred);
        }
    }

    public FhirPathNode getFinalPathNode() {
        FhirPathNode node = this.myTail;
        while (node != null) {
            if (node.isFunction()) {
                if (node.hasListIndex()) {
                    node = node.getPrevious();
                    continue;
                }
                FhirPathFunction fn = (FhirPathFunction)node;
                if (!fn.hasContainedExp()) {
                    node = node.getPrevious();
                    continue;
                }
                FhirPathNode subNode = fn.getContainedExp().getFinalPathNode();
                if (subNode == null || subNode.isValueNode()) {
                    node = node.getPrevious();
                    continue;
                }
                return subNode;
            }
            if (!node.isValueNode()) {
                return node;
            }
            node = node.getPrevious();
        }
        return null;
    }

    public String getLastElementName() {
        FhirPathNode finalNode = this.getFinalPathNode();
        if (finalNode == null) {
            ourLog.error("No path nodes in fhirpath");
            return null;
        }
        return finalNode.getValue();
    }

    public List<FhirPathNode> getNodes(Predicate<FhirPathNode> thePred) {
        ArrayList<FhirPathNode> nodes = new ArrayList<FhirPathNode>();
        for (FhirPathNode node = this.getHead(); node != null; node = node.getNext()) {
            if (!thePred.test(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static ParsedFhirPath parse(String theFullPath) {
        return new ParsedFhirPath(theFullPath);
    }

    private static FhirPathNode createNode(ParsedFhirPath theParsedFhirPath, String thePath) {
        FhirPathNode next;
        int dotIndex = thePath.indexOf(".");
        int braceIndex = thePath.indexOf("(");
        if (dotIndex == -1) {
            FhirPathNode tail;
            int filterIndex = thePath.indexOf("[");
            boolean endsInFilter = false;
            if (braceIndex == -1 && filterIndex == -1) {
                next = new FhirPathNode(thePath);
                if (!next.isFilter() && !next.isFunction() && ParsedFhirPath.isValueNode(thePath)) {
                    next.setAsValueNode(true);
                }
                tail = next;
            } else if (filterIndex == -1) {
                String funcType = thePath.substring(0, braceIndex);
                String containedExp = thePath.substring(braceIndex + 1, thePath.length() - 1);
                next = new FhirPathFunction(funcType);
                if (StringUtils.isNotEmpty((CharSequence)containedExp)) {
                    ((FhirPathFunction)next).setContainedExpression(containedExp);
                }
                endsInFilter = true;
                tail = next;
            } else {
                int closingFilter = RandomTextUtils.findMatchingClosingBrace(filterIndex, thePath, '[', ']');
                endsInFilter = true;
                String part1 = thePath.substring(0, filterIndex);
                String part2 = thePath.substring(filterIndex, closingFilter + 1);
                String part3 = thePath.substring(closingFilter + 1);
                FhirPathNode filterNode = new FhirPathNode(part2);
                if (StringUtils.isNotEmpty((CharSequence)part1)) {
                    FhirPathNode p1node;
                    FhirPathNode node = p1node = ParsedFhirPath.createNode(theParsedFhirPath, part1);
                    while (node.getNext() != null) {
                        node = node.getNext();
                    }
                    node.setNext(filterNode);
                    next = p1node;
                } else {
                    next = filterNode;
                }
                if (StringUtils.isNotEmpty((CharSequence)part3)) {
                    throw new InvalidRequestException(Msg.code((int)2713) + " Unexpected path after filter: " + thePath.substring(closingFilter + 1));
                }
                tail = filterNode;
                theParsedFhirPath.setEndsWithAnIndex(true);
            }
            theParsedFhirPath.setEndsWithFilter(endsInFilter);
            theParsedFhirPath.setTail(tail);
        } else if (braceIndex != -1 && braceIndex < dotIndex) {
            int closingIndex = RandomTextUtils.findMatchingClosingBrace(braceIndex, thePath);
            if (closingIndex == -1) {
                String msg = String.format("Path %s contains an unmatched brace at %d", thePath, braceIndex);
                ourLog.error(msg);
                throw new InternalErrorException(Msg.code((int)2714) + " " + msg);
            }
            String funcType = thePath.substring(0, braceIndex);
            String containedExp = thePath.substring(braceIndex + 1, closingIndex);
            int remainingIndex = dotIndex;
            if (closingIndex > dotIndex && (remainingIndex = thePath.indexOf(".", closingIndex)) == -1) {
                remainingIndex = closingIndex;
            }
            String remaining = thePath.substring(remainingIndex + 1);
            FhirPathFunction func = new FhirPathFunction(funcType);
            if (StringUtils.isNotEmpty((CharSequence)containedExp)) {
                func.setContainedExpression(containedExp);
            }
            next = func;
            if (StringUtils.isNotEmpty((CharSequence)remaining)) {
                next.setNext(ParsedFhirPath.createNode(theParsedFhirPath, remaining));
            } else {
                theParsedFhirPath.setTail(next);
            }
            theParsedFhirPath.setEndsWithFilter(true);
        } else {
            int filterIndex = thePath.indexOf("[");
            if (filterIndex == -1 || filterIndex > dotIndex) {
                String nextPart = thePath.substring(0, dotIndex);
                String remaining = thePath.substring(dotIndex + 1);
                next = new FhirPathNode(nextPart);
                next.setNext(ParsedFhirPath.createNode(theParsedFhirPath, remaining));
            } else {
                int closingFilter = RandomTextUtils.findMatchingClosingBrace(filterIndex, thePath, '[', ']');
                String nextPart = thePath.substring(0, filterIndex);
                next = new FhirPathNode(nextPart);
                String filterPart = thePath.substring(filterIndex, closingFilter + 1);
                FhirPathNode filterNode = new FhirPathNode(filterPart);
                next.setNext(filterNode);
                String remaining = thePath.substring(dotIndex + 1);
                filterNode.setNext(ParsedFhirPath.createNode(theParsedFhirPath, remaining));
            }
        }
        return next;
    }

    private static boolean isValueNode(String theValue) {
        if (theValue.contains("'")) {
            return true;
        }
        try {
            Integer.parseInt(theValue);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static class FhirPathNode {
        private FhirPathNode myPrevious;
        private FhirPathNode myNext;
        private final String myValue;
        private int myListIndex = -1;
        private boolean myIsValueNode = false;

        public FhirPathNode(String theValue) {
            int close;
            this.myValue = theValue;
            int open = theValue.indexOf("[");
            if (open != -1 && (close = RandomTextUtils.findMatchingClosingBrace(open, this.myValue, '[', ']')) != -1) {
                String val = theValue.substring(open + 1, close);
                try {
                    this.myListIndex = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    ourLog.warn("{} is not an integer", (Object)val);
                }
            }
        }

        public String getValue() {
            return this.myValue;
        }

        public boolean isValueNode() {
            return this.myIsValueNode;
        }

        public void setAsValueNode(boolean theBool) {
            this.myIsValueNode = theBool;
        }

        public boolean hasListIndex() {
            return this.myListIndex >= 0;
        }

        public int getListIndex() {
            return this.myListIndex;
        }

        public boolean isFunction() {
            return this.isFilter();
        }

        public boolean isFilter() {
            return this.myListIndex >= 0;
        }

        public boolean isNormalPathNode() {
            return !this.isFunction() && !this.isFilter() && !this.isValueNode() && !this.hasListIndex();
        }

        void setNext(FhirPathNode theNextNode) {
            this.myNext = theNextNode;
            if (theNextNode != null) {
                theNextNode.setPrevious(this);
            }
        }

        public FhirPathNode getNext() {
            return this.myNext;
        }

        void setPrevious(FhirPathNode thePreviousNode) {
            this.myPrevious = thePreviousNode;
        }

        public FhirPathNode getPrevious() {
            return this.myPrevious;
        }

        public boolean hasPrevious() {
            return this.myPrevious != null;
        }

        public boolean hasNext() {
            return this.myNext != null;
        }
    }

    public static class FhirPathFunction
    extends FhirPathNode {
        private ParsedFhirPath myContainedExp;

        public FhirPathFunction(String theValue) {
            super(theValue);
        }

        public void setContainedExpression(String theContainedExpression) {
            this.myContainedExp = ParsedFhirPath.parse(theContainedExpression);
        }

        public boolean hasContainedExp() {
            return this.myContainedExp != null;
        }

        public ParsedFhirPath getContainedExp() {
            return this.myContainedExp;
        }

        @Override
        public boolean isFunction() {
            return true;
        }

        @Override
        public boolean isFilter() {
            return super.isFilter() || this.isFilteredFunction();
        }

        private boolean isFilteredFunction() {
            switch (this.getValue()) {
                case "first": 
                case "last": 
                case "tail": 
                case "skip": 
                case "take": 
                case "intersect": 
                case "exclude": 
                case "single": {
                    return true;
                }
            }
            return false;
        }
    }
}

