/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.repository;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleProviderUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(BundleProviderUtil.class);

    private BundleProviderUtil() {
    }

    public static IBaseResource createBundleFromBundleProvider(IRestfulServer<?> theServer, RequestDetails theRequest, Integer theLimit, String theLinkSelf, Set<Include> theIncludes, IBundleProvider theResult, int theOffset, BundleTypeEnum theBundleType, String theSearchId) {
        OffsetLimitInfo offsetLimitInfo = BundleProviderUtil.extractOffsetPageInfo(theResult, theRequest, theLimit);
        InitialPagingResults initialPagingResults = BundleProviderUtil.extractInitialPagingResults(theServer, theRequest, theResult, theOffset, theSearchId, offsetLimitInfo);
        BundleProviderUtil.removeNullIfNeeded(initialPagingResults.resourceList);
        BundleProviderUtil.validateAllResourcesHaveId(initialPagingResults.resourceList);
        BundleLinks links = BundleProviderUtil.buildLinks(theServer, theRequest, theLinkSelf, theIncludes, theResult, theOffset, theBundleType, offsetLimitInfo, initialPagingResults);
        return BundleProviderUtil.buildBundle(theServer, theIncludes, theResult, theBundleType, links, initialPagingResults.resourceList);
    }

    @Nonnull
    private static BundleLinks buildLinks(IRestfulServer<?> theServer, RequestDetails theRequest, String theLinkSelf, Set<Include> theIncludes, IBundleProvider theResult, int theOffset, BundleTypeEnum theBundleType, OffsetLimitInfo theOffsetLimitInfo, InitialPagingResults theInitialPagingResults) {
        BundleLinks links = new BundleLinks(theRequest.getFhirServerBase(), theIncludes, RestfulServerUtils.prettyPrintResponse(theServer, (RequestDetails)theRequest), theBundleType);
        links.setSelf(theLinkSelf);
        if (theResult.getCurrentPageOffset() != null) {
            if (StringUtils.isNotBlank((CharSequence)theResult.getNextPageId())) {
                links.setNext(RestfulServerUtils.createOffsetPagingLink((BundleLinks)links, (String)theRequest.getRequestPath(), (String)theRequest.getTenantId(), (Integer)theOffsetLimitInfo.addOffsetAndLimit(), (Integer)theOffsetLimitInfo.limit, (Map)theRequest.getParameters()));
            }
            if (StringUtils.isNotBlank((CharSequence)theResult.getPreviousPageId())) {
                links.setNext(RestfulServerUtils.createOffsetPagingLink((BundleLinks)links, (String)theRequest.getRequestPath(), (String)theRequest.getTenantId(), (Integer)theOffsetLimitInfo.maxOfDifference(), (Integer)theOffsetLimitInfo.limit, (Map)theRequest.getParameters()));
            }
        }
        if (theOffsetLimitInfo.offset != null || !theServer.canStoreSearchResults() && !BundleProviderUtil.isEverythingOperation(theRequest)) {
            BundleProviderUtil.handleOffsetPage(theServer, theRequest, theOffset, theOffsetLimitInfo, theInitialPagingResults, links);
        } else if (StringUtils.isNotBlank((CharSequence)theResult.getCurrentPageId())) {
            BundleProviderUtil.handleCurrentPage(theRequest, theResult, theInitialPagingResults, links);
        } else if (theInitialPagingResults.searchId != null && !theInitialPagingResults.resourceList.isEmpty()) {
            BundleProviderUtil.handleSearchId(theRequest, theOffset, theInitialPagingResults, links);
        }
        return links;
    }

    private static void handleSearchId(RequestDetails theRequest, int theOffset, InitialPagingResults theInitialPagingResults, BundleLinks theLinks) {
        if (theInitialPagingResults.numTotalResults == null || theOffset + theInitialPagingResults.numToReturn < theInitialPagingResults.numTotalResults) {
            theLinks.setNext(RestfulServerUtils.createPagingLink((BundleLinks)theLinks, (RequestDetails)theRequest, (String)theInitialPagingResults.searchId, (int)(theOffset + theInitialPagingResults.numToReturn), (int)theInitialPagingResults.numToReturn, (Map)theRequest.getParameters()));
        }
        if (theOffset > 0) {
            int start = Math.max(0, theOffset - theInitialPagingResults.pageSize);
            theLinks.setPrev(RestfulServerUtils.createPagingLink((BundleLinks)theLinks, (RequestDetails)theRequest, (String)theInitialPagingResults.searchId, (int)start, (int)theInitialPagingResults.pageSize, (Map)theRequest.getParameters()));
        }
    }

    private static void handleCurrentPage(RequestDetails theRequest, IBundleProvider theResult, InitialPagingResults theInitialPagingResults, BundleLinks theLinks) {
        String searchIdToUse = theResult.getUuid();
        if (StringUtils.isNotBlank((CharSequence)theResult.getNextPageId())) {
            theLinks.setNext(RestfulServerUtils.createPagingLink((BundleLinks)theLinks, (RequestDetails)theRequest, (String)searchIdToUse, (String)theResult.getNextPageId(), (Map)theRequest.getParameters()));
        }
        if (StringUtils.isNotBlank((CharSequence)theResult.getPreviousPageId())) {
            theLinks.setPrev(RestfulServerUtils.createPagingLink((BundleLinks)theLinks, (RequestDetails)theRequest, (String)theInitialPagingResults.searchId, (String)theResult.getPreviousPageId(), (Map)theRequest.getParameters()));
        }
    }

    private static void handleOffsetPage(IRestfulServer<?> theServer, RequestDetails theRequest, int theOffset, OffsetLimitInfo theOffsetLimitInfo, InitialPagingResults theInitialPagingResults, BundleLinks theLinks) {
        int requestedToReturn = theInitialPagingResults.numToReturn;
        if (theServer.getPagingProvider() == null && theOffsetLimitInfo.offset != null) {
            requestedToReturn += theOffsetLimitInfo.offset.intValue();
        }
        if (!(theInitialPagingResults.numTotalResults != null && requestedToReturn >= theInitialPagingResults.numTotalResults || theInitialPagingResults.resourceList.isEmpty())) {
            theLinks.setNext(RestfulServerUtils.createOffsetPagingLink((BundleLinks)theLinks, (String)theRequest.getRequestPath(), (String)theRequest.getTenantId(), (Integer)((Integer)ObjectUtils.defaultIfNull((Object)theOffsetLimitInfo.offset, (Object)0) + theInitialPagingResults.numToReturn), (Integer)theInitialPagingResults.numToReturn, (Map)theRequest.getParameters()));
        }
        if (theOffsetLimitInfo.offset != null && theOffsetLimitInfo.offset > 0) {
            int start = Math.max(0, theOffset - theInitialPagingResults.pageSize);
            theLinks.setPrev(RestfulServerUtils.createOffsetPagingLink((BundleLinks)theLinks, (String)theRequest.getRequestPath(), (String)theRequest.getTenantId(), (Integer)start, (Integer)theInitialPagingResults.pageSize, (Map)theRequest.getParameters()));
        }
    }

    private static OffsetLimitInfo extractOffsetPageInfo(IBundleProvider theResult, RequestDetails theRequest, Integer theLimit) {
        Integer offsetToUse;
        Integer limitToUse = theLimit;
        if (theResult.getCurrentPageOffset() != null) {
            offsetToUse = theResult.getCurrentPageOffset();
            limitToUse = theResult.getCurrentPageSize();
            Validate.notNull((Object)limitToUse, (String)"IBundleProvider returned a non-null offset, but did not return a non-null page size", (Object[])new Object[0]);
        } else {
            offsetToUse = RestfulServerUtils.tryToExtractNamedParameter((RequestDetails)theRequest, (String)"_offset");
        }
        return new OffsetLimitInfo(offsetToUse, limitToUse);
    }

    private static InitialPagingResults extractInitialPagingResults(IRestfulServer<?> theServer, RequestDetails theRequest, IBundleProvider theResult, int theOffset, String theSearchId, OffsetLimitInfo theOffsetLimitInfo) {
        if (theOffsetLimitInfo.offset != null || !theServer.canStoreSearchResults()) {
            return BundleProviderUtil.handleOffset(theServer, theResult, theOffsetLimitInfo);
        }
        return BundleProviderUtil.handleNonOffset(theServer, theRequest, theResult, theOffset, theSearchId, theOffsetLimitInfo);
    }

    @Nonnull
    private static InitialPagingResults handleNonOffset(IRestfulServer<?> theServer, RequestDetails theRequest, IBundleProvider theResult, int theOffset, String theSearchId, OffsetLimitInfo theOffsetLimitInfo) {
        Integer numTotalResults = theResult.size();
        IPagingProvider pagingProvider = theServer.getPagingProvider();
        int pageSize = theOffsetLimitInfo.limit == null || theOffsetLimitInfo.limit.equals(0) ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), theOffsetLimitInfo.limit);
        int numToReturn = pageSize;
        if (numTotalResults != null) {
            numToReturn = Math.min(numToReturn, numTotalResults - theOffset);
        }
        List resourceList = numToReturn > 0 || theResult.getCurrentPageId() != null ? theResult.getResources(theOffset, numToReturn + theOffset) : Collections.emptyList();
        RestfulServerUtils.validateResourceListNotNull(resourceList);
        if (numTotalResults == null) {
            numTotalResults = theResult.size();
        }
        String searchIdToUse = BundleProviderUtil.computeSearchId(theRequest, theResult, theSearchId, numTotalResults, numToReturn, pagingProvider);
        return new InitialPagingResults(pageSize, resourceList, numToReturn, searchIdToUse, numTotalResults);
    }

    @Nullable
    private static String computeSearchId(RequestDetails theRequest, IBundleProvider theResult, String theSearchId, Integer theNumTotalResults, int theNumToReturn, IPagingProvider thePagingProvider) {
        String searchIdToUse = null;
        if (theSearchId != null) {
            searchIdToUse = theSearchId;
        } else if ((theNumTotalResults == null || theNumTotalResults > theNumToReturn) && StringUtils.isBlank((CharSequence)(searchIdToUse = thePagingProvider.storeResultList(theRequest, theResult)))) {
            ourLog.info("Found {} results but paging provider did not provide an ID to use for paging", (Object)theNumTotalResults);
            searchIdToUse = null;
        }
        return searchIdToUse;
    }

    @Nonnull
    private static InitialPagingResults handleOffset(IRestfulServer<?> theServer, IBundleProvider theResult, OffsetLimitInfo theOffsetLimitInfo) {
        String searchIdToUse = null;
        Integer numTotalResults = theResult.size();
        int pageSize = theOffsetLimitInfo.limit != null ? theOffsetLimitInfo.limit : (theServer.getDefaultPageSize() != null ? theServer.getDefaultPageSize() : (numTotalResults != null ? numTotalResults : Integer.MAX_VALUE));
        int numToReturn = pageSize;
        List resourceList = theOffsetLimitInfo.offset != null || theResult.getCurrentPageOffset() != null ? theResult.getResources(0, Integer.MAX_VALUE) : (numToReturn > 0 ? theResult.getResources(0, numToReturn) : Collections.emptyList());
        RestfulServerUtils.validateResourceListNotNull(resourceList);
        return new InitialPagingResults(pageSize, resourceList, numToReturn, searchIdToUse, numTotalResults);
    }

    private static IBaseResource buildBundle(IRestfulServer<?> theServer, Set<Include> theIncludes, IBundleProvider theResult, BundleTypeEnum theBundleType, BundleLinks theLinks, List<IBaseResource> theResourceList) {
        IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
        bundleFactory.addRootPropertiesToBundle(theResult.getUuid(), theLinks, theResult.size(), theResult.getPublished());
        bundleFactory.addResourcesToBundle(new ArrayList<IBaseResource>(theResourceList), theBundleType, theLinks.serverBase, theServer.getBundleInclusionRule(), theIncludes);
        return bundleFactory.getResourceBundle();
    }

    private static void removeNullIfNeeded(List<IBaseResource> theResourceList) {
        boolean hasNull = false;
        for (IBaseResource next : theResourceList) {
            if (next != null) continue;
            hasNull = true;
            break;
        }
        if (hasNull) {
            theResourceList.removeIf(Objects::isNull);
        }
    }

    private static void validateAllResourcesHaveId(List<IBaseResource> theResourceList) {
        for (IBaseResource next : theResourceList) {
            if (next.getIdElement() != null && !next.getIdElement().isEmpty() || next instanceof IBaseOperationOutcome) continue;
            throw new InternalErrorException(Msg.code((int)2637) + String.format("Server method returned resource of type[%s] with no ID specified (IResource#setId(IdDt) must be called)", next.getIdElement()));
        }
    }

    private static boolean isEverythingOperation(RequestDetails theRequest) {
        return (theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_TYPE || theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE) && theRequest.getOperation() != null && theRequest.getOperation().equals("$everything");
    }

    private record OffsetLimitInfo(Integer offset, Integer limit) {
        int addOffsetAndLimit() {
            return this.offsetOrZero() + this.limitOrZero();
        }

        int maxOfDifference() {
            return Math.max(this.offsetOrZero() - this.limitOrZero(), 0);
        }

        private int offsetOrZero() {
            return this.defaultZeroIfNull(this.offset);
        }

        private int limitOrZero() {
            return this.defaultZeroIfNull(this.offset);
        }

        private int defaultZeroIfNull(Integer value) {
            return (Integer)ObjectUtils.defaultIfNull((Object)value, (Object)0);
        }
    }

    private record InitialPagingResults(int pageSize, List<IBaseResource> resourceList, int numToReturn, String searchId, Integer numTotalResults) {
    }
}

