/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.repository.BundleProviderUtil;
import ca.uhn.fhir.jpa.repository.RequestDetailsCloner;
import ca.uhn.fhir.jpa.repository.SearchConverter;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapiFhirRepository
implements IRepository {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiFhirRepository.class);
    private final DaoRegistry myDaoRegistry;
    private final RequestDetails myRequestDetails;
    private final RestfulServer myRestfulServer;

    public HapiFhirRepository(DaoRegistry theDaoRegistry, RequestDetails theRequestDetails, RestfulServer theRestfulServer) {
        this.myDaoRegistry = theDaoRegistry;
        this.myRequestDetails = theRequestDetails;
        this.myRestfulServer = theRestfulServer;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> theResourceType, I theId, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.READ).addHeaders(theHeaders).create();
        return this.myDaoRegistry.getResourceDao(theResourceType).read(theId, details);
    }

    public <T extends IBaseResource> MethodOutcome create(T theResource, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.CREATE).addHeaders(theHeaders).create();
        return this.myDaoRegistry.getResourceDao(theResource).create(theResource, details);
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I theId, P thePatchParameters, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.PATCH).addHeaders(theHeaders).create();
        return this.myDaoRegistry.getResourceDao(theId.getResourceType()).patch(theId, null, PatchTypeEnum.FHIR_PATCH_JSON, null, thePatchParameters, details);
    }

    public <T extends IBaseResource> MethodOutcome update(T theResource, Map<String, String> theHeaders) {
        boolean created;
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.UPDATE).addHeaders(theHeaders).create();
        DaoMethodOutcome update = this.myDaoRegistry.getResourceDao(theResource).update(theResource, details);
        boolean bl = created = update.getCreated() != null && update.getCreated() != false;
        if (created) {
            update.setResponseStatusCode(201);
        } else {
            update.setResponseStatusCode(200);
        }
        return update;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> theResourceType, I theId, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.DELETE).addHeaders(theHeaders).create();
        return this.myDaoRegistry.getResourceDao(theResourceType).delete(theId, details);
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> theBundleType, Class<T> theResourceType, Multimap<String, List<IQueryParameterType>> theSearchParameters, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.SEARCH_TYPE).addHeaders(theHeaders).create();
        SearchConverter converter = new SearchConverter();
        converter.convertParameters(theSearchParameters, this.fhirContext());
        details.setParameters(converter.myResultParameters);
        details.setResourceName(this.myDaoRegistry.getFhirContext().getResourceType(theResourceType));
        IBundleProvider bundleProvider = this.myDaoRegistry.getResourceDao(theResourceType).search(converter.mySearchParameterMap, details);
        if (bundleProvider == null) {
            return null;
        }
        return this.createBundle(details, bundleProvider, null);
    }

    private <B extends IBaseBundle> B createBundle(RequestDetails theRequestDetails, @Nonnull IBundleProvider theBundleProvider, String thePagingAction) {
        String[] bundleTypeValues;
        Integer offset;
        Integer count = RestfulServerUtils.extractCountParameter((RequestDetails)theRequestDetails);
        String linkSelf = RestfulServerUtils.createLinkSelf((String)theRequestDetails.getFhirServerBase(), (RequestDetails)theRequestDetails);
        HashSet<Include> includes = new HashSet<Include>();
        String[] reqIncludes = (String[])theRequestDetails.getParameters().get("_include");
        if (reqIncludes != null) {
            for (String nextInclude : reqIncludes) {
                includes.add(new Include(nextInclude));
            }
        }
        if ((offset = RestfulServerUtils.tryToExtractNamedParameter((RequestDetails)theRequestDetails, (String)"_getpagesoffset")) == null || offset < 0) {
            offset = 0;
        }
        int start = offset;
        Integer size = theBundleProvider.size();
        if (size != null) {
            start = Math.max(0, Math.min(offset, size));
        }
        BundleTypeEnum bundleType = (bundleTypeValues = (String[])theRequestDetails.getParameters().get("_bundletype")) != null ? (BundleTypeEnum)BundleTypeEnum.VALUESET_BINDER.fromCodeString(bundleTypeValues[0]) : BundleTypeEnum.SEARCHSET;
        return (B)((IBaseBundle)HapiFhirRepository.unsafeCast(BundleProviderUtil.createBundleFromBundleProvider(this.myRestfulServer, theRequestDetails, count, linkSelf, includes, theBundleProvider, start, bundleType, thePagingAction)));
    }

    public <B extends IBaseBundle> B link(Class<B> theBundleType, String theUrl, Map<String, String> theHeaders) {
        IBundleProvider bundleProvider;
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.GET_PAGE).addHeaders(theHeaders).create();
        UrlUtil.UrlParts urlParts = UrlUtil.parseUrl((String)theUrl);
        details.setCompleteUrl(theUrl);
        details.setParameters(UrlUtil.parseQueryStrings((String[])new String[]{urlParts.getParams()}));
        IPagingProvider pagingProvider = this.myRestfulServer.getPagingProvider();
        if (pagingProvider == null) {
            throw new InvalidRequestException(Msg.code((int)2638) + "This server does not support paging");
        }
        String pagingAction = ((String[])details.getParameters().get("_getpages"))[0];
        String pageId = null;
        String[] pageIdParams = (String[])details.getParameters().get("_pageId");
        if (pageIdParams != null && pageIdParams.length > 0 && StringUtils.isNotBlank((CharSequence)pageIdParams[0])) {
            pageId = pageIdParams[0];
        }
        if (pageId != null) {
            bundleProvider = pagingProvider.retrieveResultList(details, pagingAction, pageId);
            this.validateHaveBundleProvider(pagingAction, bundleProvider);
        } else {
            bundleProvider = pagingProvider.retrieveResultList(details, pagingAction);
            this.validateHaveBundleProvider(pagingAction, bundleProvider);
        }
        return this.createBundle(details, bundleProvider, pagingAction);
    }

    private void validateHaveBundleProvider(String thePagingAction, IBundleProvider theBundleProvider) {
        if (theBundleProvider == null) {
            ourLog.info("Client requested unknown paging ID[{}]", (Object)thePagingAction);
            String msg = this.fhirContext().getLocalizer().getMessage(PageMethodBinding.class, "unknownSearchId", new Object[]{thePagingAction});
            throw new ResourceGoneException(Msg.code((int)2639) + msg);
        }
    }

    public <C extends IBaseConformance> C capabilities(Class<C> theCapabilityStatementType, Map<String, String> theHeaders) {
        ConformanceMethodBinding method = this.myRestfulServer.getServerConformanceMethod();
        if (method == null) {
            return null;
        }
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.METADATA).addHeaders(theHeaders).create();
        return (C)((IBaseConformance)HapiFhirRepository.unsafeCast(method.provideCapabilityStatement(this.myRestfulServer, details)));
    }

    public <B extends IBaseBundle> B transaction(B theBundle, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.TRANSACTION).addHeaders(theHeaders).create();
        return (B)((IBaseBundle)HapiFhirRepository.unsafeCast(this.myDaoRegistry.getSystemDao().transaction(details, theBundle)));
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String theName, P theParameters, Class<R> theReturnType, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setParameters(theParameters).create();
        return (R)((IBaseResource)this.invoke(details));
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String theName, P theParameters, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setParameters(theParameters).create();
        return (MethodOutcome)this.invoke(details);
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> theResourceType, String theName, P theParameters, Class<R> theReturnType, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setResourceType(theResourceType.getSimpleName()).setParameters(theParameters).create();
        return (R)((IBaseResource)this.invoke(details));
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> theResourceType, String theName, P theParameters, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setResourceType(theResourceType.getSimpleName()).setParameters(theParameters).create();
        return (MethodOutcome)this.invoke(details);
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I theId, String theName, P theParameters, Class<R> theReturnType, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setResourceType(theId.getResourceType()).setId(theId).setParameters(theParameters).create();
        return (R)((IBaseResource)this.invoke(details));
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I theId, String theName, P theParameters, Map<String, String> theHeaders) {
        RequestDetails details = RequestDetailsCloner.startWith(this.myRequestDetails).setAction(RestOperationTypeEnum.EXTENDED_OPERATION_SERVER).addHeaders(theHeaders).setOperation(theName).setResourceType(theId.getResourceType()).setId(theId).setParameters(theParameters).create();
        return (MethodOutcome)this.invoke(details);
    }

    private void notImplemented() {
        throw new NotImplementedOperationException(Msg.code((int)2640) + "history not yet implemented");
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P theParameters, Class<B> theBundleType, Map<String, String> theHeaders) {
        this.notImplemented();
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> theResourceType, P theParameters, Class<B> theBundleType, Map<String, String> theHeaders) {
        this.notImplemented();
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I theId, P theParameters, Class<B> theBundleType, Map<String, String> theHeaders) {
        this.notImplemented();
        return null;
    }

    @Nonnull
    public FhirContext fhirContext() {
        return this.myDaoRegistry.getFhirContext();
    }

    protected <R> R invoke(RequestDetails theDetails) {
        try {
            return (R)HapiFhirRepository.unsafeCast(this.myRestfulServer.determineResourceMethod(theDetails, null).invokeServer((IRestfulServer)this.myRestfulServer, theDetails));
        }
        catch (IOException exception) {
            throw new InternalErrorException(Msg.code((int)2641) + String.valueOf(exception));
        }
    }

    private static <T> T unsafeCast(Object theObject) {
        return (T)theObject;
    }
}

