/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.repository;

import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

class RequestDetailsCloner {
    private RequestDetailsCloner() {
    }

    static DetailsBuilder startWith(RequestDetails theDetails) {
        SystemRequestDetails newDetails;
        if (theDetails instanceof ServletRequestDetails) {
            ServletRequestDetails servletDetails = (ServletRequestDetails)theDetails;
            newDetails = new ServletRequestDetails(servletDetails);
        } else {
            newDetails = new SystemRequestDetails(theDetails);
        }
        newDetails.setRequestType(RequestTypeEnum.POST);
        newDetails.setOperation(null);
        newDetails.setResource(null);
        newDetails.setParameters(new HashMap());
        newDetails.setResourceName(null);
        newDetails.setCompartmentName(null);
        newDetails.setResponse(theDetails.getResponse());
        return new DetailsBuilder((RequestDetails)newDetails);
    }

    static class DetailsBuilder {
        private final RequestDetails myDetails;

        DetailsBuilder(RequestDetails theDetails) {
            this.myDetails = theDetails;
        }

        DetailsBuilder setAction(RestOperationTypeEnum theRestOperationType) {
            this.myDetails.setRestOperationType(theRestOperationType);
            return this;
        }

        DetailsBuilder addHeaders(Map<String, String> theHeaders) {
            if (theHeaders != null) {
                for (Map.Entry<String, String> entry : theHeaders.entrySet()) {
                    this.myDetails.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        DetailsBuilder setParameters(IBaseParameters theParameters) {
            IParser parser = this.myDetails.getServer().getFhirContext().newJsonParser();
            this.myDetails.setRequestContents(parser.encodeResourceToString((IBaseResource)theParameters).getBytes());
            return this;
        }

        DetailsBuilder setParameters(Map<String, String[]> theParameters) {
            this.myDetails.setParameters(theParameters);
            return this;
        }

        DetailsBuilder withRestOperationType(RequestTypeEnum theType) {
            this.myDetails.setRequestType(theType);
            return this;
        }

        DetailsBuilder setOperation(String theOperation) {
            this.myDetails.setOperation(theOperation);
            return this;
        }

        DetailsBuilder setResourceType(String theResourceName) {
            this.myDetails.setResourceName(theResourceName);
            return this;
        }

        DetailsBuilder setId(IIdType theId) {
            this.myDetails.setId(theId);
            return this;
        }

        RequestDetails create() {
            return this.myDetails;
        }
    }
}

