/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchConverter {
    private final List<String> mySearchResultParameters = Arrays.asList("_sort", "_count", "_include", "_revinclude", "_summary", "_total", "_elements", "_contained", "_containedType");
    public final Multimap<String, List<IQueryParameterType>> mySeparatedSearchParameters = ArrayListMultimap.create();
    public final Multimap<String, List<IQueryParameterType>> mySeparatedResultParameters = ArrayListMultimap.create();
    public final SearchParameterMap mySearchParameterMap = new SearchParameterMap();
    public final Map<String, String[]> myResultParameters = new HashMap<String, String[]>();

    public void convertParameters(Multimap<String, List<IQueryParameterType>> theParameters, FhirContext theFhirContext) {
        if (theParameters == null) {
            return;
        }
        this.separateParameterTypes(theParameters);
        this.convertToSearchParameterMap(this.mySeparatedSearchParameters);
        this.convertToStringMap(this.mySeparatedResultParameters, theFhirContext);
    }

    public void convertToStringMap(@Nonnull Multimap<String, List<IQueryParameterType>> theParameters, @Nonnull FhirContext theFhirContext) {
        for (Map.Entry entry : theParameters.entries()) {
            String[] values = new String[((List)entry.getValue()).size()];
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                values[i] = ((IQueryParameterType)((List)entry.getValue()).get(i)).getValueAsQueryToken(theFhirContext);
            }
            this.myResultParameters.put((String)entry.getKey(), values);
        }
    }

    public void convertToSearchParameterMap(Multimap<String, List<IQueryParameterType>> theSearchMap) {
        if (theSearchMap == null) {
            return;
        }
        for (Map.Entry entry : theSearchMap.entries()) {
            if (((List)entry.getValue()).size() > 1 && !this.isOrList((List)entry.getValue()) && !this.isAndList((List)entry.getValue())) {
                this.addTokenToSearchIfNeeded(entry);
                continue;
            }
            for (IQueryParameterType value : (List)entry.getValue()) {
                this.setParameterTypeValue((String)entry.getKey(), value);
            }
        }
    }

    private void addTokenToSearchIfNeeded(Map.Entry<String, List<IQueryParameterType>> theEntry) {
        if (this.isTokenParam(theEntry.getValue().get(0))) {
            String tokenKey = theEntry.getKey();
            TokenOrListParam tokenList = new TokenOrListParam();
            for (IQueryParameterType rec : theEntry.getValue()) {
                tokenList.add((IQueryParameterType)((TokenParam)rec));
            }
            this.mySearchParameterMap.add(tokenKey, (IQueryParameterOr)tokenList);
        }
    }

    public <T> void setParameterTypeValue(@Nonnull String theKey, @Nonnull T theParameterType) {
        if (this.isOrList(theParameterType)) {
            this.mySearchParameterMap.add(theKey, (IQueryParameterOr)theParameterType);
        } else if (this.isAndList(theParameterType)) {
            this.mySearchParameterMap.add(theKey, (IQueryParameterAnd)theParameterType);
        } else {
            this.mySearchParameterMap.add(theKey, (IQueryParameterType)theParameterType);
        }
    }

    public void separateParameterTypes(@Nonnull Multimap<String, List<IQueryParameterType>> theParameters) {
        for (Map.Entry entry : theParameters.entries()) {
            if (this.isSearchResultParameter((String)entry.getKey())) {
                this.mySeparatedResultParameters.put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
                continue;
            }
            this.mySeparatedSearchParameters.put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
        }
    }

    public boolean isSearchResultParameter(String theParameterName) {
        return this.mySearchResultParameters.contains(theParameterName);
    }

    public <T> boolean isOrList(@Nonnull T theParameterType) {
        return IQueryParameterOr.class.isAssignableFrom(theParameterType.getClass());
    }

    public <T> boolean isAndList(@Nonnull T theParameterType) {
        return IQueryParameterAnd.class.isAssignableFrom(theParameterType.getClass());
    }

    public <T> boolean isTokenParam(@Nonnull T theParameterType) {
        return TokenParam.class.isAssignableFrom(theParameterType.getClass());
    }
}

