/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.broker.jms.ISpringMessagingChannelProducer;
import ca.uhn.fhir.broker.jms.ISpringMessagingChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.impl.RetryPolicyProvider;
import ca.uhn.fhir.jpa.subscription.channel.impl.RetryingMessageHandlerWrapper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ExecutorSubscribableChannel;

public class LinkedBlockingChannel
extends ExecutorSubscribableChannel
implements ISpringMessagingChannelProducer,
ISpringMessagingChannelReceiver {
    private final String myChannelName;
    private final Supplier<Integer> myQueueSizeSupplier;
    private final RetryPolicyProvider myRetryPolicyProvider;

    public LinkedBlockingChannel(String theChannelName, Executor theExecutor, Supplier<Integer> theQueueSizeSupplier, RetryPolicyProvider theRetryPolicyProvider) {
        super(theExecutor);
        this.myChannelName = theChannelName;
        this.myQueueSizeSupplier = theQueueSizeSupplier;
        this.myRetryPolicyProvider = theRetryPolicyProvider;
    }

    @VisibleForTesting
    public int getQueueSizeForUnitTest() {
        return (Integer)ObjectUtils.defaultIfNull((Object)this.myQueueSizeSupplier.get(), (Object)0);
    }

    @VisibleForTesting
    public void clearInterceptorsForUnitTest() {
        this.setInterceptors(new ArrayList());
    }

    @Override
    public String getChannelName() {
        return this.myChannelName;
    }

    public boolean hasSubscription(@Nonnull MessageHandler handler) {
        return this.getSubscribers().stream().map(t -> (RetryingMessageHandlerWrapper)t).anyMatch(t -> t.getWrappedHandler() == handler);
    }

    public boolean subscribe(@Nonnull MessageHandler theHandler) {
        return super.subscribe((MessageHandler)new RetryingMessageHandlerWrapper(theHandler, this.getChannelName(), this.myRetryPolicyProvider));
    }

    public boolean unsubscribe(@Nonnull MessageHandler handler) {
        Optional<RetryingMessageHandlerWrapper> match = this.getSubscribers().stream().map(t -> (RetryingMessageHandlerWrapper)t).filter(t -> t.getWrappedHandler() == handler).findFirst();
        match.ifPresent(x$0 -> super.unsubscribe(x$0));
        return match.isPresent();
    }

    public void destroy() {
    }

    @VisibleForTesting
    public static LinkedBlockingChannel newSynchronous(String theName, RetryPolicyProvider theRetryPolicyProvider) {
        return new LinkedBlockingChannel(theName, null, () -> 0, theRetryPolicyProvider);
    }
}

