/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IChannelNamer;
import ca.uhn.fhir.broker.api.IChannelSettings;
import ca.uhn.fhir.broker.jms.ISpringMessagingChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.impl.LinkedBlockingChannel;
import ca.uhn.fhir.jpa.subscription.channel.impl.RetryPolicyProvider;
import ca.uhn.fhir.util.ThreadPoolUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class LinkedBlockingChannelFactory {
    private final IChannelNamer myChannelNamer;
    private final Map<String, LinkedBlockingChannel> myChannels = Collections.synchronizedMap(new HashMap());
    protected RetryPolicyProvider myRetryPolicyProvider;

    public LinkedBlockingChannelFactory(IChannelNamer theChannelNamer, RetryPolicyProvider theRetryPolicyProvider) {
        this.myChannelNamer = theChannelNamer;
        this.myRetryPolicyProvider = theRetryPolicyProvider;
    }

    public LinkedBlockingChannel getOrCreateReceiver(String theChannelName, ChannelConsumerSettings theChannelSettings) {
        return this.getOrCreateChannel(theChannelName, theChannelSettings.getConcurrentConsumers(), theChannelSettings);
    }

    public ISpringMessagingChannelProducer getOrCreateProducer(String theChannelName, ChannelProducerSettings theChannelSettings) {
        return this.getOrCreateChannel(theChannelName, theChannelSettings.getConcurrentConsumers(), theChannelSettings);
    }

    public IChannelNamer getChannelNamer() {
        return this.myChannelNamer;
    }

    private LinkedBlockingChannel getOrCreateChannel(String theChannelName, int theConcurrentConsumers, IChannelSettings theChannelSettings) {
        String channelName = this.myChannelNamer.getChannelName(theChannelName, theChannelSettings);
        return this.myChannels.computeIfAbsent(channelName, t -> this.buildLinkedBlockingChannel(theConcurrentConsumers, channelName));
    }

    @Nonnull
    protected LinkedBlockingChannel buildLinkedBlockingChannel(int theConcurrentConsumers, String theChannelName) {
        String threadNamePrefix = theChannelName + "-";
        ThreadPoolTaskExecutor threadPoolExecutor = ThreadPoolUtil.newThreadPool(theConcurrentConsumers, theConcurrentConsumers, threadNamePrefix, 1000);
        return new LinkedBlockingChannel(theChannelName, (Executor)threadPoolExecutor, () -> ((ThreadPoolTaskExecutor)threadPoolExecutor).getQueueSize(), this.myRetryPolicyProvider);
    }

    @PreDestroy
    public void stop() {
        this.myChannels.clear();
    }
}

