/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.jpa.subscription.channel.impl.RetryPolicyProvider;
import ca.uhn.fhir.util.BaseUnrecoverableRuntimeException;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.CannotCreateTransactionException;

class RetryingMessageHandlerWrapper
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(RetryingMessageHandlerWrapper.class);
    private final MessageHandler myWrap;
    private final String myChannelName;
    private RetryPolicyProvider myRetryPolicyProvider;

    RetryingMessageHandlerWrapper(MessageHandler theWrap, String theChannelName, RetryPolicyProvider theRetryPolicyProvider) {
        this.myWrap = theWrap;
        this.myChannelName = theChannelName;
        this.myRetryPolicyProvider = theRetryPolicyProvider;
    }

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        RetryTemplate retryTemplate = this.myRetryPolicyProvider.getRetryTemplate();
        RetryListener retryListener = new RetryListener(){

            public <T, E extends Throwable> void onError(RetryContext theContext, RetryCallback<T, E> theCallback, Throwable theThrowable) {
                ourLog.error("Failure {} processing message in channel[{}]: {}", new Object[]{theContext.getRetryCount(), RetryingMessageHandlerWrapper.this.myChannelName, theThrowable.toString()});
                ourLog.error("Failure", theThrowable);
                if (theThrowable instanceof BaseUnrecoverableRuntimeException) {
                    theContext.setExhaustedOnly();
                }
                if (ExceptionUtils.indexOfThrowable((Throwable)theThrowable, CannotCreateTransactionException.class) != -1) {
                    theContext.setExhaustedOnly();
                }
            }
        };
        retryTemplate.setListeners(new RetryListener[]{retryListener});
        retryTemplate.execute(context -> {
            this.myWrap.handleMessage(theMessage);
            return null;
        });
    }

    public MessageHandler getWrappedHandler() {
        return this.myWrap;
    }
}

