/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IBrokerClient;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import org.apache.commons.lang3.Validate;

public class SubscriptionChannelFactory {
    private final IBrokerClient myBrokerClient;

    public SubscriptionChannelFactory(IBrokerClient theBrokerClient) {
        Validate.notNull((Object)theBrokerClient);
        this.myBrokerClient = theBrokerClient;
    }

    public IChannelProducer<ResourceDeliveryMessage> newDeliveryProducer(String theChannelName, ChannelProducerSettings theChannelSettings) {
        ChannelProducerSettings config = this.newProducerConfigForDeliveryChannel(theChannelSettings);
        config.setRetryConfiguration(theChannelSettings.getRetryConfigurationParameters());
        return this.myBrokerClient.getOrCreateProducer(theChannelName, ResourceDeliveryJsonMessage.class, config);
    }

    public IChannelConsumer<ResourceDeliveryMessage> newDeliveryConsumer(String theChannelName, IMessageListener<ResourceDeliveryMessage> theListener, ChannelConsumerSettings theChannelSettings) {
        ChannelConsumerSettings config = this.newConsumerConfigForDeliveryChannel(theChannelSettings);
        return this.myBrokerClient.getOrCreateConsumer(theChannelName, ResourceDeliveryJsonMessage.class, theListener, config);
    }

    public IChannelProducer<ResourceModifiedMessage> newMatchingProducer(String theChannelName, ChannelProducerSettings theChannelSettings) {
        ChannelProducerSettings config = this.newProducerConfigForMatchingChannel(theChannelSettings);
        return this.myBrokerClient.getOrCreateProducer(theChannelName, ResourceModifiedJsonMessage.class, config);
    }

    public IChannelConsumer<ResourceModifiedMessage> newMatchingConsumer(String theChannelName, IMessageListener<ResourceModifiedMessage> theListener, ChannelConsumerSettings theChannelSettings) {
        ChannelConsumerSettings config = this.newConsumerConfigForMatchingChannel(theChannelSettings);
        return this.myBrokerClient.getOrCreateConsumer(theChannelName, ResourceModifiedJsonMessage.class, theListener, config);
    }

    protected ChannelProducerSettings newProducerConfigForDeliveryChannel(ChannelProducerSettings theOptions) {
        ChannelProducerSettings config = new ChannelProducerSettings();
        config.setConcurrentConsumers(this.getDeliveryChannelConcurrentConsumers());
        config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        return config;
    }

    protected ChannelConsumerSettings newConsumerConfigForDeliveryChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getDeliveryChannelConcurrentConsumers());
        if (theOptions != null) {
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        }
        return config;
    }

    protected ChannelProducerSettings newProducerConfigForMatchingChannel(ChannelProducerSettings theOptions) {
        ChannelProducerSettings config = new ChannelProducerSettings();
        if (theOptions != null) {
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
            config.setQualifyChannelName(theOptions.isQualifyChannelName());
        }
        config.setConcurrentConsumers(this.getMatchingChannelConcurrentConsumers());
        return config;
    }

    protected ChannelConsumerSettings newConsumerConfigForMatchingChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getMatchingChannelConcurrentConsumers());
        if (theOptions != null) {
            config.setQualifyChannelName(theOptions.isQualifyChannelName());
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        }
        return config;
    }

    public int getDeliveryChannelConcurrentConsumers() {
        return 2;
    }

    public int getMatchingChannelConcurrentConsumers() {
        return 5;
    }

    public IBrokerClient getBrokerClient() {
        return this.myBrokerClient;
    }
}

