/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.CanonicalTopicSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalTopicSubscriptionFilter;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.dstu2.resource.Subscription;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.SubscriptionUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionCanonicalizer {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionCanonicalizer.class);
    final FhirContext myFhirContext;
    private final SubscriptionSettings mySubscriptionSettings;
    private PartitionSettings myPartitionSettings;
    private IRequestPartitionHelperSvc myHelperSvc;

    @Autowired
    public SubscriptionCanonicalizer(FhirContext theFhirContext, SubscriptionSettings theSubscriptionSettings, @Nullable PartitionSettings thePartitionSettings) {
        this.myFhirContext = theFhirContext;
        this.mySubscriptionSettings = theSubscriptionSettings;
        this.myPartitionSettings = thePartitionSettings;
    }

    @Autowired
    public void setPartitionHelperSvc(IRequestPartitionHelperSvc thePartitionHelperSvc) {
        this.myHelperSvc = thePartitionHelperSvc;
    }

    public CanonicalSubscription canonicalize(IBaseResource theSubscription) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                return this.canonicalizeDstu2(theSubscription);
            }
            case DSTU3: {
                return this.canonicalizeDstu3(theSubscription);
            }
            case R4: {
                return this.canonicalizeR4(theSubscription);
            }
            case R4B: {
                return this.canonicalizeR4B(theSubscription);
            }
            case R5: {
                return this.canonicalizeR5(theSubscription);
            }
        }
        throw new ConfigurationException(Msg.code((int)556) + "Subscription not supported for version: " + String.valueOf(this.myFhirContext.getVersion().getVersion()));
    }

    private CanonicalSubscription canonicalizeDstu2(IBaseResource theSubscription) {
        ca.uhn.fhir.model.dstu2.resource.Subscription subscription = (ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        try {
            retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)subscription.getStatus()));
            retVal.setChannelType(this.getChannelType(theSubscription));
            retVal.setCriteriaString(subscription.getCriteria());
            Subscription.Channel channel = subscription.getChannel();
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setHeaders(channel.getHeader());
            retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
            retVal.setIdElement(subscription.getIdElement());
            retVal.setPayloadString(channel.getPayload());
            retVal.setTags(this.extractTags((IBaseResource)subscription));
            retVal.setCrossPartitionEnabled(this.handleCrossPartition(theSubscription));
            retVal.setSendDeleteMessages(this.extractDeleteExtensionDstu2(subscription));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)557) + String.valueOf((Object)theE));
        }
        return retVal;
    }

    private boolean extractDeleteExtensionDstu2(ca.uhn.fhir.model.dstu2.resource.Subscription theSubscription) {
        return theSubscription.getChannel().getUndeclaredExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages").stream().map(ExtensionDt::getValue).map(BooleanDt.class::cast).map(BasePrimitive::getValue).findFirst().orElse(false);
    }

    private Map<String, String> extractTags(IBaseResource theSubscription) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        theSubscription.getMeta().getTag().stream().filter(t -> t.getSystem() != null && t.getCode() != null).forEach(t -> retVal.put(t.getSystem(), t.getCode()));
        return retVal;
    }

    private CanonicalSubscription canonicalizeDstu3(IBaseResource theSubscription) {
        org.hl7.fhir.dstu3.model.Subscription subscription = (org.hl7.fhir.dstu3.model.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        try {
            Subscription.SubscriptionStatus status = subscription.getStatus();
            if (status != null) {
                retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)status.toCode()));
            }
            this.setPartitionIdOnReturnValue(theSubscription, retVal);
            retVal.setChannelType(this.getChannelType(theSubscription));
            retVal.setCriteriaString(subscription.getCriteria());
            Subscription.SubscriptionChannelComponent channel = subscription.getChannel();
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setHeaders(channel.getHeader());
            retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
            retVal.setIdElement((IIdType)subscription.getIdElement());
            retVal.setPayloadString(channel.getPayload());
            retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
            retVal.setTags(this.extractTags((IBaseResource)subscription));
            retVal.setCrossPartitionEnabled(this.handleCrossPartition(theSubscription));
            if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
                String subjectTemplate;
                String from;
                try {
                    from = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                    subjectTemplate = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
                }
                catch (FHIRException theE) {
                    throw new ConfigurationException(Msg.code((int)558) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
                }
                retVal.getEmailDetails().setFrom(from);
                retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
            }
            if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
                String deliverLatestVersion;
                String stripVersionIds;
                try {
                    stripVersionIds = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                    deliverLatestVersion = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
                }
                catch (FHIRException theE) {
                    throw new ConfigurationException(Msg.code((int)559) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
                }
                retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
                retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
            }
            retVal.setSendDeleteMessages(this.extractSendDeletesDstu3(subscription));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)560) + String.valueOf((Object)theE));
        }
        return retVal;
    }

    private Boolean extractSendDeletesDstu3(org.hl7.fhir.dstu3.model.Subscription subscription) {
        return subscription.getChannel().getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages").stream().map(org.hl7.fhir.dstu3.model.Extension::getValue).filter(val -> val instanceof org.hl7.fhir.dstu3.model.BooleanType).map(val -> (org.hl7.fhir.dstu3.model.BooleanType)val).map(org.hl7.fhir.dstu3.model.BooleanType::booleanValue).findFirst().orElse(false);
    }

    @Nonnull
    private Map<String, List<String>> extractExtension(IBaseResource theSubscription) {
        try {
            switch (theSubscription.getStructureFhirVersionEnum()) {
                case DSTU2: {
                    ca.uhn.fhir.model.dstu2.resource.Subscription subscription = (ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription;
                    return subscription.getChannel().getUndeclaredExtensions().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.Subscription subscription = (org.hl7.fhir.dstu3.model.Subscription)theSubscription;
                    return subscription.getChannel().getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case R4: {
                    Subscription subscription = (Subscription)theSubscription;
                    return subscription.getChannel().getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case R5: {
                    if (theSubscription instanceof org.hl7.fhir.r4b.model.Subscription) {
                        org.hl7.fhir.r4b.model.Subscription subscription = (org.hl7.fhir.r4b.model.Subscription)theSubscription;
                        return subscription.getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                    }
                    if (!(theSubscription instanceof org.hl7.fhir.r5.model.Subscription)) break;
                    org.hl7.fhir.r5.model.Subscription subscription = (org.hl7.fhir.r5.model.Subscription)theSubscription;
                    return subscription.getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
            }
            ourLog.error("Failed to extract extension from subscription {}", (Object)theSubscription.getIdElement().toUnqualified().getValue());
        }
        catch (FHIRException theE) {
            ourLog.error("Failed to extract extension from subscription {}", (Object)theSubscription.getIdElement().toUnqualified().getValue(), (Object)theE);
        }
        return Collections.emptyMap();
    }

    private CanonicalSubscription canonicalizeR4(IBaseResource theSubscription) {
        IBaseReference ref;
        List topicExts;
        Subscription subscription = (Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        retVal.setStatus(subscription.getStatus());
        Subscription.SubscriptionChannelComponent channel = subscription.getChannel();
        retVal.setHeaders(channel.getHeader());
        retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
        retVal.setIdElement((IIdType)subscription.getIdElement());
        retVal.setPayloadString(channel.getPayload());
        retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
        retVal.setTags(this.extractTags((IBaseResource)subscription));
        this.setPartitionIdOnReturnValue(theSubscription, retVal);
        retVal.setCrossPartitionEnabled(this.handleCrossPartition(theSubscription));
        List profiles = subscription.getMeta().getProfile();
        for (Object next : profiles) {
            if (!"http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-subscription".equals(next.getValueAsString())) continue;
            retVal.setTopicSubscription(true);
        }
        if (retVal.isTopicSubscription()) {
            CanonicalTopicSubscription topicSubscription = retVal.getTopicSubscription();
            topicSubscription.setTopic(this.getCriteria(theSubscription));
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
            for (Extension next : subscription.getCriteriaElement().getExtension()) {
                if (!"http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria".equals(next.getUrl())) continue;
                List<CanonicalTopicSubscriptionFilter> filters = CanonicalTopicSubscriptionFilter.fromQueryUrl(next.getValue().primitiveValue());
                filters.forEach(topicSubscription::addFilter);
            }
            if (channel.hasExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-heartbeat-period")) {
                Extension channelHeartbeatPeriotUrlExtension = channel.getExtensionByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-heartbeat-period");
                topicSubscription.setHeartbeatPeriod(Integer.valueOf(channelHeartbeatPeriotUrlExtension.getValue().primitiveValue()));
            }
            if (channel.hasExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-timeout")) {
                Extension channelTimeoutUrlExtension = channel.getExtensionByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-timeout");
                topicSubscription.setTimeout(Integer.valueOf(channelTimeoutUrlExtension.getValue().primitiveValue()));
            }
            if (channel.hasExtension("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-max-count")) {
                Extension channelMaxCountExtension = channel.getExtensionByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-max-count");
                topicSubscription.setMaxCount(Integer.valueOf(channelMaxCountExtension.getValue().primitiveValue()));
            }
            Subscription.SubscriptionPayloadContent payloadContent = Subscription.SubscriptionPayloadContent.FULLRESOURCE;
            Extension channelPayloadContentExtension = channel.getPayloadElement().getExtensionByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-payload-content");
            if (Objects.nonNull(channelPayloadContentExtension)) {
                payloadContent = Subscription.SubscriptionPayloadContent.fromCode((String)channelPayloadContentExtension.getValue().primitiveValue());
            }
            topicSubscription.setContent(payloadContent);
        } else {
            retVal.setCriteriaString(this.getCriteria(theSubscription));
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
            String subjectTemplate;
            String from;
            try {
                from = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                subjectTemplate = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)561) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getEmailDetails().setFrom(from);
            retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String deliverLatestVersion;
            String stripVersionIds;
            try {
                stripVersionIds = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                deliverLatestVersion = channel.getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)562) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
            retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
        }
        if (!(topicExts = subscription.getExtensionsByUrl("http://hl7.org/fhir/subscription/topics")).isEmpty() && !"EventDefinition".equals((ref = (IBaseReference)((Extension)topicExts.get(0)).getValueAsPrimitive()).getReferenceElement().getResourceType())) {
            throw new PreconditionFailedException(Msg.code((int)563) + "Topic reference must be an EventDefinition");
        }
        Extension extension = channel.getExtensionByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages");
        if (extension != null && extension.hasValue() && extension.getValue() instanceof BooleanType) {
            retVal.setSendDeleteMessages(((BooleanType)extension.getValue()).booleanValue());
        }
        return retVal;
    }

    private CanonicalSubscription canonicalizeR4B(IBaseResource theSubscription) {
        IBaseReference ref;
        List topicExts;
        org.hl7.fhir.r4b.model.Subscription subscription = (org.hl7.fhir.r4b.model.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        Enumerations.SubscriptionStatus status = subscription.getStatus();
        if (status != null) {
            retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)status.toCode()));
        }
        this.setPartitionIdOnReturnValue(theSubscription, retVal);
        Subscription.SubscriptionChannelComponent channel = subscription.getChannel();
        retVal.setHeaders(channel.getHeader());
        retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
        retVal.setIdElement((IIdType)subscription.getIdElement());
        retVal.setPayloadString(channel.getPayload());
        retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
        retVal.setTags(this.extractTags((IBaseResource)subscription));
        List profiles = subscription.getMeta().getProfile();
        for (CanonicalType next : profiles) {
            if (!"http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-subscription".equals(next.getValueAsString())) continue;
            retVal.setTopicSubscription(true);
        }
        if (retVal.isTopicSubscription()) {
            CanonicalTopicSubscription topicSubscription = retVal.getTopicSubscription();
            topicSubscription.setTopic(this.getCriteria(theSubscription));
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
            Subscription.SubscriptionPayloadContent payloadContent = Subscription.SubscriptionPayloadContent.FULLRESOURCE;
            org.hl7.fhir.r4b.model.Extension channelPayloadContentExtension = channel.getPayloadElement().getExtensionByUrl("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-payload-content");
            if (Objects.nonNull(channelPayloadContentExtension)) {
                payloadContent = Subscription.SubscriptionPayloadContent.fromCode((String)channelPayloadContentExtension.getValue().primitiveValue());
            }
            topicSubscription.setContent(payloadContent);
        } else {
            retVal.setCriteriaString(this.getCriteria(theSubscription));
            retVal.setEndpointUrl(channel.getEndpoint());
            retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
            String subjectTemplate;
            String from;
            try {
                from = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                subjectTemplate = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)564) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getEmailDetails().setFrom(from);
            retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String deliverLatestVersion;
            String stripVersionIds;
            try {
                stripVersionIds = this.getExtensionString((IBaseHasExtensions)channel, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                deliverLatestVersion = this.getExtensionString((IBaseHasExtensions)channel, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)565) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
            retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
        }
        if (!(topicExts = subscription.getExtensionsByUrl("http://hl7.org/fhir/subscription/topics")).isEmpty() && !"EventDefinition".equals((ref = (IBaseReference)((org.hl7.fhir.r4b.model.Extension)topicExts.get(0)).getValueAsPrimitive()).getReferenceElement().getResourceType())) {
            throw new PreconditionFailedException(Msg.code((int)566) + "Topic reference must be an EventDefinition");
        }
        org.hl7.fhir.r4b.model.Extension extension = channel.getExtensionByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages");
        if (extension != null && extension.hasValue() && extension.hasValueBooleanType()) {
            retVal.setSendDeleteMessages(extension.getValueBooleanType().booleanValue());
        }
        retVal.setCrossPartitionEnabled(this.handleCrossPartition(theSubscription));
        return retVal;
    }

    private CanonicalSubscription canonicalizeR5(IBaseResource theSubscription) {
        IBaseReference ref;
        org.hl7.fhir.r5.model.Subscription subscription = (org.hl7.fhir.r5.model.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        this.setPartitionIdOnReturnValue(theSubscription, retVal);
        retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
        retVal.setIdElement((IIdType)subscription.getIdElement());
        retVal.setPayloadString(subscription.getContentType());
        retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
        retVal.setTags(this.extractTags((IBaseResource)subscription));
        List topicExts = subscription.getExtensionsByUrl("http://hl7.org/fhir/subscription/topics");
        if (!topicExts.isEmpty() && !"EventDefinition".equals((ref = (IBaseReference)((org.hl7.fhir.r5.model.Extension)topicExts.get(0)).getValueAsPrimitive()).getReferenceElement().getResourceType())) {
            throw new PreconditionFailedException(Msg.code((int)2325) + "Topic reference must be an EventDefinition");
        }
        retVal.setTopicSubscription(true);
        Enumerations.SubscriptionStatusCodes status = subscription.getStatus();
        if (status != null) {
            switch (status) {
                case REQUESTED: {
                    retVal.setStatus(Subscription.SubscriptionStatus.REQUESTED);
                    break;
                }
                case ACTIVE: {
                    retVal.setStatus(Subscription.SubscriptionStatus.ACTIVE);
                    break;
                }
                case ERROR: {
                    retVal.setStatus(Subscription.SubscriptionStatus.ERROR);
                    break;
                }
                case OFF: {
                    retVal.setStatus(Subscription.SubscriptionStatus.OFF);
                    break;
                }
                default: {
                    ourLog.warn("Converting R5 Subscription status from {} to ERROR", (Object)status);
                    retVal.setStatus(Subscription.SubscriptionStatus.ERROR);
                }
            }
        }
        retVal.getTopicSubscription().setContent(subscription.getContent());
        retVal.setEndpointUrl(subscription.getEndpoint());
        retVal.getTopicSubscription().setTopic(subscription.getTopic());
        retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
        subscription.getFilterBy().forEach(filter -> retVal.getTopicSubscription().addFilter(this.convertFilter((Subscription.SubscriptionFilterByComponent)filter)));
        retVal.getTopicSubscription().setHeartbeatPeriod(subscription.getHeartbeatPeriod());
        retVal.getTopicSubscription().setMaxCount(subscription.getMaxCount());
        this.setR5FlagsBasedOnChannelType(subscription, retVal);
        retVal.setCrossPartitionEnabled(this.handleCrossPartition(theSubscription));
        return retVal;
    }

    private void setR5FlagsBasedOnChannelType(org.hl7.fhir.r5.model.Subscription subscription, CanonicalSubscription retVal) {
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
            String subjectTemplate;
            String from;
            try {
                from = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                subjectTemplate = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)2323) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getEmailDetails().setFrom(from);
            retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String deliverLatestVersion;
            String stripVersionIds;
            try {
                stripVersionIds = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                deliverLatestVersion = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)2324) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
            retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
        }
    }

    private CanonicalTopicSubscriptionFilter convertFilter(Subscription.SubscriptionFilterByComponent theFilter) {
        CanonicalTopicSubscriptionFilter retVal = new CanonicalTopicSubscriptionFilter();
        retVal.setResourceType(theFilter.getResourceType());
        retVal.setFilterParameter(theFilter.getFilterParameter());
        retVal.setModifier(theFilter.getModifier());
        retVal.setComparator(theFilter.getComparator());
        retVal.setValue(theFilter.getValue());
        return retVal;
    }

    private void setPartitionIdOnReturnValue(IBaseResource theSubscription, CanonicalSubscription retVal) {
        RequestPartitionId requestPartitionId = (RequestPartitionId)theSubscription.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (requestPartitionId != null) {
            retVal.setPartitionId(requestPartitionId.getFirstPartitionIdOrNull());
        }
    }

    private String getExtensionString(IBaseHasExtensions theBase, String theUrl) {
        return theBase.getExtension().stream().filter(t -> theUrl.equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(t -> t.getValueAsString()).findFirst().orElse(null);
    }

    public CanonicalSubscriptionChannelType getChannelType(IBaseResource theSubscription) {
        CanonicalSubscriptionChannelType retVal = null;
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                String channelTypeCode = ((ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription).getChannel().getType();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case DSTU3: {
                Subscription.SubscriptionChannelType type = ((org.hl7.fhir.dstu3.model.Subscription)theSubscription).getChannel().getType();
                if (type == null) break;
                String channelTypeCode = type.toCode();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case R4: {
                Subscription.SubscriptionChannelType type = ((Subscription)theSubscription).getChannel().getType();
                if (type == null) break;
                String channelTypeCode = type.toCode();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case R4B: {
                Subscription.SubscriptionChannelType type = ((org.hl7.fhir.r4b.model.Subscription)theSubscription).getChannel().getType();
                if (type == null) break;
                String channelTypeCode = type.toCode();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case R5: {
                Coding nextTypeCode = ((org.hl7.fhir.r5.model.Subscription)theSubscription).getChannelType();
                CanonicalSubscriptionChannelType code = CanonicalSubscriptionChannelType.fromCode(nextTypeCode.getSystem(), nextTypeCode.getCode());
                if (code == null) break;
                retVal = code;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)2326) + "Unsupported Subscription FHIR version: " + String.valueOf(this.myFhirContext.getVersion().getVersion()));
            }
        }
        return retVal;
    }

    @Nullable
    public String getCriteria(IBaseResource theSubscription) {
        String retVal = null;
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                retVal = ((ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription).getCriteria();
                break;
            }
            case DSTU3: {
                retVal = ((org.hl7.fhir.dstu3.model.Subscription)theSubscription).getCriteria();
                break;
            }
            case R4: {
                retVal = ((Subscription)theSubscription).getCriteria();
                break;
            }
            case R4B: {
                retVal = ((org.hl7.fhir.r4b.model.Subscription)theSubscription).getCriteria();
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)2327) + "Subscription criteria is not supported for FHIR version: " + String.valueOf(this.myFhirContext.getVersion().getVersion()));
            }
        }
        return retVal;
    }

    public void setMatchingStrategyTag(@Nonnull IBaseResource theSubscription, @Nullable SubscriptionMatchingStrategy theStrategy) {
        String display;
        IBaseMetaType meta = theSubscription.getMeta();
        meta.getTag().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/subscription-matching-strategy".equals(t.getSystem())).forEach(t -> {
            t.setCode(null);
            t.setSystem(null);
            t.setDisplay(null);
        });
        if (theStrategy == null) {
            return;
        }
        String value = theStrategy.toString();
        if (theStrategy == SubscriptionMatchingStrategy.DATABASE) {
            display = "Database";
        } else if (theStrategy == SubscriptionMatchingStrategy.IN_MEMORY) {
            display = "In-memory";
        } else if (theStrategy == SubscriptionMatchingStrategy.TOPIC) {
            display = "SubscriptionTopic";
        } else {
            throw new IllegalStateException(Msg.code((int)567) + "Unknown " + SubscriptionMatchingStrategy.class.getSimpleName() + ": " + String.valueOf((Object)theStrategy));
        }
        meta.addTag().setSystem("http://hapifhir.io/fhir/StructureDefinition/subscription-matching-strategy").setCode(value).setDisplay(display);
    }

    public String getSubscriptionStatus(IBaseResource theSubscription) {
        IPrimitiveType status = (IPrimitiveType)this.myFhirContext.newTerser().getSingleValueOrNull((IBase)theSubscription, "Subscription.status", IPrimitiveType.class);
        if (status == null) {
            return null;
        }
        return status.getValueAsString();
    }

    protected Integer getDefaultPartitionId() {
        if (this.myPartitionSettings != null) {
            return this.myPartitionSettings.getDefaultPartitionId();
        }
        ourLog.warn("No partition settings available.");
        return null;
    }

    private boolean handleCrossPartition(IBaseResource theSubscription) {
        RequestPartitionId requestPartitionId = (RequestPartitionId)theSubscription.getUserData(Constants.RESOURCE_PARTITION_ID);
        boolean isSubscriptionCreatedOnDefaultPartition = false;
        if (Objects.nonNull(requestPartitionId)) {
            isSubscriptionCreatedOnDefaultPartition = this.myHelperSvc == null ? requestPartitionId.isPartition(this.getDefaultPartitionId()) : this.myHelperSvc.isDefaultPartition(requestPartitionId);
        }
        boolean isSubscriptionDefinededAsCrossPartitionSubscription = SubscriptionUtil.isDefinedAsCrossPartitionSubcription((IBaseResource)theSubscription);
        boolean isGlobalSettingCrossPartitionSubscriptionEnabled = this.mySubscriptionSettings.isCrossPartitionSubscriptionEnabled();
        return isSubscriptionCreatedOnDefaultPartition && isSubscriptionDefinededAsCrossPartitionSubscription && isGlobalSettingCrossPartitionSubscriptionEnabled;
    }
}

