/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.CanonicalTopicSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalTopicSubscriptionFilter;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r5.model.Subscription;

public class CanonicalSubscription
implements Serializable,
Cloneable,
IModelJson {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String myIdElement;
    @JsonProperty(value="criteria")
    private String myCriteriaString;
    @JsonProperty(value="endpointUrl")
    private String myEndpointUrl;
    @JsonProperty(value="payload")
    private String myPayloadString;
    @JsonProperty(value="headers")
    private List<String> myHeaders;
    @JsonProperty(value="channelType")
    private CanonicalSubscriptionChannelType myChannelType;
    @JsonProperty(value="status")
    private Subscription.SubscriptionStatus myStatus;
    @JsonProperty(value="triggerDefinition")
    @Deprecated
    private CanonicalEventDefinition myTrigger;
    @JsonProperty(value="emailDetails")
    private EmailDetails myEmailDetails;
    @JsonProperty(value="restHookDetails")
    private RestHookDetails myRestHookDetails;
    @JsonProperty(value="extensions")
    private Map<String, List<String>> myChannelExtensions;
    @JsonProperty(value="tags")
    private Map<String, String> myTags;
    @JsonProperty(value="payloadSearchCriteria")
    private String myPayloadSearchCriteria;
    @JsonProperty(value="partitionId")
    private Integer myPartitionId;
    @JsonProperty(value="crossPartitionEnabled")
    private boolean myCrossPartitionEnabled;
    @JsonProperty(value="sendDeleteMessages")
    private boolean mySendDeleteMessages;
    @JsonProperty(value="isTopicSubscription")
    private boolean myIsTopicSubscription;
    @JsonProperty(value="myTopicSubscription")
    private CanonicalTopicSubscription myTopicSubscription;

    public String getPayloadSearchCriteria() {
        return this.myPayloadSearchCriteria;
    }

    public void setPayloadSearchCriteria(String thePayloadSearchCriteria) {
        this.myPayloadSearchCriteria = thePayloadSearchCriteria;
    }

    @Deprecated
    public void addTrigger(CanonicalEventDefinition theTrigger) {
        this.myTrigger = theTrigger;
    }

    public CanonicalSubscriptionChannelType getChannelType() {
        return this.myChannelType;
    }

    public void setChannelType(CanonicalSubscriptionChannelType theChannelType) {
        this.myChannelType = theChannelType;
    }

    public String getCriteriaString() {
        return this.myCriteriaString;
    }

    public void setCriteriaString(String theCriteriaString) {
        this.myCriteriaString = theCriteriaString;
    }

    public EmailDetails getEmailDetails() {
        if (this.myEmailDetails == null) {
            this.myEmailDetails = new EmailDetails();
        }
        return this.myEmailDetails;
    }

    public String getEndpointUrl() {
        return this.myEndpointUrl;
    }

    public void setEndpointUrl(String theEndpointUrl) {
        this.myEndpointUrl = theEndpointUrl;
    }

    @Nonnull
    public List<String> getHeaders() {
        return this.myHeaders != null ? Collections.unmodifiableList(this.myHeaders) : Collections.emptyList();
    }

    public void setHeaders(List<? extends IPrimitiveType<String>> theHeader) {
        this.myHeaders = new ArrayList<String>();
        for (IPrimitiveType<String> iPrimitiveType : theHeader) {
            if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValueAsString())) continue;
            this.myHeaders.add(iPrimitiveType.getValueAsString());
        }
    }

    public void setHeaders(String theHeaders) {
        this.myHeaders = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)theHeaders)) {
            this.myHeaders.add(theHeaders);
        }
    }

    public Map<String, String> getTags() {
        if (this.myTags == null) {
            this.myTags = new HashMap<String, String>();
        }
        return this.myTags;
    }

    public void setTags(Map<String, String> theTags) {
        this.myTags = theTags;
    }

    public String getChannelExtension(String theUrl) {
        String retVal = null;
        List<String> channelExtensions = this.myChannelExtensions.get(theUrl);
        if (channelExtensions != null && !channelExtensions.isEmpty()) {
            retVal = channelExtensions.get(0);
        }
        return retVal;
    }

    @Nonnull
    public List<String> getChannelExtensions(String theUrl) {
        List<String> retVal = this.myChannelExtensions.get(theUrl);
        retVal = retVal == null ? Collections.emptyList() : Collections.unmodifiableList(retVal);
        return retVal;
    }

    public void setChannelExtensions(Map<String, List<String>> theChannelExtensions) {
        this.myChannelExtensions = new HashMap<String, List<String>>();
        for (String url : theChannelExtensions.keySet()) {
            List<String> values = theChannelExtensions.get(url);
            if (!StringUtils.isNotBlank((CharSequence)url) || values == null) continue;
            this.myChannelExtensions.put(url, values);
        }
    }

    @Nullable
    public IIdType getIdElement(FhirContext theContext) {
        IIdType retVal = null;
        if (StringUtils.isNotBlank((CharSequence)this.myIdElement)) {
            retVal = theContext.getVersion().newIdType().setValue(this.myIdElement);
        }
        return retVal;
    }

    public String getIdPart() {
        return new IdType(this.getIdElementString()).getIdPart();
    }

    public String getIdElementString() {
        return this.myIdElement;
    }

    public String getPayloadString() {
        return this.myPayloadString;
    }

    public void setPayloadString(String thePayloadString) {
        this.myPayloadString = thePayloadString;
    }

    public RestHookDetails getRestHookDetails() {
        if (this.myRestHookDetails == null) {
            this.myRestHookDetails = new RestHookDetails();
        }
        return this.myRestHookDetails;
    }

    public Subscription.SubscriptionStatus getStatus() {
        return this.myStatus;
    }

    public void setStatus(Subscription.SubscriptionStatus theStatus) {
        this.myStatus = theStatus;
    }

    public Integer getRequestPartitionId() {
        return this.myPartitionId;
    }

    public void setPartitionId(Integer thePartitionId) {
        this.myPartitionId = thePartitionId;
    }

    public boolean isCrossPartitionEnabled() {
        return this.myCrossPartitionEnabled;
    }

    public void setCrossPartitionEnabled(boolean myCrossPartitionEnabled) {
        this.myCrossPartitionEnabled = myCrossPartitionEnabled;
    }

    @Deprecated
    public CanonicalEventDefinition getTrigger() {
        return this.myTrigger;
    }

    public boolean getSendDeleteMessages() {
        return this.mySendDeleteMessages;
    }

    public void setSendDeleteMessages(boolean theSendDeleteMessages) {
        this.mySendDeleteMessages = theSendDeleteMessages;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        CanonicalSubscription that = (CanonicalSubscription)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myIdElement, (Object)that.myIdElement);
        b.append((Object)this.myCriteriaString, (Object)that.myCriteriaString);
        b.append((Object)this.myEndpointUrl, (Object)that.myEndpointUrl);
        b.append((Object)this.myPayloadString, (Object)that.myPayloadString);
        b.append(this.myHeaders, that.myHeaders);
        b.append((Object)this.myChannelType, (Object)that.myChannelType);
        b.append((Object)this.myStatus, (Object)that.myStatus);
        b.append((Object)this.myTrigger, (Object)that.myTrigger);
        b.append((Object)this.myEmailDetails, (Object)that.myEmailDetails);
        b.append((Object)this.myRestHookDetails, (Object)that.myRestHookDetails);
        b.append(this.myChannelExtensions, that.myChannelExtensions);
        b.append(this.myCrossPartitionEnabled, that.myCrossPartitionEnabled);
        b.append(this.myChannelExtensions, that.myChannelExtensions);
        b.append(this.mySendDeleteMessages, that.mySendDeleteMessages);
        b.append((Object)this.myPayloadSearchCriteria, (Object)that.myPayloadSearchCriteria);
        b.append((Object)this.myTopicSubscription, (Object)that.myTopicSubscription);
        return b.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myIdElement).append((Object)this.myCriteriaString).append((Object)this.myEndpointUrl).append((Object)this.myPayloadString).append(this.myHeaders).append((Object)this.myChannelType).append((Object)this.myStatus).append((Object)this.myTrigger).append((Object)this.myEmailDetails).append((Object)this.myRestHookDetails).append(this.myChannelExtensions).toHashCode();
    }

    public void setIdElement(IIdType theIdElement) {
        this.myIdElement = null;
        if (theIdElement != null) {
            this.myIdElement = theIdElement.toUnqualifiedVersionless().getValue();
        }
    }

    public void addHeader(String theHeader) {
        if (StringUtils.isNotBlank((CharSequence)theHeader)) {
            this.initHeaders();
            this.myHeaders.add(theHeader);
        }
    }

    private void initHeaders() {
        if (this.myHeaders == null) {
            this.myHeaders = new ArrayList<String>();
        }
    }

    public String toString() {
        ToStringBuilder stringBuilder = new ToStringBuilder((Object)this).append("myIdElement", (Object)this.myIdElement).append("myStatus", (Object)this.myStatus).append("myCriteriaString", (Object)this.myCriteriaString);
        if (this.isTopicSubscription()) {
            stringBuilder.append("topic", (Object)this.myTopicSubscription.getTopic());
        } else {
            stringBuilder.append("criteriaString", (Object)this.myCriteriaString);
        }
        return stringBuilder.toString();
    }

    public void setTopicSubscription(boolean theTopicSubscription) {
        this.myIsTopicSubscription = theTopicSubscription;
    }

    public boolean isTopicSubscription() {
        return this.myIsTopicSubscription;
    }

    public String getContentType() {
        assert (this.isTopicSubscription());
        return this.getPayloadString();
    }

    public CanonicalTopicSubscription getTopicSubscription() {
        assert (this.isTopicSubscription());
        if (this.myTopicSubscription == null) {
            this.myTopicSubscription = new CanonicalTopicSubscription();
        }
        return this.myTopicSubscription;
    }

    public void setTopicSubscription(CanonicalTopicSubscription theTopicSubscription) {
        this.myTopicSubscription = theTopicSubscription;
    }

    public Subscription.SubscriptionPayloadContent getContent() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getContent();
    }

    public String getTopic() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getTopic();
    }

    public List<CanonicalTopicSubscriptionFilter> getFilters() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getFilters();
    }

    public int getHeartbeatPeriod() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getHeartbeatPeriod();
    }

    public int getTimeout() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getTimeout();
    }

    public int getMaxCount() {
        assert (this.isTopicSubscription());
        return this.myTopicSubscription.getMaxCount();
    }

    @Deprecated
    public static class CanonicalEventDefinition
    implements IModelJson {
        @Deprecated
        public CanonicalEventDefinition() {
        }
    }

    public static class EmailDetails
    implements IModelJson {
        @JsonProperty(value="from")
        private String myFrom;
        @JsonProperty(value="subjectTemplate")
        private String mySubjectTemplate;

        public String getFrom() {
            return this.myFrom;
        }

        public void setFrom(String theFrom) {
            this.myFrom = theFrom;
        }

        public String getSubjectTemplate() {
            return this.mySubjectTemplate;
        }

        public void setSubjectTemplate(String theSubjectTemplate) {
            this.mySubjectTemplate = theSubjectTemplate;
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            EmailDetails that = (EmailDetails)theO;
            return new EqualsBuilder().append((Object)this.myFrom, (Object)that.myFrom).append((Object)this.mySubjectTemplate, (Object)that.mySubjectTemplate).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.myFrom).append((Object)this.mySubjectTemplate).toHashCode();
        }
    }

    public static class RestHookDetails
    implements IModelJson {
        @JsonProperty(value="stripVersionId")
        private boolean myStripVersionId;
        @JsonProperty(value="deliverLatestVersion")
        private boolean myDeliverLatestVersion;

        public boolean isDeliverLatestVersion() {
            return this.myDeliverLatestVersion;
        }

        public void setDeliverLatestVersion(boolean theDeliverLatestVersion) {
            this.myDeliverLatestVersion = theDeliverLatestVersion;
        }

        public boolean isStripVersionId() {
            return this.myStripVersionId;
        }

        public void setStripVersionId(boolean theStripVersionId) {
            this.myStripVersionId = theStripVersionId;
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            RestHookDetails that = (RestHookDetails)theO;
            return new EqualsBuilder().append(this.myStripVersionId, that.myStripVersionId).append(this.myDeliverLatestVersion, that.myDeliverLatestVersion).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.myStripVersionId).append(this.myDeliverLatestVersion).toHashCode();
        }
    }
}

