/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.UrlUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Subscription;
import org.slf4j.Logger;

public class CanonicalTopicSubscriptionFilter {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    @JsonProperty(value="resourceType")
    String myResourceType;
    @JsonProperty(value="filterParameter")
    String myFilterParameter;
    @JsonProperty(value="comparator")
    Enumerations.SearchComparator myComparator;
    @JsonProperty(value="modifier")
    Enumerations.SearchModifierCode myModifier;
    @JsonProperty(value="value")
    String myValue;

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public String getFilterParameter() {
        return this.myFilterParameter;
    }

    public void setFilterParameter(String theFilterParameter) {
        this.myFilterParameter = theFilterParameter;
    }

    public Enumerations.SearchComparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(Enumerations.SearchComparator theComparator) {
        this.myComparator = theComparator;
    }

    public Enumerations.SearchModifierCode getModifier() {
        return this.myModifier;
    }

    public void setModifier(Enumerations.SearchModifierCode theModifier) {
        this.myModifier = theModifier;
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String theValue) {
        this.myValue = theValue;
    }

    public static List<CanonicalTopicSubscriptionFilter> fromQueryUrl(String theQueryUrl) {
        UrlUtil.UrlParts urlParts = UrlUtil.parseUrl((String)theQueryUrl);
        String resourceName = urlParts.getResourceType();
        Map params = UrlUtil.parseQueryString((String)urlParts.getParams());
        ArrayList<CanonicalTopicSubscriptionFilter> retval = new ArrayList<CanonicalTopicSubscriptionFilter>();
        params.forEach((key, valueList) -> {
            for (String value : valueList) {
                CanonicalTopicSubscriptionFilter filter = new CanonicalTopicSubscriptionFilter();
                filter.setResourceType(resourceName);
                filter.setFilterParameter((String)key);
                filter.setComparator(Enumerations.SearchComparator.EQ);
                filter.setValue(value);
                retval.add(filter);
            }
        });
        return retval;
    }

    public Subscription.SubscriptionFilterByComponent toSubscriptionFilterByComponent() {
        Subscription.SubscriptionFilterByComponent retval = new Subscription.SubscriptionFilterByComponent();
        retval.setResourceType(this.myResourceType);
        retval.setFilterParameter(this.myFilterParameter);
        retval.setComparator(this.myComparator);
        retval.setModifier(this.myModifier);
        retval.setValue(this.myValue);
        return retval;
    }

    public String asCriteriaString() {
        String comparator = "=";
        if (this.myComparator != null) {
            switch (this.myComparator) {
                case EQ: {
                    comparator = "=";
                    break;
                }
                case NE: {
                    comparator = ":not=";
                    break;
                }
                default: {
                    ourLog.warn("Unsupported comparator: {}", (Object)this.myComparator);
                }
            }
        }
        return this.myResourceType + "?" + this.myFilterParameter + comparator + this.myValue;
    }
}

