/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IResourceMessage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceDeliveryMessage
extends BaseResourceMessage
implements IResourceMessage {
    @JsonProperty(value="canonicalSubscription")
    private CanonicalSubscription mySubscription;
    @JsonProperty(value="partitionId")
    private RequestPartitionId myPartitionId = RequestPartitionId.defaultPartition();
    @JsonProperty(value="payload")
    private String myPayloadString;
    @JsonProperty(value="payloadId")
    private String myPayloadId;
    @JsonIgnore
    private transient IBaseResource myPayloadDecoded;

    public IBaseResource getPayload(FhirContext theCtx) {
        IBaseResource retVal = this.myPayloadDecoded;
        if (retVal == null && StringUtils.isNotBlank((CharSequence)this.myPayloadString)) {
            IParser parser = EncodingEnum.detectEncoding((String)this.myPayloadString).newParser(theCtx);
            this.myPayloadDecoded = retVal = parser.parseResource(this.myPayloadString);
        }
        return retVal;
    }

    public String getPayloadString() {
        if (this.myPayloadString != null) {
            return this.myPayloadString;
        }
        return "";
    }

    public IIdType getPayloadId(FhirContext theCtx) {
        IIdType retVal = null;
        if (this.myPayloadId != null) {
            retVal = theCtx.getVersion().newIdType().setValue(this.myPayloadId);
        }
        return retVal;
    }

    public CanonicalSubscription getSubscription() {
        return this.mySubscription;
    }

    public void setSubscription(CanonicalSubscription theSubscription) {
        this.mySubscription = theSubscription;
    }

    public void setPayload(FhirContext theCtx, IBaseResource thePayload, EncodingEnum theEncoding) {
        this.myPayloadString = theEncoding.newParser(theCtx).encodeResourceToString(thePayload);
        this.myPayloadId = thePayload.getIdElement().toUnqualifiedVersionless().getValue();
    }

    public void setPayloadToNull() {
        this.myPayloadString = null;
    }

    public String getPayloadId() {
        return this.myPayloadId;
    }

    public void setPayloadId(IIdType thePayloadId) {
        this.myPayloadId = null;
        if (thePayloadId != null) {
            this.myPayloadId = thePayloadId.getValue();
        }
    }

    public RequestPartitionId getPartitionId() {
        return this.myPartitionId;
    }

    public void setPartitionId(RequestPartitionId thePartitionId) {
        this.myPartitionId = thePartitionId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mySubscription", (Object)(this.mySubscription == null ? "null" : this.mySubscription.getIdElementString())).append("myPayloadString", (Object)"[Not Logged]").append("myPayload", (Object)this.myPayloadDecoded).append("myPayloadId", (Object)this.myPayloadId).append("myPartitionId", (Object)this.myPartitionId).append("myOperationType", (Object)this.getOperationType()).toString();
    }

    public String getSubscriptionId(FhirContext theFhirContext) {
        IIdType idElement;
        String retVal = null;
        if (this.getSubscription() != null && (idElement = this.getSubscription().getIdElement(theFhirContext)) != null) {
            retVal = idElement.getValue();
        }
        return retVal;
    }

    @Nullable
    public String getPayloadMessageKey() {
        return Objects.toString(super.getPayloadMessageKey(), this.myPayloadId);
    }
}

