/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.api;

import ca.uhn.fhir.jpa.term.UploadStatistics;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public interface ITermLoaderSvc {
    public static final String IMGTHLA_URI = "http://www.ebi.ac.uk/ipd/imgt/hla";
    public static final String LOINC_URI = "http://loinc.org";
    public static final String SCT_URI = "http://snomed.info/sct";
    public static final String ICD10_URI = "http://hl7.org/fhir/sid/icd-10";
    public static final String ICD10CM_URI = "http://hl7.org/fhir/sid/icd-10-cm";
    public static final String IEEE_11073_10101_URI = "urn:iso:std:iso:11073:10101";

    public UploadStatistics loadImgthla(List<FileDescriptor> var1, RequestDetails var2);

    public UploadStatistics loadLoinc(List<FileDescriptor> var1, RequestDetails var2);

    public UploadStatistics loadSnomedCt(List<FileDescriptor> var1, RequestDetails var2);

    default public UploadStatistics loadIcd10(List<FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        return null;
    }

    public UploadStatistics loadIcd10cm(List<FileDescriptor> var1, RequestDetails var2);

    public UploadStatistics loadCustom(String var1, List<FileDescriptor> var2, RequestDetails var3);

    public UploadStatistics loadDeltaAdd(String var1, List<FileDescriptor> var2, RequestDetails var3);

    public UploadStatistics loadDeltaRemove(String var1, List<FileDescriptor> var2, RequestDetails var3);

    public static class ByteArrayFileDescriptor
    implements FileDescriptor {
        private final String myNextUrl;
        private final byte[] myNextData;

        public ByteArrayFileDescriptor(String theNextUrl, byte[] theNextData) {
            this.myNextUrl = theNextUrl;
            this.myNextData = theNextData;
        }

        @Override
        public String getFilename() {
            return this.myNextUrl;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.myNextData);
        }
    }

    public static interface FileDescriptor {
        public String getFilename();

        public InputStream getInputStream();
    }
}

