/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.util.SqlQuery;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCaptureQueriesListener
implements ProxyDataSourceBuilder.SingleQueryExecution,
ProxyDataSourceBuilder.SingleMethodExecution {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseCaptureQueriesListener.class);
    private boolean myCaptureQueryStackTrace = false;

    public boolean isCaptureQueryStackTrace() {
        return this.myCaptureQueryStackTrace;
    }

    public void setCaptureQueryStackTrace(boolean theCaptureQueryStackTrace) {
        this.myCaptureQueryStackTrace = theCaptureQueryStackTrace;
    }

    public void execute(ExecutionInfo theExecutionInfo, List<QueryInfo> theQueryInfoList) {
        Queue<SqlQuery> queryList = this.provideQueryList();
        if (queryList == null) {
            return;
        }
        RequestPartitionId requestPartitionId = HapiTransactionService.getRequestPartitionAssociatedWithThread();
        for (QueryInfo next : theQueryInfoList) {
            List<String> params;
            int size;
            String sql = StringUtils.trim((String)next.getQuery());
            if (next.getParametersList().size() > 0 && ((List)next.getParametersList().get(0)).size() > 0) {
                size = next.getParametersList().size();
                List values = (List)next.getParametersList().get(0);
                params = new ArrayList();
                for (ParameterSetOperation t : values) {
                    if (t.getMethod().getName().equals("setNull")) {
                        params.add(null);
                        continue;
                    }
                    Object arg = t.getArgs()[1];
                    String s = arg != null ? arg.toString() : null;
                    params.add(s);
                }
            } else {
                params = Collections.emptyList();
                size = next.getParametersList().size();
            }
            StackTraceElement[] stackTraceElements = null;
            if (this.isCaptureQueryStackTrace()) {
                stackTraceElements = Thread.currentThread().getStackTrace();
            }
            long elapsedTime = theExecutionInfo.getElapsedTime();
            long startTime = System.currentTimeMillis() - elapsedTime;
            SqlQuery sqlQuery = new SqlQuery(sql, params, startTime, elapsedTime, stackTraceElements, size, requestPartitionId);
            queryList.add(sqlQuery);
        }
    }

    protected abstract Queue<SqlQuery> provideQueryList();

    @Nullable
    protected abstract AtomicInteger provideCommitCounter();

    @Nullable
    protected abstract AtomicInteger provideGetConnectionCounter();

    @Nullable
    protected abstract AtomicInteger provideRollbackCounter();

    public void execute(MethodExecutionContext executionContext) {
        AtomicInteger counter = null;
        switch (executionContext.getMethod().getName()) {
            case "commit": {
                counter = this.provideCommitCounter();
                break;
            }
            case "rollback": {
                counter = this.provideRollbackCounter();
                break;
            }
            case "getConnection": {
                counter = this.provideGetConnectionCounter();
            }
        }
        if (counter != null) {
            counter.incrementAndGet();
        }
    }

    public int countGetConnections() {
        return this.provideGetConnectionCounter().get();
    }

    public int countCommits() {
        return this.provideCommitCounter().get();
    }

    public int countRollbacks() {
        return this.provideRollbackCounter().get();
    }
}

