/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MemoryCacheService {
    private final JpaStorageSettings myStorageSettings;
    private final EnumMap<CacheEnum, Cache<?, ?>> myCaches = new EnumMap(CacheEnum.class);

    public MemoryCacheService(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
        this.populateCaches();
    }

    private void populateCaches() {
        for (CacheEnum next : CacheEnum.values()) {
            this.myCaches.put(next, switch (next) {
                case CacheEnum.RES_TYPE_TO_RES_TYPE_ID -> CacheFactory.buildEternal((int)250, (long)500L);
                case CacheEnum.HASH_IDENTITY_TO_SEARCH_PARAM_IDENTITY -> CacheFactory.buildEternal((int)5000, (long)50000L);
                default -> {
                    long timeoutSeconds = TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES);
                    int maximumSize = 10000;
                    if (this.myStorageSettings.isMassIngestionMode()) {
                        timeoutSeconds = TimeUnit.SECONDS.convert(50L, TimeUnit.MINUTES);
                        maximumSize = 100000;
                    }
                    yield CacheFactory.build((long)TimeUnit.SECONDS.toMillis(timeoutSeconds), (long)maximumSize);
                }
            });
        }
    }

    public <K, T> T get(CacheEnum theCache, K theKey, Function<K, T> theSupplier) {
        assert (theCache.getKeyType().isAssignableFrom(theKey.getClass()));
        return this.doGet(theCache, theKey, theSupplier);
    }

    protected <K, T> T doGet(CacheEnum theCache, K theKey, Function<K, T> theSupplier) {
        Cache<K, T> cache = this.getCache(theCache);
        return (T)cache.get(theKey, theSupplier);
    }

    public <K, T> T getThenPutAfterCommit(CacheEnum theCache, K theKey, Function<K, T> theSupplier) {
        assert (theCache.getKeyType().isAssignableFrom(theKey.getClass()));
        Object retVal = this.getIfPresent(theCache, theKey);
        if (retVal == null) {
            retVal = theSupplier.apply(theKey);
            this.putAfterCommit(theCache, theKey, retVal);
        }
        return (T)retVal;
    }

    public <K, V> V getIfPresent(CacheEnum theCache, K theKey) {
        assert (theCache.getKeyType().isAssignableFrom(theKey.getClass()));
        return this.doGetIfPresent(theCache, theKey);
    }

    protected <K, V> V doGetIfPresent(CacheEnum theCache, K theKey) {
        return (V)this.getCache(theCache).getIfPresent(theKey);
    }

    public <K, V> void put(CacheEnum theCache, K theKey, V theValue) {
        assert (theCache.getKeyType().isAssignableFrom(theKey.getClass())) : "Key type " + String.valueOf(theKey.getClass()) + " doesn't match expected " + String.valueOf(theCache.getKeyType()) + " for cache " + String.valueOf((Object)theCache);
        this.doPut(theCache, theKey, theValue);
    }

    protected <K, V> void doPut(CacheEnum theCache, K theKey, V theValue) {
        this.getCache(theCache).put(theKey, theValue);
    }

    public <K, V> void putAfterCommit(final CacheEnum theCache, final K theKey, final V theValue) {
        assert (theCache.getKeyType().isAssignableFrom(theKey.getClass())) : "Key type " + String.valueOf(theKey.getClass()) + " doesn't match expected " + String.valueOf(theCache.getKeyType()) + " for cache " + String.valueOf((Object)theCache);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    MemoryCacheService.this.put(theCache, theKey, theValue);
                }
            });
        } else {
            this.put(theCache, theKey, theValue);
        }
    }

    public <K, V> Map<K, V> getAllPresent(CacheEnum theCache, Collection<K> theKeys) {
        return this.doGetAllPresent(theCache, theKeys);
    }

    protected <K, V> Map<K, V> doGetAllPresent(CacheEnum theCache, Collection<K> theKeys) {
        return this.getCache(theCache).getAllPresent(theKeys);
    }

    public void invalidateAllCaches() {
        this.myCaches.values().forEach(Cache::invalidateAll);
    }

    private <K, T> Cache<K, T> getCache(CacheEnum theCache) {
        return this.myCaches.get((Object)theCache);
    }

    public long getEstimatedSize(CacheEnum theCache) {
        return this.getCache(theCache).estimatedSize();
    }

    public void invalidateCaches(CacheEnum ... theCaches) {
        for (CacheEnum next : theCaches) {
            this.getCache(next).invalidateAll();
        }
    }

    public static enum CacheEnum {
        TAG_DEFINITION(TagDefinitionCacheKey.class),
        RESOURCE_LOOKUP_BY_FORCED_ID(ForcedIdCacheKey.class),
        FHIRPATH_EXPRESSION(String.class),
        PID_TO_FORCED_ID(JpaPid.class),
        MATCH_URL(String.class),
        RESOURCE_CONDITIONAL_CREATE_VERSION(JpaPid.class),
        HISTORY_COUNT(HistoryCountKey.class),
        NAME_TO_PARTITION(String.class),
        ID_TO_PARTITION(Integer.class),
        HASH_IDENTITY_TO_SEARCH_PARAM_IDENTITY(Long.class),
        RES_TYPE_TO_RES_TYPE_ID(String.class);

        private final Class<?> myKeyType;

        private CacheEnum(Class<?> theKeyType) {
            this.myKeyType = theKeyType;
        }

        public Class<?> getKeyType() {
            return this.myKeyType;
        }
    }

    public static class ForcedIdCacheKey {
        private final String myResourceType;
        private final String myResourceId;
        private final List<Integer> myRequestPartitionIds;
        private final int myHashCode;

        public ForcedIdCacheKey(@Nullable String theResourceType, @Nonnull String theResourceId, @Nonnull RequestPartitionId theRequestPartitionId) {
            this.myResourceType = theResourceType;
            this.myResourceId = theResourceId;
            this.myRequestPartitionIds = theRequestPartitionId.hasPartitionIds() ? theRequestPartitionId.getPartitionIds() : null;
            this.myHashCode = Objects.hash(this.myResourceType, this.myResourceId, this.myRequestPartitionIds);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resType", (Object)this.myResourceType).append("resId", (Object)this.myResourceId).append("partId", this.myRequestPartitionIds).toString();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (!(theO instanceof ForcedIdCacheKey)) {
                return false;
            }
            ForcedIdCacheKey that = (ForcedIdCacheKey)theO;
            return Objects.equals(this.myResourceType, that.myResourceType) && Objects.equals(this.myResourceId, that.myResourceId) && Objects.equals(this.myRequestPartitionIds, that.myRequestPartitionIds);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public IIdType toIdType(FhirContext theFhirCtx) {
            return theFhirCtx.getVersion().newIdType(this.myResourceType, this.myResourceId);
        }
    }

    public static class HistoryCountKey {
        private final String myTypeName;
        private final Long myInstanceId;
        private final Integer myPartitionId;
        private final int myHashCode;

        private HistoryCountKey(@Nullable String theTypeName, @Nullable JpaPid theInstanceId) {
            this.myTypeName = theTypeName;
            if (theInstanceId != null) {
                this.myInstanceId = theInstanceId.getId();
                this.myPartitionId = theInstanceId.getPartitionId();
            } else {
                this.myInstanceId = null;
                this.myPartitionId = null;
            }
            this.myHashCode = new HashCodeBuilder().append((Object)this.myTypeName).append((Object)this.myInstanceId).append((Object)this.myPartitionId).toHashCode();
        }

        public boolean equals(Object theO) {
            boolean retVal = false;
            if (theO instanceof HistoryCountKey) {
                HistoryCountKey that = (HistoryCountKey)theO;
                retVal = new EqualsBuilder().append((Object)this.myTypeName, (Object)that.myTypeName).append((Object)this.myInstanceId, (Object)that.myInstanceId).isEquals();
            }
            return retVal;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public static HistoryCountKey forSystem() {
            return new HistoryCountKey(null, null);
        }

        public static HistoryCountKey forType(@Nonnull String theType) {
            assert (StringUtils.isNotBlank((CharSequence)theType));
            return new HistoryCountKey(theType, null);
        }

        public static HistoryCountKey forInstance(@Nonnull JpaPid theInstanceId) {
            return new HistoryCountKey(null, theInstanceId);
        }
    }

    public static class TagDefinitionCacheKey {
        private final TagTypeEnum myType;
        private final String mySystem;
        private final String myCode;
        private final String myVersion;
        private final int myHashCode;
        private Boolean myUserSelected;

        public TagDefinitionCacheKey(TagTypeEnum theType, String theSystem, String theCode, String theVersion, Boolean theUserSelected) {
            this.myType = theType;
            this.mySystem = theSystem;
            this.myCode = theCode;
            this.myVersion = theVersion;
            this.myUserSelected = theUserSelected;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myType).append((Object)this.mySystem).append((Object)this.myCode).append((Object)this.myVersion).append((Object)this.myUserSelected).toHashCode();
        }

        public boolean equals(Object theO) {
            boolean retVal = false;
            if (theO instanceof TagDefinitionCacheKey) {
                TagDefinitionCacheKey that = (TagDefinitionCacheKey)theO;
                retVal = new EqualsBuilder().append((Object)this.myType, (Object)that.myType).append((Object)this.mySystem, (Object)that.mySystem).append((Object)this.myCode, (Object)that.myCode).isEquals();
            }
            return retVal;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

