/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import java.security.SecureRandom;

public class RandomTextUtils {
    private static final SecureRandom ourRandom = new SecureRandom();
    private static final String ALPHANUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static String newSecureRandomAlphaNumericString(int theLength) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theLength; ++i) {
            int nextInt = Math.abs(ourRandom.nextInt());
            b.append(ALPHANUMERIC_CHARS.charAt(nextInt % ALPHANUMERIC_CHARS.length()));
        }
        return b.toString();
    }

    public static int findMatchingClosingBrace(int theStartIndex, String theStr) {
        return RandomTextUtils.findMatchingClosingBrace(theStartIndex, theStr, '(', ')');
    }

    public static int findMatchingClosingBrace(int theStartIndex, String theStr, char theOpenBrace, char theClosingBrace) {
        int len = theStr.length();
        assert (theStartIndex >= 0);
        assert (theStartIndex < len);
        int balance = 0;
        for (int i = theStartIndex; i < len; ++i) {
            char next = theStr.charAt(i);
            if (next == theClosingBrace) {
                --balance;
            } else if (next == theOpenBrace) {
                ++balance;
            }
            if (balance != 0) continue;
            return i;
        }
        return -1;
    }
}

