/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.ObjectUtil;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.IdType;

public class ResourceCompartmentUtil {
    public static Optional<String> getPatientCompartmentIdentity(IBaseResource theResource, FhirContext theFhirContext, ISearchParamExtractor theSearchParamExtractor) {
        if (theResource == null) {
            return Optional.empty();
        }
        RuntimeResourceDefinition resourceDef = theFhirContext.getResourceDefinition(theResource);
        List<RuntimeSearchParam> patientCompartmentSps = ResourceCompartmentUtil.getPatientCompartmentSearchParams(resourceDef);
        if (patientCompartmentSps.isEmpty()) {
            return Optional.empty();
        }
        if (resourceDef.getName().equals("Patient")) {
            String compartmentIdentity = theResource.getIdElement().getIdPart();
            if (StringUtils.isBlank((CharSequence)compartmentIdentity)) {
                throw new MethodNotAllowedException(Msg.code((int)2475) + "Patient resource IDs must be client-assigned in patient compartment mode, or server id strategy must be UUID");
            }
            return Optional.of(compartmentIdentity);
        }
        return ResourceCompartmentUtil.getResourceCompartment("Patient", theResource, patientCompartmentSps, theSearchParamExtractor);
    }

    public static Optional<String> getResourceCompartment(String theCompartmentName, IBaseResource theResource, List<RuntimeSearchParam> theCompartmentSps, ISearchParamExtractor mySearchParamExtractor) {
        return ResourceCompartmentUtil.getResourceCompartmentReferences(theResource, theCompartmentSps, mySearchParamExtractor).map(t -> t.getReferenceElement().getValue()).map(IdType::new).filter(t -> theCompartmentName.equals(t.getResourceType())).map(IdType::getIdPart).filter(StringUtils::isNotBlank).findFirst();
    }

    @Nonnull
    public static Stream<IBaseReference> getResourceCompartmentReferences(IBaseResource theResource, List<RuntimeSearchParam> theCompartmentSps, ISearchParamExtractor mySearchParamExtractor) {
        return theCompartmentSps.stream().flatMap(param -> Arrays.stream(BaseSearchParamExtractor.splitPathsR4((String)param.getPath()))).filter(StringUtils::isNotBlank).flatMap(path -> mySearchParamExtractor.getPathValueExtractor((IBase)theResource, path).get().stream()).flatMap(base -> ObjectUtil.castIfInstanceof((Object)base, IBaseReference.class).stream());
    }

    @Nonnull
    public static List<RuntimeSearchParam> getPatientCompartmentSearchParams(RuntimeResourceDefinition resourceDef) {
        return resourceDef.getSearchParams().stream().filter(param -> param.getParamType() == RestSearchParameterTypeEnum.REFERENCE).filter(param -> param.getProvidesMembershipInCompartments() != null && param.getProvidesMembershipInCompartments().contains("Patient")).collect(Collectors.toList());
    }
}

